#ifndef _MAP_H_
#define _MAP_H_

//---------------------------------------------------------------------------
#define MAP_MAX_W           8193
#define MAP_MAX_H           8193

#define MAP_DIV             16
#define MAP_DIV_BITS        4

#define MAX_STARS           256
#define MAX_AREAS           256
#define STAR_OFF            800
#define MAP_MAGIC           821

//---------------------------------------------------------------------------
typedef struct AREA
    {
     int    used;                       //daca este definita
     int    x1, y1;                     //coordonatele
     int    x2, y2;                     //
    } AREA;

typedef struct STAR
    {
     float  x, y, z;
     float  vx, vy;
     int    w, h;
     int    bright;

     struct STAR *next, *prev;
    } STAR;

typedef struct MAP
    {
     int    w, h;
     int    line_w, line_h;
     float  ver;

     int    _init_;
     int    _shutdown_;
     int    _draw_;
     int    _process_;

     scInstance *prog;

     struct UNIT **line[MAP_MAX_H/MAP_DIV];
    } MAP;
//---------------------------------------------------------------------------
STAR    *stars;
MAP     map;
AREA    areas[MAX_AREAS];

//---------------------------------------------------------------------------
void draw_stars();
void process_stars();
int  create_empty_map(int width, int height);
void destroy_map();
void save_game(char *name);
int  load_game(char *name);
int  load_map(char *name);
void unload_map();
void process_map();
void draw_map();
void fix_map_coords_f(float *x, float *y, int w, int h);
void fix_map_coords_centre_f(float *x, float *y, int w, int h);
void fix_map_coords(int *x, int *y, int w, int h);
void fix_map_coords_centre(int *x, int *y, int w, int h);
void draw_trace(int x, int y, struct UNIT *val);
struct UNIT *get_trace(int x, int y, struct UNIT *val);

//---------------------------------------------------------------------------
#endif
