/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Map handling functions. Load/Save etc...
 */

#include "standard.h"
#include "map.h"

#include "radar.h"
#include "script.h"
#include "file.h"
#include "alliance.h"
#include "gfx.h"
#include "misc.h"
#include "unit.h"
#include "player.h"
#include "bullet.h"
#include "panel.h"
#include "gui.h"
#include "particle.h"

#define SAVE_TIMER(t) pack_iputl(game_count-t, f);
#define LOAD_TIMER(t) t=game_count-pack_igetl(f);

#define SAVE_PLAYER_POINTER(p, f) pack_iputl(player2nr(p), f);

#define SAVE_UNIT_POINTER(u, f)                                    \
    {                                                              \
     if (u)                                                        \
        {                                                          \
         pack_iputl(u->player->nr, f);                             \
         pack_iputl(u->nr, f);                                     \
        }                                                          \
     else                                                          \
        {                                                          \
         pack_iputl(-1, f);                                        \
         pack_iputl(-1, f);                                        \
        }                                                          \
    }

#define LOAD_PLAYER_POINTER(p, f) p=nr2player(pack_igetl(f));

#define LOAD_UNIT_POINTER(u, f)                                    \
    {                                                              \
     int __i, __j;                                                 \
                                                                   \
     __i=pack_igetl(f);                                            \
     __j=pack_igetl(f);                                            \
                                                                   \
     u=nr2unit(nr2player(__i), __j);                               \
    }

/*****************************************************************************

    Function: add_star

    Description: adauga o stea la lista
    Parameters: (type) - marimea
    Return: pointer la stea daca ok
            NULL daca eroare

*****************************************************************************/
STAR *add_star(float x, float y, float z)
{
 STAR *temp;

 temp=alloc_mem(sizeof(STAR));
 if (!temp) return NULL;

 temp->bright=100;
 temp->x=x;
 temp->y=y;
 temp->z=z;
 temp->w=16;
 temp->h=16;

 if (stars==NULL) stars=temp;
 else
    {
     temp->next=stars;
     stars->prev=temp;
     stars=temp;
    }

 return temp;
}
/*****************************************************************************

    Function: remove_star

    Description: sterge o stea din lista
    Parameters: pionter la stea
    Return: N/A

*****************************************************************************/
void remove_star(STAR *o)
{
 if (!o) return;

 if (stars==o)
    {
     stars=o->next;
     if (o->next) o->next->prev=NULL;
    }
 else
    {
     if (o->prev) o->prev->next=o->next;
     if (o->next) o->next->prev=o->prev;
    }

 free_mem(o);
}
/*****************************************************************************

    Function: draw_stars

    Description: deseneaza stelele
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void draw_stars()
{
 STAR *temp;
 int xs, ys;

 drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);

 for(temp=stars; temp; temp=temp->next)
    {
     xs=(temp->x - camera_x)/temp->z+(CAMERA_W>>1);
     ys=(temp->y - camera_y)/temp->z+(CAMERA_H>>1);

     if (xs>=0 && xs<CAMERA_W && ys>=0 && ys<CAMERA_H)
        {
         set_trans_blend(0, 0, 0, temp->bright);
         putpixel(camera, xs, ys, makecol(200, 200, 200));

         add_dirty(xs, ys, 1, 1, 2);
        }
    }

 drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}
/*****************************************************************************

    Function: process stars

    Description: proceseaza stelele. Ele dispar in spatele ecranului si apar
                 aleator din fata
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void process_stars()
{
 STAR *temp;
 float x, y, rot;

 for (temp=stars; temp; temp=temp->next)
    {
     x=(temp->x - camera_x)/temp->z;
     y=(temp->y - camera_y)/temp->z;

     if (x<-STAR_OFF || x>STAR_OFF || y<-STAR_OFF || y>STAR_OFF)
        {
         rot=get_rot(x, y, temp->vx, temp->vy)+(rand()%80)-40;

         temp->x=camera_x+fixtof(fixcos(ftofix(rot)))*temp->z*STAR_OFF;
         temp->y=camera_y+fixtof(fixsin(ftofix(rot)))*temp->z*STAR_OFF;

         temp->vx=x; temp->vy=y;
        }

     if (rand()%256<64)
        {
         temp->bright+=(rand()%32)-16;
         temp->bright=MID(0, temp->bright, 255);
        }
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int add_area(int x1, int y1, int x2, int y2)
{
 int i;

 for (i=0;i<MAX_AREAS;i++)
  if (!areas[i].used)
    {
     areas[i].used=1;
     areas[i].x1=x1;
     areas[i].y1=y1;
     areas[i].x1=x1;
     areas[i].y1=y1;
    }

 return (i<MAX_AREAS)?0:-1;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void clear_area(int index)
{
 areas[index].used=0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void clear_areas()
{
 memset(areas, 0, sizeof(AREA)*MAX_AREAS);
}
/*****************************************************************************

    Function: create_map

    Description: creaza o noua harta de dimensiune WidthxHeight - patrate de 8x8
    Parameters: width, height
    Return:  0 daca totul a decurs bine
            -1 daca a aparut o eroare si eroarea in error_msg

*****************************************************************************/
int create_empty_map(int width, int height)
{
 int i, j;

 clear_areas();

 width=MID(2048, width, MAP_MAX_W);
 height=MID(2048, height, MAP_MAX_H);

 map.ver=VER;
 map.w=width;
 map.h=height;
 map.line_w=width/MAP_DIV;
 map.line_h=height/MAP_DIV;

 for (i=0;i<map.line_h;i++)
    {
     map.line[i]=alloc_mem(sizeof(struct UNIT *)*map.line_w);
     if (!map.line[i])
        {
         sprintf(error_msg, "Failed to allocate %d bytes for a %dx%d map (line %d)", map.line_w*map.line_h*4, width, height, i);
         error_flag=1;

         for (j=0;j<i;j++) free_mem(map.line[j]);

         return -1;
        }

     memset(map.line[i], 0, sizeof(struct UNIT *)*map.line_w);
    }

 for (i=0;i<256;i++) add_star((rand()%STAR_OFF*8)-STAR_OFF*4, (rand()%STAR_OFF*8)-STAR_OFF*4, ((float)(rand()%512)/128.0)+3);

 shutdown_radar();
 init_radar();

 return 0;
}
/*****************************************************************************

    Function: destroy_map

    Description: distruge harta dezalocand memoria alocata
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void destroy_map()
{
 int i;

 while (stars) remove_star(stars);

 for (i=0;i<map.line_h;i++) if (map.line[i]) free_mem(map.line[i]);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int load_map(char *filename)
{
 scInstance *prog;

 scSeeR_Set(scSeeR_StackSize, map_stack_size);
 prog=compile_file("map\\", filename);
 if (!prog) return -1;

 unload_map();

 start_time=game_count;

 map.prog=prog;

 map._init_    =scGet_Symbol(map.prog, "init");
 map._shutdown_=scGet_Symbol(map.prog, "shutdown");
 map._draw_    =scGet_Symbol(map.prog, "draw");
 map._process_ =scGet_Symbol(map.prog, "process");

 CALL_SCRIPT(&map, init);
 if (error_flag) fatal(0);

 REDRAW(panel_dialog, SELECTION_OBJ);
 REDRAW(panel_dialog, COMMAND_OBJ);

 return 0;
}
/*****************************************************************************

    Function: end_game

    Description: termina un joc
    Parameters: N/A
    Return: 0, -1

*****************************************************************************/
void unload_map()
{
 scScript code;

 while (players) remove_player(players);
 while (particles) remove_particle(particles);

 destroy_map();

 if (map.prog)
    {
     CALL_SCRIPT(&map, shutdown);
//     code=map.prog->code;
     scFree_Instance(map.prog);
//     free_mem(code);
    }

 memset(&map, 0, sizeof(MAP));
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_script(scScript script, PACKFILE *f)
{
 int size;

 assert(script);

 size=scGet_Script_Size(script);

 pack_iputl(size, f);
 if (size>0) pack_fwrite(script, size, f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_instance(scInstance *prog, scScript script, PACKFILE *f)
{
 enum {regCS=240,regDS,regES,regSS,regIP,regSP,regBP,
   /*counter=1*//*FORKED N.*/
      regCX,regCP,regIE,regFN,regOPTIONS};
            /*Call Stack Ptr*/
 int size;

 if (!prog)
    {
     pack_iputl(-1, f);
     return;
    }
 else pack_iputl(1, f);

#define hdrAllSize              3
#define hdrHeaderSize           4
#define hdrSymbolOffset         5
#define hdrCodeOffset           6
#define hdrDataOffset           7
#define hdrConstsOffset         8
#define hdrInitOffset           9
#define hdrCodeSize             10
#define hdrDataSize             11
#define hdrConstsSize           12
#define hdrStackSize            13
#define hdrImportedOffset       14
#define hdrConstructOffset      15
#define hdrDestructOffset       16

#define ToINT(ch) ((int*)(ch))
#define ReadINT(ptr,x) memcpy(&(x),ptr,4)
#define WriteINT(ptr,x) memcpy(ptr,&(x),4)
#define ToCodeINT(script) ((int*)script)
#define Register(inst) ((int*)inst->data_stack)

 pack_fwrite(prog, sizeof(scInstance), f);

 size=256*4+ToCodeINT(prog->code)[hdrDataSize]+ToCodeINT(prog->code)[hdrStackSize];

 pack_iputl(size, f);
 pack_fwrite(prog->data_stack, size, f);

 if (script) _save_script(script, f);

 pack_iputl(Register(prog)[regDS]-(ToCodeINT(prog->code)[hdrDataOffset]+(int)prog->data_stack+256*4), f);
 pack_iputl(Register(prog)[regES]-(ToCodeINT(prog->code)[hdrConstsOffset]+(int)prog->code), f);
 pack_iputl(Register(prog)[regSS]-(Register(prog)[regDS]+ToCodeINT(prog->code)[hdrDataSize]), f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_anim(ANIM *a, scInstance *prog, PACKFILE *f)
{
 scScript script;

 if (!a)
    {
     pack_iputl(-1, f);
     return;
    }
 else pack_iputl(1, f);

 pack_fwrite(a, sizeof(ANIM), f);

 if (!a->prog)
    {
     pack_iputl(-1, f);
     return;
    }
 else pack_iputl(1, f);

 script=prog?prog->code:NULL;
 _save_instance(a->prog, script, f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_radar(RADAR *r, PACKFILE *f)
{
 int i;

 for (i=0;i<128;i++) pack_fwrite(r->pages[0]->line[i], 128, f);
 for (i=0;i<128;i++) pack_fwrite(r->pages[1]->line[i], 128, f);

 pack_iputl(r->ready_page, f);

 SAVE_UNIT_POINTER(r->last_unit, f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_player(PLAYER *p, PACKFILE *f)
{
/* int i, j;

 assert(p);

 pack_fwrite(p, sizeof(PLAYER), f);

 for (i=0;i<MAX_SELECTED;i++) SAVE_UNIT_POINTER(p->selection[i], f);

 for (j=0;j<MAX_GROUPS;j++)
 for (i=0;i<MAX_SELECTED;i++) SAVE_UNIT_POINTER(p->group[j].selection[i], f);

 _save_radar(p->radar, f);
 _save_instance(p->prog, NULL, f);
// LOG("\nSaved player nr %d", p->nr);
*/}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_unit(UNIT *u, PACKFILE *f)
{
 int i;

 assert(u);

 pack_fwrite(u, sizeof(UNIT), f);
 SAVE_UNIT_POINTER(u->attacker, f);

 for (i=0;i<MAX_ORDERS;i++)
    {
     SAVE_UNIT_POINTER(((UNIT *)u->orders[i].target), f)
     SAVE_UNIT_POINTER(((UNIT *)u->orders[i].temp_target), f)
    }

 for (i=0;i<MAX_BUILDS;i++) SAVE_UNIT_POINTER(u->builds[i].unit, f);

 _save_instance(u->prog, NULL, f);

 _save_anim(u->anim, NULL, f);
 _save_anim(u->icon, NULL, f);
// LOG("\n\tSaved unit nr %d", u->nr);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _save_bullet(BULLET *b, PACKFILE *f)
{
 assert(b);

 pack_fwrite(b, sizeof(BULLET), f);
 SAVE_UNIT_POINTER(b->target, f);
 _save_anim(b->anim, NULL, f);
// LOG("\n\t\tSaved bullet nr %d, t_unit %d", b->nr, unit2nr(b->target));
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
/*void _save_building(BUILDING *b, PACKFILE *f)
{
 assert(b);

 pack_fwrite(b, sizeof(BUILDING), f);
 _save_anim(b->anim, NULL, f);
// LOG("\nSaved buinding");
}
*//*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
scScript _load_script(PACKFILE *f)
{
 int size;
 scScript script;

 script=NULL;

 size=pack_igetl(f);
 if (size>0)
    {
     script=alloc_mem(size);
     if (!script)
        {
         error_flag=1;
         return NULL;
        }

     pack_fread(script, size, f);
    }

 return script;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
scInstance *_load_instance(scScript script, PACKFILE *f)
{
 enum {regCS=240,regDS,regES,regSS,regIP,regSP,regBP,
   /*counter=1*//*FORKED N.*/
      regCX,regCP,regIE,regFN,regOPTIONS};
            /*Call Stack Ptr*/
 scInstance *prog;
 int size, i;

 i=pack_igetl(f);
 if (i<0) return NULL;

 prog=alloc_mem(sizeof(scInstance));
 if (!prog)
    {
     error_flag=1;
     return NULL;
    }

 pack_fread(prog, sizeof(scInstance), f);
 prog->code=NULL;

 size=pack_igetl(f);
 prog->data_stack=alloc_mem(size);
 if (!prog->data_stack)
    {
     error_flag=1;
     return NULL;
    }

 pack_fread(prog->data_stack, size, f);

 if (!script) prog->code=_load_script(f);
 else prog->code=script;

 Register(prog)[regDS]=pack_igetl(f) + ToCodeINT(prog->code)[hdrDataOffset]+(int)prog->data_stack+256*4;//DS -real pointer
 Register(prog)[regES]=pack_igetl(f) + ToCodeINT(prog->code)[hdrConstsOffset]+(int)prog->code;//ES -real
 Register(prog)[regSS]=pack_igetl(f) + Register(prog)[regDS]+ToCodeINT(prog->code)[hdrDataSize];//SS -real,probably+ToCodeINT(scrpt)[10]

 return prog;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
ANIM *_load_anim(scInstance *prog, PACKFILE *f)
{
 int i;
 ANIM *a;
 scScript script;

 i=pack_igetl(f);
 if (i<0) return NULL;

 a=alloc_mem(sizeof(ANIM));
 if (!a)
    {
     error_flag=1;
     return NULL;
    }

 pack_fread(a, sizeof(ANIM), f);

 i=pack_igetl(f);
 if (i<0) return a;

 script=prog?prog->code:NULL;
 a->prog=_load_instance(script, f);

 return a;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
RADAR *_load_radar(PACKFILE *f)
{
 int i;
 RADAR *r;

 r=alloc_mem(sizeof(RADAR));
 if (!r)
    {
     error_flag=1;
     return NULL;
    }

 r->pages[0]=create_bitmap_ex(8, 128, 128);
 r->pages[1]=create_bitmap_ex(8, 128, 128);
 if (!r->pages[0] || !r->pages[1])
    {
     error_flag=1;
     return NULL;
    }

 for (i=0;i<128;i++) pack_fread(r->pages[0]->line[i], 128, f);
 for (i=0;i<128;i++) pack_fread(r->pages[1]->line[i], 128, f);

 r->ready_page=pack_igetl(f);

 LOAD_UNIT_POINTER(r->last_unit, f);

 return r;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _load_player(PLAYER *p, PACKFILE *f)
{
/* UNIT *units, *last_unit;
 PLAYER *next, *prev;
 int i, j;

 assert(p);

 units=p->units;
 last_unit=p->last_unit;
 next=p->next;
 prev=p->prev;

 pack_fread(p, sizeof(PLAYER), f);

 p->units=units;
 p->last_unit=last_unit;
 p->next=next;
 p->prev=prev;

 for (i=0;i<MAX_SELECTED;i++) LOAD_UNIT_POINTER(p->selection[i], f);

 for (j=0;j<MAX_GROUPS;j++)
 for (i=0;i<MAX_SELECTED;i++)
    LOAD_UNIT_POINTER(p->group[j].selection[i], f);

 p->radar=_load_radar(f);
 if (error_flag) return;

 p->prog=_load_instance(brain_script, f);
 if (error_flag) return;
 //LOG("\nLoaded player nr %d", p->nr);
*/}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _load_unit(UNIT *u, PACKFILE *f)
{
 int i;
 PLAYER *p;
 BULLET *bullets;
 UNIT *next, *prev;

 assert(u);

 bullets=u->bullets;
 next=u->next;
 prev=u->prev;
 p=u->player;

 pack_fread(u, sizeof(UNIT), f);

 u->bullets=bullets;
 u->next=next;
 u->prev=prev;
 u->player=p;

 LOAD_UNIT_POINTER(u->attacker, f);

 for (i=0;i<MAX_ORDERS;i++)
    {
     LOAD_UNIT_POINTER(((UNIT *)u->orders[i].target), f)
     LOAD_UNIT_POINTER(((UNIT *)u->orders[i].temp_target), f)
    }

 for (i=0;i<MAX_BUILDS;i++) LOAD_UNIT_POINTER(u->builds[i].unit, f);

 u->prog=_load_instance(unit_prop[u->type].script, f);
 if (error_flag) return;

 u->anim=_load_anim(unit_prop[u->type].anim->prog, f);
 if (error_flag) return;

 u->icon=_load_anim(unit_prop[u->type].icon->prog, f);
 if (error_flag) return;
 //LOG("\n\tLoaded unit nr %d", u->nr);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _load_bullet(BULLET *b, PACKFILE *f)
{
 UNIT *u;
 BULLET *next, *prev;

 assert(b);

 next=b->next;
 prev=b->prev;
 u=b->unit;

 pack_fread(b, sizeof(BULLET), f);

 b->next=next;
 b->prev=prev;
 b->unit=u;

 LOAD_UNIT_POINTER(b->target, f);

 b->anim=_load_anim(weapon_prop[b->type].anim->prog, f);
 if (error_flag) return;
 //LOG("\n\t\tLoaded bullet nr %d, t_unit %d", b->nr, unit2nr(b->target));
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
/*void _load_building(BUILDING *b, PACKFILE *f)
{
 BUILDING *next, *prev;

 assert(b);

 next=b->next;
 prev=b->prev;

 pack_fread(b, sizeof(BUILDING), f);

 b->next=next;
 b->prev=prev;

 b->anim=_load_anim(building_prop[b->type].anim->prog, f);
 if (error_flag) return;
 //LOG("\nLoaded building");
}
*//*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void save_game(char *filename)
{
 PLAYER *ptemp;
 UNIT   *utemp;
 BULLET *btemp;
// BUILDING *gtemp;
 long   timer;
 char   name[256];

 PACKFILE *f;

 timer=game_count;

 sprintf(name, "%s\\save\\%s", game_dir, filename);

// f=pack_fopen(name, F_WRITE_PACKED);
 f=pack_fopen(name, F_WRITE_NOPACK);
 if (!f)
    {
     sprintf(error_msg, "Failed to create '%s'", name);
     error_flag=1;

     return;
    }

 pack_iputl(AL_ID('8', '2', '1', 'A'), f);  //magic
 pack_iputl(map.ver, f);                    //versiunea
 pack_iputl(map.w, f);                      //latimea
 pack_iputl(map.h, f);                      //inaltimea
 _save_instance(map.prog, map.prog->code, f);

 //scrie intai toate elementele cu numerele lor
 for (ptemp=players; ptemp; ptemp=ptemp->next)
    {
     pack_iputl(ptemp->nr, f);

     for (utemp=ptemp->units; utemp; utemp=utemp->next)
        {
         pack_iputl(utemp->nr, f);

         for (btemp=utemp->bullets; btemp; btemp=btemp->next) pack_iputl(btemp->nr, f);
         pack_iputl(-1, f);//sfarsitul gloantelor
        }
     pack_iputl(-1, f);//sfarsitul unitatilor
    }
 pack_iputl(-1, f);//sfarsitul playerilor

// for (gtemp=buildings; gtemp; gtemp=gtemp->next) pack_iputl(gtemp->nr, f);
// pack_iputl(-1, f);//sfarsitul cladirilor

 //acum salveaza restul datelor pt fiecare element
 for (ptemp=players; ptemp; ptemp=ptemp->next)
    {
     pack_iputl(ptemp->nr, f);
     _save_player(ptemp, f);

     for (utemp=ptemp->units; utemp; utemp=utemp->next)
        {
         pack_iputl(utemp->nr, f);
         _save_unit(utemp, f);

         for (btemp=utemp->bullets; btemp; btemp=btemp->next)
            {
//           LOG("\nsaving bullet nr %d, parent unit nr %d", btemp->nr, utemp->nr);
             pack_iputl(btemp->nr, f);
             _save_bullet(btemp, f);
            }
         pack_iputl(-1, f);
        }
     pack_iputl(-1, f);
    }
 pack_iputl(-1, f);

/* for (gtemp=buildings; gtemp; gtemp=gtemp->next)
    {
     pack_iputl(gtemp->nr, f);
     _save_building(gtemp, f);
    }
 pack_iputl(-1, f);//sfarsitul cladirilor
*/
 pack_iputl(me->nr, f);//scrie cine e jucatorul local

 pack_fwrite(relations, MAX_PLAYERS*MAX_PLAYERS, f);
// LOG("\n me=%d", me->nr);

 game_count=timer;

 pack_fclose(f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int load_game(char *filename)
{
 PLAYER *ptemp;
 UNIT   *utemp;
 BULLET *btemp;
// BUILDING *gtemp;
 long   timer;
 char   name[256];
 int    i, j, k;
 PACKFILE *f;

 error_flag=0;
 timer=game_count;

 sprintf(name, "%s\\save\\%s", game_dir, filename);

 f=pack_fopen(name, F_READ_PACKED);
// f=pack_fopen(name,   F_READ);
 if (!f)
    {
     sprintf(error_msg, "Failed to open '%s'", filename);
     error_flag=1;

     return -1;
    }
// LOG("\n\n\nload - opened file %s",   name);

 if (pack_igetl(f)!=AL_ID('8', '2', '1', 'A'))
    {
     sprintf(error_msg, "'%s' - Corrupted map file", filename);
     error_flag=1;

     pack_fclose(f);
     return -1;
    }
// LOG("\nload - magic ok");

 i=pack_igetl(f);
 if (i!=VER)
    {
     sprintf(error_msg, "'%s' - Wrong map version. Expected %.2f, got %.2f", filename, (double)VER/100, (double)i/100);
     error_flag=1;

     pack_fclose(f);
     return -1;
    }
// LOG("\nload - version ok (%.2f)", (double)i/100);

 unload_map();
 create_empty_map(pack_igetl(f), pack_igetl(f));
// LOG("\nload - created map (%dx%d)", map.w, map.h);

 map.prog=_load_instance(NULL, f);

 //citeste intai toate elementele cu numerele lor
 for (i=pack_igetl(f); i>=0; i=pack_igetl(f))
    {
     ptemp=alloc_mem(sizeof(PLAYER));
     if (!ptemp) goto GENERIC_ERROR;

     ptemp->nr=i;
     link_player(ptemp);

     for (j=pack_igetl(f); j>=0; j=pack_igetl(f))
        {
         utemp=alloc_mem(sizeof(UNIT));
         if (!utemp) goto GENERIC_ERROR;

         utemp->nr=j;
         link_unit(ptemp, utemp);

         for (k=pack_igetl(f); k>=0; k=pack_igetl(f))
            {
             btemp=alloc_mem(sizeof(BULLET));
             if (!btemp) goto GENERIC_ERROR;

             btemp->nr=k;
             link_bullet(utemp, btemp);
            }
        }
    }

/* for (k=pack_igetl(f); k>=0; k=pack_igetl(f))
    {
     gtemp=alloc_mem(sizeof(BUILDING));
     if (!gtemp) goto GENERIC_ERROR;

     gtemp->nr=k;
     link_building(gtemp);
    }
*/
 for (i=pack_igetl(f); i>=0; i=pack_igetl(f))
    {
     ptemp=nr2player(i);
     if (!ptemp) goto GENERIC_ERROR;

     _load_player(ptemp, f);
     if (error_flag) goto GENERIC_ERROR;

     for (j=pack_igetl(f); j>=0; j=pack_igetl(f))
        {
         utemp=nr2unit(ptemp, j);
         if (!utemp) goto GENERIC_ERROR;

         _load_unit(utemp, f);
         if (error_flag) goto GENERIC_ERROR;

         for (k=pack_igetl(f); k>=0; k=pack_igetl(f))
            {
             btemp=nr2bullet(utemp, k);
             if (!btemp) goto GENERIC_ERROR;

             _load_bullet(btemp, f);
             if (error_flag) goto GENERIC_ERROR;
            }
        }
    }

/* for (k=pack_igetl(f); k>=0; k=pack_igetl(f))
    {
     gtemp=nr2building(k);
     if (!gtemp) goto GENERIC_ERROR;

     _load_building(gtemp, f);
     if (error_flag) goto GENERIC_ERROR;
    }
*/
 me=nr2player(pack_igetl(f));
 if (!me) goto GENERIC_ERROR;

 pack_fread(relations, MAX_PLAYERS*MAX_PLAYERS, f);
// LOG("\nme=%d", me->nr);

 pack_fclose(f);

 REDRAW(panel_dialog, SELECTION_OBJ);
 REDRAW(panel_dialog, COMMAND_OBJ);

 game_count=timer;

 return 0;

GENERIC_ERROR:
 pack_fclose(f);

 sprintf(error_msg, "Generic error while opening '%s'. Loaded 'start.map'.", filename);
 REDRAW(panel_dialog, SELECTION_OBJ);
 REDRAW(panel_dialog, COMMAND_OBJ);

 game_count=timer;

 players=NULL;
// buildings=NULL;
 map.prog=NULL;

 load_map("start.map");

 return -1;
}
/*****************************************************************************

    Function: fix_map_coords

    Description: se asigura ca coordonatele sunt in harta
    Parameters: (x, y, w, h) - pozitia si dimensiunile obiectului
    Return: N/A

*****************************************************************************/
void fix_map_coords_f(float *x, float *y, int w, int h)
{
 w+=4;
 h+=4;

 if ((*x)<0) *x=0;
 if ((*y)<0) *y=0;

 if ((*x)+w>=map.w) (*x)=map.w-w-1;
 if ((*y)+h>=map.h) (*y)=map.h-h-1;
}
/*****************************************************************************

    Function: fix_map_coords

    Description: se asigura ca coordonatele sunt in harta
    Parameters: (x, y, w, h) - pozitia si dimensiunile obiectului
    Return: N/A

*****************************************************************************/
void fix_map_coords_centre_f(float *x, float *y, int w, int h)
{
 w+=4;
 h+=4;

 if ((*x)-w/2<0) *x=w/2;
 if ((*y)-h/2<0) *y=h/2;

 if ((*x)+w/2>=map.w) (*x)=map.w-w/2-1;
 if ((*y)+h/2>=map.h) (*y)=map.h-h/2-1;
}
/*****************************************************************************

    Function: fix_map_coords

    Description: se asigura ca coordonatele sunt in harta
    Parameters: (x, y, w, h) - pozitia si dimensiunile obiectului
    Return: N/A

*****************************************************************************/
void fix_map_coords(int *x, int *y, int w, int h)
{
 w+=4;
 h+=4;

 if ((*x)<0) *x=0;
 if ((*y)<0) *y=0;

 if ((*x)+w>=map.w) (*x)=map.w-w-1;
 if ((*y)+h>=map.h) (*y)=map.h-h-1;
}
/*****************************************************************************

    Function: fix_map_coords

    Description: se asigura ca coordonatele sunt in harta
    Parameters: (x, y, w, h) - pozitia si dimensiunile obiectului
    Return: N/A

*****************************************************************************/
void fix_map_coords_centre(int *x, int *y, int w, int h)
{
 w+=4;
 h+=4;

 if ((*x)-w/2<0) *x=w/2;
 if ((*y)-h/2<0) *y=h/2;

 if ((*x)+w/2>=map.w) (*x)=map.w-w/2-1;
 if ((*y)+h/2>=map.h) (*y)=map.h-h/2-1;
}
/*****************************************************************************

    Function: draw_trace

    Description: deseneaza urma unitatii
    Parameters: (x, y) - coordonatele unitatii
                (val)  - valoarea ce se va inscrie in memorie
    Return: N/A

*****************************************************************************/
void draw_trace(int x, int y, struct UNIT *val)
{
 int mx, my, w, h, i, j;
 struct UNIT **u, **v;

 w=MID(3, (val->anim->w>>MAP_DIV_BITS)-2, 8);
 h=MID(3, (val->anim->h>>MAP_DIV_BITS)-2, 8);
 mx=(x>>MAP_DIV_BITS)-(w>>1);
 my=(y>>MAP_DIV_BITS)-(h>>1);

 if (mx<0) mx=0;
 if (my<0) my=0;
 if (mx+w-1>map.line_w) mx=map.line_w-w-2;
 if (my+h-1>map.line_h) my=map.line_h-h-2;

 u=map.line[my];
 v=map.line[my+h-1];
 for (i=1;i<w-1;i++)
    {
     u[mx+i]=val;
     v[mx+i]=val;
    }

 for (j=1;j<h-1;j++)
    {
     u=map.line[my+j];
     for (i=0;i<w;i++) u[mx+i]=val;
    }
}
/*****************************************************************************

    Function: get_trace

    Description: verifica daca o la pozitia (x, y) este o alta valoare decat (val)
    Parameters: (x, y) - coordonatele unitatii
                (val)  - valoarea ce se verifica
    Return:  daca gaseste o valoare diferita o returneaza
             daca nu, atunci returneaza val

*****************************************************************************/
UNIT *get_trace(int x, int y, UNIT *val)
{
 int mx, my, w, h, i, j;
 UNIT *r;
 UNIT **u, **v;

 w=MID(3, (val->anim->w>>MAP_DIV_BITS)-2, 8);
 h=MID(3, (val->anim->h>>MAP_DIV_BITS)-2, 8);
 mx=(x>>MAP_DIV_BITS)-(w>>1);
 my=(y>>MAP_DIV_BITS)-(h>>1);

 if (mx<0) mx=0;
 if (my<0) my=0;
 if (mx+w-1>map.line_w) mx=map.line_w-w-2;
 if (my+h-1>map.line_h) my=map.line_h-h-2;

 u=map.line[my];
 v=map.line[my+h-1];
 for (i=1;i<w-1;i++)
    {
     r=u[mx+i];
     if (r && r!=val) return r;

     r=v[mx+i];
     if (r && r!=val) return r;
    }

 for (j=1;j<h-1;j++)
    {
     u=map.line[my+j];
     for (i=0;i<w;i++)
        {
         r=u[mx+i];
         if (r && r!=val) return r;
        }
    }

 return val;
}
/*****************************************************************************

    Function: draw_map

    Description: deseneaza stele etc
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void draw_map()
{
 draw_stars();

 CALL_SCRIPT(&map, draw);
}
/*****************************************************************************

    Function: process_map

    Description: proceseaza totul legat de harta
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void process_map()
{
 process_stars();

 CALL_SCRIPT(&map, process);
}
