/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	GUI object functions. Many of them are modified copies of the allegro ones
 */

#include "standard.h"
#include "gui.h"

#include "gfx.h"
#include "alliance.h"
#include "misc.h"
#include "panel.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int cs_box_proc(CS_DIALOG *d, int msg, int c)
{
 int i;
 static RLE_SPRITE *tl=NULL, *t=NULL, *tr=NULL, *l=NULL, *r=NULL, *bl=NULL, *b=NULL, *br=NULL;
 
 if (msg==MSG_INIT)
	{
	 d->w=(d->w/16)*16;
	 d->h=(d->h/16)*16;

	 i=get_object(gfx, "GUI_BORDER000"); if (i>0) tl=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER001"); if (i>0) t=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER002"); if (i>0) tr=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER003"); if (i>0) l=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER004"); if (i>0) r=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER005"); if (i>0) bl=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER006"); if (i>0) b=gfx[i].dat;
	 i=get_object(gfx, "GUI_BORDER007"); if (i>0) br=gfx[i].dat;
	}

 if (msg!=MSG_DRAW) return D_O_K;

 rectfill(buffer, d->x+14, d->y+14, d->x+d->w-14, d->y+d->h-14, 0);
 
 draw_rle_sprite(buffer, tl, d->x, d->y);
 for (i=1;i<d->w/16-1;i++) draw_rle_sprite(buffer, t, d->x+i*16, d->y);
 draw_rle_sprite(buffer, tr, d->x+d->w-17, d->y);
 for (i=1;i<d->h/16-1;i++) draw_rle_sprite(buffer, l, d->x, d->y+i*16);
 for (i=1;i<d->h/16-1;i++) draw_rle_sprite(buffer, r, d->x+d->w-17, d->y+i*16);
 draw_rle_sprite(buffer, bl, d->x, d->y+d->h-17);
 for (i=1;i<d->w/16-1;i++) draw_rle_sprite(buffer, b, d->x+i*16, d->y+d->h-17);
 draw_rle_sprite(buffer, br, d->x+d->w-17, d->y+d->h-17);
 
 add_dirty(d->x, d->y, d->w, d->h, 2);

 return D_O_K;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int cs_button_proc(CS_DIALOG *d, int msg, int c)
{
 int i;
 static RLE_SPRITE *img[]={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
 int mx, my;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 d->dp3=gfx[font3].dat;

 switch (msg)
	{
	 case MSG_INIT:
		if (!img[d->d1])
			{
			 i=get_object(gfx, "GUI_BUTTON000"); 
			 if (i<0) return D_CLOSE;
			 img[d->d1]=gfx[i+d->d1].dat;
			}

		d->fg=0;
		d->w=img[d->d1]->w;
		d->h=img[d->d1]->h;
		break;

	 case MSG_DRAW:
		if (d->flags&FLAG_DISABLED) 
			{
			 set_trans_blender(0, 0, 0, 0);
			 draw_lit_rle_sprite(buffer, img[d->d1], d->x, d->y, 128);
			}
		else draw_rle_sprite(buffer, img[d->d1], d->x, d->y);

		aa_textout_centre(buffer, d->dp3, d->dp, d->x+img[d->d1]->w/2, d->y+img[d->d1]->h/2-text_height(d->dp3)/2, d->fg);
		if (d->fg && d->dp2) show_tip(d->dp2, mx, my-32, 0, 0, SCREEN_W, d->y);

		add_dirty(d->x, d->y, d->w, d->h, 2);

		d->fg=0;
        d->flags&=~FLAG_PRESSED;
		break;

	 case MSG_MOUSE_OVER:
		d->fg=makecol(140, 140, 255);
		break;

	 case MSG_DCLICK:
	 case MSG_MOUSE_PRESSED:
        d->flags=FLAG_PRESSED;
		d->fg=makecol(255, 255, 255);
		break;

	 case MSG_MOUSE_RELEASED:
		return D_CLOSE;
	}

 return D_O_K;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int cs_text_proc(CS_DIALOG *d, int msg, int c)
{
 switch (msg)
	{
	 case MSG_INIT:
		d->dp2=gfx[font3].dat;
		d->w=text_length(d->dp2, d->dp);
		d->h=text_height(d->dp2);
		break;

	 case MSG_DRAW:
		if (d->flags&FLAG_DISABLED) aa_textout(buffer, d->dp2, d->dp, d->x, d->y, makecol(64, 64, 64));
		else aa_textout(buffer, d->dp2, d->dp, d->x, d->y, d->fg);

		add_dirty(d->x, d->y, d->w, d->h, 2);
		break;
	}

 return D_O_K;
}

