#ifndef _GUI_H_
#define _GUI_H_

//---------------------------------------------------------------------------
#define MAX_MSGS                    16

#define FLAG_DISABLED               1
#define FLAG_PRESSED                2
#define FLAG_TIP                    4
#define FLAG_DIRTY                  8

#define MSG_INIT                    1773
#define MSG_SHUTDOWN                1774
#define MSG_PROCESS                 1775
#define MSG_MOUSE_PRESSED           1776
#define MSG_KEY_PRESSED             1777
#define MSG_MOUSE_RELEASED          1778
#define MSG_KEY_RELEASED            1779
#define MSG_MOUSE_OVER              1780

#define REDRAW(dialog, object) (dialog[(object)].flags|=FLAG_DIRTY)

//---------------------------------------------------------------------------
typedef struct CS_DIALOG
    {
     int    (*proc)();
     int    x, y;
     int    w, h;
     int    fg, bg;
     int    flags;

     int    d1, d2;
     void   *dp, *dp2, *dp3;
    } CS_DIALOG;

typedef struct CS_DIALOG_PLAYER
    {
     struct CS_DIALOG *dialog;
     int	focus;
     int	last_mouse_b;
     int    ret;
     long	timer;
	 int	objects;
     unsigned char key[128];
    } CS_DIALOG_PLAYER;

typedef struct CS_MSG
    {
     int    pos;
     long   time;
     int    color;
     FONT   *font;
     char   *text;
    } CS_MSG;

//---------------------------------------------------------------------------
struct CS_MSG msgs[MAX_MSGS];
int           msg_count;

//---------------------------------------------------------------------------
int wnd_proc(CS_DIALOG *wnd, int msg, int c);

CS_DIALOG_PLAYER *init_cs_dialog(CS_DIALOG *dialog);
void shutdown_cs_dialog(CS_DIALOG_PLAYER *player);
void draw_cs_dialog(CS_DIALOG_PLAYER *player);
void process_cs_dialog(CS_DIALOG_PLAYER *player);
void _process_cs_dialog(CS_DIALOG_PLAYER *player);

int add_msg(FONT *f, int time, int color, char *format, ...);
void draw_msgs();
void process_msgs();

//---------------------------------------------------------------------------
#endif
