/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	GUI messaging functions.
 */

#include "standard.h"
#include "gui.h"

#include "gfx.h"
#include "alliance.h"
#include "file.h"
#include "misc.h"

/*****************************************************************************

    Function: wnd_proc

    Description: procedura generala pt fereastra
    Parameters:
    Return:

*****************************************************************************/
int default_proc(CS_DIALOG *d, int msg, int c)
{
 c=c;

 switch (msg)
    {
     case MSG_INIT:
        break;

     case MSG_DRAW:
        break;

     case MSG_PROCESS:
        break;

     case MSG_MOUSE_PRESSED:
         d->flags|=FLAG_PRESSED;
        break;

     case MSG_MOUSE_RELEASED:
         d->flags&=~FLAG_PRESSED;
        break;

     case MSG_MOUSE_OVER:
        break;

     case MSG_SHUTDOWN:
         return D_EXIT;
        break;
    }

 return D_O_K;
}

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
CS_DIALOG_PLAYER *init_cs_dialog(CS_DIALOG *dialog)
{
 int i;
 CS_DIALOG_PLAYER *player;

 player=alloc_mem(sizeof(CS_DIALOG_PLAYER));
 if (!player) return NULL;

 player->dialog=dialog;
 player->timer=1;
 player->focus=-1;

 for (i=0;dialog[i].proc;i++)
     {
      dialog[i].flags|=FLAG_DIRTY;
      (*dialog[i].proc)(&dialog[i], MSG_INIT, 0);
     }

 player->objects=i;

 return player;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void shutdown_cs_dialog(CS_DIALOG_PLAYER *player)
{
 CS_DIALOG *dialog;
 int i;

 if (!player) return;
 dialog=player->dialog;

 for (i=0;dialog[i].proc;i++) (*dialog[i].proc)(&dialog[i], MSG_SHUTDOWN, 0);

 free_mem(player);
 player=NULL;
}
/*****************************************************************************

    Function: draw_wnds

    Description: deseneaza ferestrele
    Parameters:
    Return:

*****************************************************************************/
void draw_cs_dialog(CS_DIALOG_PLAYER *player)
{
 CS_DIALOG *dialog;
 int i;

 if (!player) return;
 dialog=player->dialog;

 for (i=0;dialog[i].proc;i++) (*dialog[i].proc)(&dialog[i], MSG_DRAW, 0);

 _process_cs_dialog(player);//proceseaza doar la draw
}
/*****************************************************************************

    Function: process_wnds

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _process_cs_dialog(CS_DIALOG_PLAYER *player)
{
 CS_DIALOG *dialog;
 int mx, my, i, j;
 int ret, ret1;

 if (!player) return;
 dialog=player->dialog;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 ret=D_O_K;
 //trimite mesajele cu tastele apasate
 for (i=0;i<128;i++)
  if (key[i]!=player->key[i])
    {
     int msg;

     if (key[i]) msg=MSG_KEY_PRESSED;
     else msg=MSG_KEY_RELEASED;

     for (j=0;dialog[j].proc;j++) 
        {
         ret1=(*dialog[j].proc)(&dialog[j], msg, i);
         if (ret1!=D_O_K) ret=ret1;
        }

     player->key[i]=key[i];
    }

 //trimite mesaje despre mouse
 for (i=player->objects-1; i>=0; i--) 
    {
     if (player->focus<0)
        {
         if (mx>dialog[i].x && my>dialog[i].y && mx<dialog[i].x+dialog[i].w && my<dialog[i].y+dialog[i].h)
            {
             ret1=(*dialog[i].proc)(&dialog[i], MSG_MOUSE_OVER, 0);
             if (ret1!=D_O_K) ret=ret1;

             if (mouse_b)
                {
                 if (mouse_b==1 && game_count-player->timer<200)
                    {
                     ret1=(*dialog[i].proc)(&dialog[i], MSG_DCLICK, mouse_b);
                     if (ret1!=D_O_K) ret=ret1;

                     player->timer=0;
                    }
                 else if (player->timer>0)
                    {
                     player->focus=i;
                     player->last_mouse_b=mouse_b;
                    }
                }
             else if (player->timer==0) player->timer=1;
            }
        }
     else
        {
         if (mx>dialog[i].x && my>dialog[i].y && mx<dialog[i].x+dialog[i].w && my<dialog[i].y+dialog[i].h) 
            {
             ret1=(*dialog[i].proc)(&dialog[i], MSG_MOUSE_OVER, 0);
             if (ret1!=D_O_K) ret=ret1;
            }

         if (mouse_b) 
            {
             ret1=(*dialog[player->focus].proc)(&dialog[player->focus], MSG_MOUSE_PRESSED, mouse_b);
             if (ret1!=D_O_K) ret=ret1;
            }
         else
            {
             ret1=(*dialog[player->focus].proc)(&dialog[player->focus], MSG_MOUSE_RELEASED, player->last_mouse_b);
             if (ret1!=D_O_K) ret=ret1;

             if (player->last_mouse_b==1) player->timer=game_count;
             player->focus=-1;
            }
        }
    }

 player->ret=ret;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_cs_dialog(CS_DIALOG_PLAYER *player)
{
 CS_DIALOG *dialog;
 int i, ret, ret1;

 if (!player) return;
 dialog=player->dialog;

 ret=D_O_K;
 for (i=0;dialog[i].proc;i++) 
    {
     ret1=(*dialog[i].proc)(&dialog[i], MSG_PROCESS, 0);
     if (ret1!=D_O_K) ret=ret1;
    }

 player->ret=ret;
 //_process_cs_dialog(player);//proceseaza doar la draw
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int add_msg(FONT *f, int time, int color, char *format, ...)
{
 char buf[512];

 va_list ap;
 va_start(ap, format);
 vsprintf(buf, format, ap);
 va_end(ap);

 if (msg_count>=MAX_MSGS-2) return msg_count;

 msgs[msg_count].font=f;
 msgs[msg_count].time=time;
 msgs[msg_count].color=color;
 msgs[msg_count].text=strdup(buf);
 msgs[msg_count].pos=0;

 msg_count++;

 return msg_count;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_msgs()
{
 int i, w, h;
 char c;
 BITMAP *temp;

 set_add_blend(0, 0, 0, 255);

 for (i=0;i<msg_count;i++)
    {
     c=msgs[i].text[msgs[i].pos];
     msgs[i].text[msgs[i].pos]=0;

     w=text_length(msgs[i].font, msgs[i].text);
     h=text_height(msgs[i].font);

     temp=create_bitmap(w, h);
     if (temp)
        {
         clear_sprite(temp);
         textout(temp, msgs[i].font, msgs[i].text, 0, 0, msgs[i].color);
         draw_trans_sprite(buffer, temp, 2, 30+i*h);

         add_dirty(2, 30+i*h, w, h, 2);

         destroy_bitmap(temp);
        }

     msgs[i].text[msgs[i].pos]=c;
     if (msgs[i].pos < strlen(msgs[i].text)) msgs[i].pos++;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_msgs()
{
 int i;

 for (i=0;i<msg_count;i++) msgs[i].time--;

 if (msgs[0].time<=0 && msg_count>0)
    {
     for (i=0;i<msg_count-1;i++) memcpy(&msgs[i], &msgs[i+1], sizeof(CS_MSG));

     msg_count--;
    }
}
