#ifndef _GFXSW_H_
#define _GFXSW_H_

//--------------------------------------------------------------------------
//#include "main.h"
//--------------------------------------------------------------------------
#define MAX_SPRITES                     8000
#define MAX_ROTATIONS                   64
#define ROTATION_DIV                    4
#define ROTATION_DIV_BITS               3
#define SPRITE_CACHE_BANK_SIZE          1000

#define FIX_ANGLE(a) {while(a<0) a+=256; a%=256;}

#define draw_sprite_centre(bmp, sprite, x, y) draw_sprite(bmp, sprite, x-(sprite->w>>1), y-(sprite->h>>1))
#define draw_trans_sprite_centre(bmp, sprite, x, y) draw_trans_sprite(bmp, sprite, x-(sprite->w>>1), y-(sprite->h>>1))
#define draw_lit_sprite_centre(bmp, sprite, x, y, c) draw_lit_sprite(bmp, sprite, x-(sprite->w>>1), y-(sprite->h>>1), c)

#define draw_rle_sprite_centre(bmp, sprite, x, y) draw_rle_sprite(bmp, sprite, x-(sprite->w>>1), y-(sprite->h>>1))
#define draw_trans_rle_sprite_centre(bmp, sprite, x, y) draw_trans_rle_sprite(bmp, sprite, x-(((RLE_SPRITE *)sprite)->w>>1), y-(((RLE_SPRITE *)sprite)->h>>1))
#define draw_lit_rle_sprite_centre(bmp, sprite, x, y, c) draw_lit_rle_sprite(bmp, sprite, x-(sprite->w>>1), y-(sprite->h>>1), c)

#define mem_rotate_trans_sprite_centre(bmp, s, x, y, a, m) mem_rotate_trans_sprite(bmp, s, x-(s->w>>1), y-(s->h>>1), a, m)
#define draw_target_centre(bmp, x, y, w, h, s, c, rot) draw_target(bmp, (x)-((w)>>1), (y)-((h)>>1), (w), (h), (s), (c), (rot))

#define _getr15(a) (a>>10)
#define _getg15(a) ((a>>5)&31)
#define _getb15(a) (a&31)

#define _getr16(a) (a>>11)
#define _getg16(a) ((a>>5)&63)
#define _getb16(a) (a&31)

#define _makecol15(r, g, b) (r_table[(r)] | g_table[(g)] | b_table[(b)])
#define _makecol16(r, g, b) (r_table[(r)] | g_table[(g)] | b_table[(b)])

//---------------------------------------------------------------------------
typedef struct SPRITE_CACHE
    {
     RLE_SPRITE **rot;

     int rot_count;                     //cate rotatii are memorate
     int size;                          //memoria ocupata la un moment dat de sprite (suma size-urilor rotatiilor din cache)
     long timer;                        //de cand nu a mai fost afisata
    } SPRITE_CACHE;

//--------------------------------------------------------------------------
SPRITE_CACHE sprite_cache[MAX_SPRITES];
int sprite_cache_bank;

unsigned char dirty_list[RES_MAX_H/DIRTY_DIV][RES_MAX_W/DIRTY_DIV];
int dirty_w, dirty_h;

unsigned short int *current_palette;//paleta curenta
unsigned short int palette[8][256];//paletele prelucrate
unsigned short int r_table[256], g_table[256], b_table[256];
unsigned long _blender_alpha2;

int sprite_cache_size, max_sprite_cache_size, sprite_cache_timeout;

//--------------------------------------------------------------------------
void flush_sprite_cache(int size);

//--------------------------------------------------------------------------

#endif