/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Graphics functions. Really messy...
 */

#include "standard.h"
#include "gfx.h"
#include "gfxsw.h"
#include <allegro/internal/aintern.h>

#include "alliance.h"
#include "player.h"
#include "file.h"
#include "misc.h"

#define _fixtoi(x) ((x) >> 16)/* + ((x & 0x8000) >> 15)*/
#define _itofix(x) ((x) << 16)


/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
__inline void sw_add_dirty(int x, int y, int w, int h, int n, int x1, int y1, int x2, int y2)
{
 register unsigned char j;
 char x8, y8, w8, h8;
 char rx, ry;
 register unsigned char *d, *e;

 x8=x>>DIRTY_DIV_BITS;
 y8=y>>DIRTY_DIV_BITS;
 rx=x-(x8<<DIRTY_DIV_BITS);
 ry=y-(y8<<DIRTY_DIV_BITS);
 w8=((w+rx)>>DIRTY_DIV_BITS) + 1;
 h8=((h+ry)>>DIRTY_DIV_BITS) + 1;
 x1>>=DIRTY_DIV_BITS;
 y1>>=DIRTY_DIV_BITS;
 x2>>=DIRTY_DIV_BITS;
 y2>>=DIRTY_DIV_BITS;

 if (y8<y1)
    {
     h8-=(y1-y8);
     y8=y1;
    }
 if (y8+h8>=y2) h8=y2-y8;

 if (x8<x1)
    {
     w8-=(x1-x8);
     x8=x1;
    }
 if (x8+w8>=x2) w8=x2-x8;

 h8+=y8;
 for (j=y8;j<h8;j++)
    {
     d=dirty_list[j]+x8;
	 e=d+w8;
     for (;d<e;d++) *d=n;
    }
}
/*****************************************************************************

    Function: get_rle_sprite16

    Description: get_rle_sprite optimizat pt 16 biti
    Parameters:
    Return:

*****************************************************************************/
#define DO_MEM_GET_RLE(bpp)                                                 \
    {                                                                       \
     signed short *p;                                                       \
     unsigned short *d, *e;                                                     \
                                                                            \
     _grow_scratch_mem(w*h*8);                                              \
     p = (short *)_scratch_mem;                                             \
     if (!p) return NULL;                                                   \
                                                                            \
     c = 0;                                                                 \
     for (y=0; y<h; y++)                                                    \
        {                                                                   \
         d=(unsigned short *)bitmap->line[y];                               \
         e=d+w;                                                             \
                                                                            \
         run = -1;                                                          \
         for (; d<e; d++)                                                   \
            {                                                               \
             pix = (*d);                                                    \
             if (pix != MASK_COLOR_##bpp)                                   \
                {                                                           \
                 if ((run >= 0) && (p[run] > 0) && (p[run] < 127)) p[run]++;\
                 else                                                       \
                    {                                                       \
                     run = c;                                               \
                     p[c++] = 1;                                            \
                    }                                                       \
                 p[c++] = pix;                                              \
                }                                                           \
             else                                                           \
                {                                                           \
                 if ((run >= 0) && (p[run] < 0) && (p[run] > -128)) p[run]--;\
                 else                                                       \
                    {                                                       \
                     run = c;                                               \
                     p[c++] = -1;                                           \
                    }                                                       \
                }                                                           \
            }                                                               \
         p[c++] = MASK_COLOR_##bpp;                                         \
        }                                                                   \
                                                                            \
     c *= 2;                                                                \
                                                                            \
     s = malloc(sizeof(RLE_SPRITE) + c);                                    \
     if (s)                                                                 \
        {                                                                   \
         s->w = w;                                                          \
         s->h = h;                                                          \
         s->color_depth = depth;                                            \
         s->size = c;                                                       \
         memcpy(s->dat, _scratch_mem, c);									\
        }                                                                   \
    }

#define DO_MEM_GET_256_RLE(bpp)                                             \
    {                                                                       \
     signed short *p;                                                       \
     unsigned char *d, *e;                                                  \
                                                                            \
     _grow_scratch_mem(w*h*8);                                              \
     p = (signed short *)_scratch_mem;                                      \
     if (!p) return NULL;                                                   \
                                                                            \
     c = 0;                                                                 \
     for (y=0; y<h; y++)                                                    \
        {                                                                   \
         d=bitmap->line[y];                                                 \
         e=d+w;                                                             \
                                                                            \
         run = -1;                                                          \
         for (; d<e; d++)                                                   \
            {                                                               \
             pix = (*d);                                                    \
             if (pix != 0)                                                  \
                {                                                           \
                 if ((run >= 0) && (p[run] > 0) && (p[run] < 127)) p[run]++;\
                 else                                                       \
                    {                                                       \
                     run = c;                                               \
                     p[c++] = 1;                                            \
                    }                                                       \
                 p[c++] = current_palette[pix];                             \
                }                                                           \
             else                                                           \
                {                                                           \
                 if ((run >= 0) && (p[run] < 0) && (p[run] > -128)) p[run]--;\
                 else                                                       \
                    {                                                       \
                     run = c;                                               \
                     p[c++] = -1;                                           \
                    }                                                       \
                }                                                           \
            }                                                               \
         p[c++] = MASK_COLOR_##bpp;                                         \
        }                                                                   \
                                                                            \
     c *= 2;                                                                \
                                                                            \
     s = malloc(sizeof(RLE_SPRITE) + c);                                    \
     if (s)                                                                 \
        {                                                                   \
         s->w = w;                                                          \
         s->h = h;                                                          \
         s->color_depth = depth;                                            \
         s->size = c;                                                       \
         memcpy(s->dat, _scratch_mem, c);									\
        }                                                                   \
    }

RLE_SPRITE *mem_get_rle_sprite(BITMAP *bitmap)
{
 RLE_SPRITE *s=NULL;
 int y;
 int w=bitmap->w, h=bitmap->h;
 int run;
 int pix;
 int c;

 switch (bitmap_color_depth(bitmap))
    {
     case 8:
        switch(depth)
            {
             case 15:DO_MEM_GET_256_RLE(15);break;
             case 16:DO_MEM_GET_256_RLE(16);break;
            }
        break;

     case 15:DO_MEM_GET_RLE(15);break;
     case 16:DO_MEM_GET_RLE(16);break;

     default:
        set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
        LOG("\nmem_get_rle_sprite: Illegal color depth - %d.", bitmap_color_depth(bitmap));
        exit(1);
    }

 return s;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
#define PRE_ROTATE                                                          \
    {                                                                       \
     fw = itofix(w/2);                                                      \
     fh = itofix(h/2);                                                      \
     dir = fixatan2(fh, fw);                                                \
     dir2 = fixatan2(fh, -fw);                                              \
     dist = fixsqrt((wgap*wgap + hgap*hgap) << 6) << 4;                     \
     f1x = fw - fixmul(dist, fixcos(dir - angle));                          \
     f1y = fh - fixmul(dist, fixsin(dir - angle));                          \
                                                                            \
     f1xd = fixcos(itofix(64) - angle);                                     \
     f1yd = fixsin(itofix(64) - angle);                                     \
                                                                            \
     f2xd = fixcos(-angle);                                                 \
     f2yd = fixsin(-angle);                                                 \
                                                                            \
     x1 = fixtoi(fixmul(dist, fixcos(dir + angle)));                        \
     y1 = fixtoi(fixmul(dist, fixsin(dir + angle)));                        \
                                                                            \
     x2 = fixtoi(fixmul(dist, fixcos(dir2 + angle)));                       \
     y2 = fixtoi(fixmul(dist, fixsin(dir2 + angle)));                       \
                                                                            \
     x1 = MAX(ABS(x1), ABS(x2)) - wgap/2;                                   \
     y1 = MAX(ABS(y1), ABS(y2)) - hgap/2;                                   \
                                                                            \
     x -= x1;                                                               \
     wgap += x1 * 2;                                                        \
     f1x -= f2xd * x1;                                                      \
     f1y -= f2yd * x1;                                                      \
                                                                            \
     y -= y1;                                                               \
     hgap += y1 * 2;                                                        \
     f1x -= f1xd * y1;                                                      \
     f1y -= f1yd * y1;                                                      \
    }

#define AA_FUNC15                                                           \
    {                                                                       \
     r=(((cd&31) * xrat + (cc&31) * cxrat) * yrat + ((cb&31) * xrat + (ca&31) * cxrat) * cyrat)>>16;\
     g=(((((cd&992)>>5) * xrat + ((cc&992)>>5) * cxrat) * yrat + (((cb&992)>>5) * xrat + ((ca&992)>>5) * cxrat) * cyrat)>>11)&992;\
     b=(((((cd>>10)&31) * xrat + ((cc>>10)&31) * cxrat) * yrat + (((cb>>10)&31) * xrat + ((ca>>10)&31) * cxrat) * cyrat)>>6)&31744;\
    }                                                                       \

#define AA_FUNC16                                                           \
    {                                                                       \
     r=(((cd&31) * xrat + (cc&31) * cxrat) * yrat + ((cb&31) * xrat + (ca&31) * cxrat) * cyrat)>>16;\
     g=(((((cd&2016)>>5) * xrat + ((cc&2016)>>5) * cxrat) * yrat + (((cb&2016)>>5) * xrat + ((ca&2016)>>5) * cxrat) * cyrat)>>11)&2016;\
     b=(((((cd>>11)&31) * xrat + ((cc>>11)&31) * cxrat) * yrat + (((cb>>11)&31) * xrat + ((ca>>11)&31) * cxrat) * cyrat)>>5)&63488;\
    }                                                                       \

#define DO_MEM_GET_AA_ROTATED_RLE(bpp)                                      \
    {                                                                       \
     signed short *p;                                                       \
     unsigned short *base;                                                  \
     unsigned int ca, cb, cc, cd, xrat, yrat, cxrat, cyrat;                 \
     int r, g, b;                                                           \
                                                                            \
     _grow_scratch_mem(w*h*8);                                              \
     p = (signed short *)_scratch_mem;                                      \
     if (!p) return NULL;                                                   \
                                                                            \
     c=0;                                                                   \
     for (j=0; j<hgap; j++)                                                 \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         run=-1;                                                            \
         for (i=0; i<wgap; i++)                                             \
            {                                                               \
             pixel=MASK_COLOR_##bpp;                                        \
                                                                            \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w-1)                              \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h-1)                          \
                    {                                                       \
                     base=&((unsigned short *)sprite->line[yy])[xx];        \
                     ca = base [0];                                         \
                     if (ca!=MASK_COLOR_##bpp)                              \
                        {                                                   \
                         cb = base [1];                                     \
                         if (cb!=MASK_COLOR_##bpp)                          \
                            {                                               \
                             cc = base [w];                                 \
                             if (cc!=MASK_COLOR_##bpp)                      \
                                {                                           \
                                 cd = base [w + 1];                         \
                                 if (cd!=MASK_COLOR_##bpp)                  \
                                    {                                       \
                                     xrat = (f2x & 0xFFFF) >> 8;            \
                                     yrat = (f2y & 0xFFFF) >> 8;            \
                                     cxrat = 255 - xrat;                    \
                                     cyrat = 255 - yrat;                    \
                                                                            \
                                     AA_FUNC##bpp;                          \
                                                                            \
                                     pixel=(r|g|b);                         \
                                     if (pixel!=MASK_COLOR_##bpp)           \
                                        {                                   \
                                         if ((run >= 0) && (p[run] > 0) && (p[run] < 127)) p[run]++;\
                                         else                               \
                                            {                               \
                                             run = c;                       \
                                             p[c++] = 1;                    \
                                            }                               \
                                         p[c++] = pixel;                    \
                                         goto eol_label_aa_##bpp;           \
                                        }                                   \
                                    }                                       \
                                }                                           \
                            }                                               \
                        }                                                   \
                    }                                                       \
                }                                                           \
                                                                            \
             if ((run >= 0) && (p[run] < 0) && (p[run] > -128)) p[run]--;   \
             else                                                           \
                {                                                           \
                 run = c;                                                   \
                 p[c++] = -1;                                               \
                }                                                           \
eol_label_aa_##bpp:                                                         \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
         p[c++] = MASK_COLOR_##bpp;                                         \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
                                                                            \
     c *= 2;                                                                \
                                                                            \
     s = malloc(sizeof(RLE_SPRITE) + c);                                    \
     if (s)                                                                 \
        {                                                                   \
         s->w = wgap;                                                       \
         s->h = hgap;                                                       \
         s->color_depth = depth;                                            \
         s->size = c;                                                       \
         memcpy(s->dat, _scratch_mem, c);                                   \
        }                                                                   \
    }

#define DO_MEM_GET_256_AA_ROTATED_RLE(bpp)                                  \
    {                                                                       \
     signed short *p;                                                       \
     unsigned char *base;                                                   \
     unsigned int ca, cb, cc, cd, xrat, yrat, cxrat, cyrat;                 \
     int r, g, b;                                                           \
                                                                            \
     _grow_scratch_mem(w*h*8);                                              \
     p = (signed short *)_scratch_mem;                                      \
     if (!p) return NULL;                                                   \
                                                                            \
     c=0;                                                                   \
     for (j=0; j<hgap; j++)                                                 \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         run=-1;                                                            \
         for (i=0; i<wgap; i++)                                             \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w-1)                              \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h-1)                          \
                    {                                                       \
                     base=&sprite->line[yy][xx];                            \
                     ca = base [0];                                         \
                     if (ca!=0)                                             \
                        {                                                   \
                         cb = base [1];                                     \
                         if (cb!=0)                                         \
                            {                                               \
                             cc = base [w];                                 \
                             if (cc!=0)                                     \
                                {                                           \
                                 cd = base [w + 1];                         \
                                 if (cd!=0)                                 \
                                    {                                       \
                                     ca=current_palette[ca];                \
                                     cb=current_palette[cb];                \
                                     cc=current_palette[cc];                \
                                     cd=current_palette[cd];                \
                                                                            \
                                     xrat = (f2x & 0xFFFF) >> 8;            \
                                     yrat = (f2y & 0xFFFF) >> 8;            \
                                     cxrat = 255 - xrat;                    \
                                     cyrat = 255 - yrat;                    \
                                                                            \
                                     AA_FUNC##bpp;                          \
                                                                            \
                                     pixel=(r|g|b);                         \
                                     if (pixel!=MASK_COLOR_##bpp)           \
                                        {                                   \
                                         if ((run >= 0) && (p[run] > 0) && (p[run] < 127)) p[run]++;\
                                         else                               \
                                            {                               \
                                             run = c;                       \
                                             p[c++] = 1;                    \
                                            }                               \
                                         p[c++] = pixel;                    \
                                         goto eol_label_256_aa_##bpp;       \
                                        }                                   \
                                    }                                       \
                                }                                           \
                            }                                               \
                        }                                                   \
                    }                                                       \
                }                                                           \
                                                                            \
             if ((run >= 0) && (p[run] < 0) && (p[run] > -128)) p[run]--;   \
             else                                                           \
                {                                                           \
                 run = c;                                                   \
                 p[c++] = -1;                                               \
                }                                                           \
eol_label_256_aa_##bpp:                                                     \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
         p[c++] = MASK_COLOR_##bpp;                                         \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
                                                                            \
     c *= 2;                                                                \
                                                                            \
     s = malloc(sizeof(RLE_SPRITE) + c);                                    \
     if (s)                                                                 \
        {                                                                   \
         s->w = wgap;                                                       \
         s->h = hgap;                                                       \
         s->color_depth = depth;                                            \
         s->size = c;                                                       \
         memcpy(s->dat, _scratch_mem, c);                                   \
        }                                                                   \
    }

#define DO_MEM_GET_ROTATED_RLE(bpp)                                         \
    {                                                                       \
     signed short *p;                                                       \
                                                                            \
     _grow_scratch_mem(w*h*8);                                              \
     p = (signed short *)_scratch_mem;                                      \
     if (!p) return NULL;                                                   \
                                                                            \
     c=0;                                                                   \
     for (j=0; j<hgap; j++)                                                 \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         run=-1;                                                            \
         for (i=0; i<wgap; i++)                                             \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w)                                \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h)                            \
                    {                                                       \
                     pixel = ((unsigned short *)sprite->line[yy])[xx];      \
                     if (pixel!=MASK_COLOR_##bpp)                           \
                        {                                                   \
                         if ((run >= 0) && (p[run] > 0) && (p[run] < 127)) p[run]++;\
                         else                                               \
                            {                                               \
                             run = c;                                       \
                             p[c++] = 1;                                    \
                            }                                               \
                         p[c++] = pixel;                                    \
                         goto eol_label_##bpp;                              \
                        }                                                   \
                    }                                                       \
                }                                                           \
                                                                            \
             if ((run >= 0) && (p[run] < 0) && (p[run] > -128)) p[run]--;   \
             else                                                           \
                {                                                           \
                 run = c;                                                   \
                 p[c++] = -1;                                               \
                }                                                           \
eol_label_##bpp:                                                            \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
         p[c++] = MASK_COLOR_##bpp;                                         \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
                                                                            \
     c *= 2;                                                                \
                                                                            \
     s = malloc(sizeof(RLE_SPRITE) + c);                                    \
     if (s)                                                                 \
        {                                                                   \
         s->w = wgap;                                                       \
         s->h = hgap;                                                       \
         s->color_depth = depth;                                            \
         s->size = c;                                                       \
         memcpy(s->dat, _scratch_mem, c);                                   \
        }                                                                   \
    }

#define DO_MEM_GET_256_ROTATED_RLE(bpp)                                     \
    {                                                                       \
     signed short *p;                                                       \
                                                                            \
     _grow_scratch_mem(w*h*8);                                              \
     p = (signed short *)_scratch_mem;                                      \
     if (!p) return NULL;                                                   \
                                                                            \
     c=0;                                                                   \
     for (j=0; j<hgap; j++)                                                 \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         run=-1;                                                            \
         for (i=0; i<wgap; i++)                                             \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w)                                \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h)                            \
                    {                                                       \
                     pixel = sprite->line[yy][xx];                          \
                     if (pixel!=0)                                          \
                        {                                                   \
                         if ((run >= 0) && (p[run] > 0) && (p[run] < 127)) p[run]++;\
                         else                                               \
                            {                                               \
                             run = c;                                       \
                             p[c++] = 1;                                    \
                            }                                               \
                         p[c++] = current_palette[pixel];                   \
                         goto eol_label_256_##bpp;                          \
                        }                                                   \
                    }                                                       \
                }                                                           \
                                                                            \
             if ((run >= 0) && (p[run] < 0) && (p[run] > -128)) p[run]--;   \
             else                                                           \
                {                                                           \
                 run = c;                                                   \
                 p[c++] = -1;                                               \
                }                                                           \
eol_label_256_##bpp:                                                        \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
         p[c++] = MASK_COLOR_##bpp;                                         \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
                                                                            \
     c *= 2;                                                                \
                                                                            \
     s = malloc(sizeof(RLE_SPRITE) + c);                                    \
     if (s)                                                                 \
        {                                                                   \
         s->w = wgap;                                                       \
         s->h = hgap;                                                       \
         s->color_depth = depth;                                            \
         s->size = c;                                                       \
         memcpy(s->dat, _scratch_mem, c);                                   \
        }                                                                   \
    }

RLE_SPRITE *mem_get_rotated_rle_sprite(BITMAP *sprite, fixed angle, int aaliasing)
{
 fixed f1x, f1y, f1xd, f1yd;
 fixed f2x, f2y, f2xd, f2yd;
 fixed dir, dir2, dist;
 fixed fw, fh;
 short int x1, y1, x2, y2;
 register short int xx, yy;
 register short int j, i;
 register int   c;
 register short int run;
 short int w = sprite->w;
 short int h = sprite->h;
 short int wgap = w;
 short int hgap = h;
 unsigned short int pixel;
 short int x=0;
 short int y=0;
 RLE_SPRITE *s=NULL;

 angle=itofix(fixtoi(angle)/ROTATION_DIV*ROTATION_DIV);
 if (fixtoi(angle)%256==0) return mem_get_rle_sprite(sprite);

 PRE_ROTATE;

 switch (bitmap_color_depth(sprite))
    {
     case 8:
        switch(depth)
            {
             case 15:
                if (aaliasing) DO_MEM_GET_256_AA_ROTATED_RLE(15)
                else DO_MEM_GET_256_ROTATED_RLE(15);
                break;

             case 16:
                if (aaliasing) DO_MEM_GET_256_AA_ROTATED_RLE(16)
                else DO_MEM_GET_256_ROTATED_RLE(16);
                break;
            }
        break;

     case 15:
        if (aaliasing) DO_MEM_GET_AA_ROTATED_RLE(15)
        else DO_MEM_GET_ROTATED_RLE(15);
        break;

     case 16:
        if (aaliasing) DO_MEM_GET_AA_ROTATED_RLE(16)
        else DO_MEM_GET_ROTATED_RLE(16);
        break;

     default:
        set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
        LOG("\nmem_get_rotated_rle_sprite: Illegal color depth - %d.", bitmap_color_depth(sprite));
        exit(1);
    }

 return s;
}
/*****************************************************************************

    Function: mem_rotate_sprite16

    Description: roteste un sprite pe 16 biti in memorie - optimizat
    Parameters: blah
    Return: N/A

*****************************************************************************/
#define DO_MEM_AA_ROTATE(bpp, putpix)                                       \
    {                                                                       \
     register unsigned short *d, *we, *he;                                  \
     int _w;                                                                \
     unsigned short *base;                                                  \
     unsigned int ca, cb, cc, cd, xrat, yrat, cxrat, cyrat;                 \
     int r, g, b;                                                           \
                                                                            \
     d=&((unsigned short *)bmp->line[y])[x];                                \
     we=d+wgap;                                                             \
     he=d+bmp->w*hgap;                                                      \
     _w=bmp->w-wgap-1;                                                      \
                                                                            \
     for (; d<he; d+=_w, we=d+wgap)                                         \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w-1)                              \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h-1) break;                   \
                }                                                           \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w-1)                              \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h-1)                          \
                    {                                                       \
                     base=&((unsigned short *)sprite->line[yy])[xx];        \
                     ca = base [0];                                         \
                     if (ca!=MASK_COLOR_##bpp)                              \
                        {                                                   \
                         cb = base [1];                                     \
                         if (cb!=MASK_COLOR_##bpp)                          \
                            {                                               \
                             cc = base [w];                                 \
                             if (cc!=MASK_COLOR_##bpp)                      \
                                {                                           \
                                 cd = base [w + 1];                         \
                                 if (cd!=MASK_COLOR_##bpp)                  \
                                    {                                       \
                                     xrat = (f2x & 0xFFFF) >> 8;            \
                                     yrat = (f2y & 0xFFFF) >> 8;            \
                                     cxrat = 255 - xrat;                    \
                                     cyrat = 255 - yrat;                    \
                                                                            \
                                     AA_FUNC##bpp;                          \
                                                                            \
                                     pixel=r|g|b;                           \
                                     if (pixel!=MASK_COLOR_##bpp) {putpix;} \
                                    }                                       \
                                }                                           \
                            }                                               \
                        }                                                   \
                    }                                                       \
                 else {d=we+1; break;}                                        \
                }                                                           \
             else {d=we+1; break;}                                            \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
    }

#define DO_MEM_256_AA_ROTATE(bpp, putpix)                                   \
    {                                                                       \
     register unsigned short *d, *we, *he;                                  \
     int _w;                                                                \
     unsigned char *base;                                                   \
     unsigned int ca, cb, cc, cd, xrat, yrat, cxrat, cyrat;                 \
     int r, g, b;                                                           \
                                                                            \
     d=&((unsigned short *)bmp->line[y])[x];                                \
     we=d+wgap;                                                             \
     he=d+bmp->w*hgap;                                                      \
     _w=bmp->w-wgap-1;                                                      \
                                                                            \
     for (; d<he; d+=_w, we=d+wgap)                                         \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w-1)                              \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h-1) break;                   \
                }                                                           \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w-1)                              \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h-1)                          \
                    {                                                       \
                     base=&sprite->line[yy][xx];                            \
                     ca = base [0];                                         \
                     if (ca)                                                \
                        {                                                   \
                         cb = base [1];                                     \
                         if (cb)                                            \
                            {                                               \
                             cc = base [w];                                 \
                             if (cc)                                        \
                                {                                           \
                                 cd = base [w + 1];                         \
                                 if (cd)                                    \
                                    {                                       \
                                     ca=current_palette[ca];                \
                                     cb=current_palette[cb];                \
                                     cc=current_palette[cc];                \
                                     cd=current_palette[cd];                \
                                                                            \
                                     xrat = (f2x & 0xFFFF) >> 8;            \
                                     yrat = (f2y & 0xFFFF) >> 8;            \
                                     cxrat = 255 - xrat;                    \
                                     cyrat = 255 - yrat;                    \
                                                                            \
                                     AA_FUNC##bpp;                          \
                                                                            \
                                     pixel=r|g|b;                           \
                                     if (pixel!=MASK_COLOR_##bpp) {putpix;} \
                                    }                                       \
                                }                                           \
                            }                                               \
                        }                                                   \
                    }                                                       \
                 else {d=we+1; break;}                                        \
                }                                                           \
             else {d=we+1; break;}                                            \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
    }

#define DO_MEM_ROTATE(bpp, putpix)                                          \
    {                                                                       \
     register unsigned short *d, *we, *he;                                  \
     int _w;                                                                \
                                                                            \
     d=&((unsigned short *)bmp->line[y])[x];                                \
     we=d+wgap;                                                             \
     he=d+bmp->w*hgap;                                                      \
     _w=bmp->w-wgap-1;                                                      \
                                                                            \
     for (; d<he; d+=_w, we=d+wgap)                                         \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w)                                \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h) break;                     \
                }                                                           \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w)                                \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h)                            \
                    {                                                       \
                     pixel = ((unsigned short *)sprite->line[yy])[xx];      \
                     if (pixel!=MASK_COLOR_##bpp) {putpix;}                 \
                    }                                                       \
                 else {d=we+1;break;}                                       \
                }                                                           \
             else {d=we+1;break;}                                           \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
    }

#define DO_MEM_256_ROTATE(bpp, putpix)                                      \
    {                                                                       \
     register unsigned short *d, *we, *he;                                  \
     int _w;                                                                \
                                                                            \
     d=&((unsigned short *)bmp->line[y])[x];                                \
     we=d+wgap;                                                             \
     he=d+bmp->w*hgap;                                                      \
     _w=bmp->w-wgap-1;                                                      \
                                                                            \
     for (; d<he; d+=_w, we=d+wgap)                                         \
        {                                                                   \
         f2x = f1x;                                                         \
         f2y = f1y;                                                         \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w)                                \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h) break;                     \
                }                                                           \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         for (; d<=we; d++)                                                 \
            {                                                               \
             xx=_fixtoi(f2x);                                               \
             if ((unsigned)xx < (unsigned)w)                                \
                {                                                           \
                 yy=_fixtoi(f2y);                                           \
                 if ((unsigned)yy < (unsigned)h)                            \
                    {                                                       \
                     pixel = sprite->line[yy][xx];                          \
                     if (pixel!=0)                                          \
                        {                                                   \
                         pixel=current_palette[pixel];                      \
                         {putpix;}                                          \
                        }                                                   \
                    }                                                       \
                 else {d=we+1;break;}                                       \
                }                                                           \
             else {d=we+1;break;}                                           \
                                                                            \
             f2x += f2xd;                                                   \
             f2y += f2yd;                                                   \
            }                                                               \
                                                                            \
         f1x += f1xd;                                                       \
         f1y += f1yd;                                                       \
        }                                                                   \
    }

void mem_rotate_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, fixed angle, int aaliasing)
{
 fixed f1x, f1y, f1xd, f1yd;
 fixed f2x, f2y, f2xd, f2yd;
 fixed dir, dir2, dist;
 fixed fw, fh;
 short int x1, y1, x2, y2;
 short int xx, yy;
 short int w = sprite->w;
 short int h = sprite->h;
 short int wgap = w;
 short int hgap = h;
 register unsigned short int pixel;

 //face rotatia sa sara anumiti pasi pt ccache-ul nu retine toti pasii si
 //atunci cand foloseste cache alternativ, sa nu oscileze
 angle=itofix(fixtoi(angle)/ROTATION_DIV*ROTATION_DIV);

 PRE_ROTATE;

 /* clip the output rectangle */
 if (bmp->clip)
    {
     while (x < bmp->cl)
        {
         x++;
         wgap--;
         f1x += f2xd;
         f1y += f2yd;
        }

     while (y < bmp->ct)
        {
         y++;
         hgap--;
         f1x += f1xd;
         f1y += f1yd;
        }

     while (x+wgap >= bmp->cr) wgap--;
     while (y+hgap >= bmp->cb) hgap--;

     if ((wgap <= 0) || (hgap <= 0)) return;
    }

 switch (bitmap_color_depth(sprite))
    {
     case 8:
        switch(depth)
            {
             case 15:
                if (aaliasing) DO_MEM_256_AA_ROTATE(15, *d=pixel)
                else DO_MEM_256_ROTATE(15, *d=pixel);
                break;

             case 16:
                if (aaliasing) DO_MEM_256_AA_ROTATE(16, *d=pixel)
                else DO_MEM_256_ROTATE(16, *d=pixel);
                break;
            }
        break;

     case 15:
        if (aaliasing) DO_MEM_AA_ROTATE(15, *d=pixel)
        else DO_MEM_ROTATE(15, *d=pixel);
        break;

     case 16:
        if (aaliasing) DO_MEM_AA_ROTATE(16, *d=pixel)
        else DO_MEM_ROTATE(16, *d=pixel);
        break;

     default:
        set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
        LOG("\nmem_rotate_sprite: Illegal color depth - %d. (3)", bitmap_color_depth(sprite));
        exit(1);
    }
}
/*****************************************************************************

    Function: mem_rotate_trans_sprite16

    Description: roteste un sprite transparent pe 16 biti in memorie - optimizat
    Parameters: blah
    Return: N/A

*****************************************************************************/
void mem_rotate_trans_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, fixed angle, int aaliasing)
{
 fixed f1x, f1y, f1xd, f1yd;
 fixed f2x, f2y, f2xd, f2yd;
 fixed dir, dir2, dist;
 fixed fw, fh;
 int x1, y1, x2, y2;
 int xx, yy;
 int w = sprite->w;
 int h = sprite->h;
 int wgap = w;
 int hgap = h;
 int pixel;

 //face rotatia sa sara anumiti pasi pt ccache-ul nu retine toti pasii si
 //atunci cand foloseste cache alternativ, sa nu oscileze
 angle=itofix(fixtoi(angle)/ROTATION_DIV*ROTATION_DIV);

 PRE_ROTATE;

 /* clip the output rectangle */
 if (bmp->clip)
    {
     while (x < bmp->cl)
        {
         x++;
         wgap--;
         f1x += f2xd;
         f1y += f2yd;
        }

     while (y < bmp->ct)
        {
         y++;
         hgap--;
         f1x += f1xd;
         f1y += f1yd;
        }

     while (x+wgap >= bmp->cr) wgap--;
     while (y+hgap >= bmp->cb) hgap--;

     if ((wgap <= 0) || (hgap <= 0)) return;
    }

 switch (bitmap_color_depth(sprite))
    {
     case 8:
        switch(depth)
            {
             case 15:
                if (aaliasing) DO_MEM_256_AA_ROTATE(15, *d=_blender_func15(pixel, *d, _blender_alpha))
                else DO_MEM_256_ROTATE(15, *d=_blender_func15(pixel, *d, _blender_alpha));
                break;

             case 16:
                if (aaliasing) DO_MEM_256_AA_ROTATE(16, *d=_blender_func16(pixel, *d, _blender_alpha))
                else DO_MEM_256_ROTATE(16, *d=_blender_func16(pixel, *d, _blender_alpha));
                break;
            }
        break;

     case 15:
        if (aaliasing) DO_MEM_AA_ROTATE(15, *d=_blender_func15(pixel, *d, _blender_alpha))
        else DO_MEM_ROTATE(15, *d=_blender_func15(pixel, *d, _blender_alpha));
        break;

     case 16:
        if (aaliasing) DO_MEM_AA_ROTATE(16, *d=_blender_func16(pixel, *d, _blender_alpha))
        else DO_MEM_ROTATE(16, *d=_blender_func16(pixel, *d, _blender_alpha));
        break;

     default:
        set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
        LOG("\nmem_rotate_trans_sprite: Illegal color depth - %d.", bitmap_color_depth(sprite));
        exit(1);
    }
}
/*****************************************************************************

    Function: mem_rotate_lit_sprite16

    Description: roteste un sprite luminat pe 16 biti in memorie - optimizat
    Parameters: blah
    Return: N/A

*****************************************************************************/
void mem_rotate_lit_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, fixed angle, int color, int aaliasing)
{
 fixed f1x, f1y, f1xd, f1yd;
 fixed f2x, f2y, f2xd, f2yd;
 fixed dir, dir2, dist;
 fixed fw, fh;
 int x1, y1, x2, y2;
 int xx, yy;
 int w = sprite->w;
 int h = sprite->h;
 int wgap = w;
 int hgap = h;
 int pixel;

 //face rotatia sa sara anumiti pasi pt ccache-ul nu retine toti pasii si
 //atunci cand foloseste cache alternativ, sa nu oscileze
 angle=itofix(fixtoi(angle)/ROTATION_DIV*ROTATION_DIV);

 PRE_ROTATE;

 /* clip the output rectangle */
 if (bmp->clip)
    {
     while (x < bmp->cl)
        {
         x++;
         wgap--;
         f1x += f2xd;
         f1y += f2yd;
        }

     while (y < bmp->ct)
        {
         y++;
         hgap--;
         f1x += f1xd;
         f1y += f1yd;
        }

     while (x+wgap >= bmp->cr) wgap--;
     while (y+hgap >= bmp->cb) hgap--;

     if ((wgap <= 0) || (hgap <= 0)) return;
    }

 switch (bitmap_color_depth(sprite))
    {
     case 8:
        switch(depth)
            {
             case 15:
                if (aaliasing) DO_MEM_256_AA_ROTATE(15, *d=_blender_func15(_blender_col_15, pixel, color))
                else DO_MEM_256_ROTATE(15, *d=_blender_func15(_blender_col_15, pixel, color));
                break;

             case 16:
                if (aaliasing) DO_MEM_256_AA_ROTATE(16, *d=_blender_func16(_blender_col_16, pixel, color))
                else DO_MEM_256_ROTATE(16, *d=_blender_func16(_blender_col_16, pixel, color));
                break;
            }
        break;

     case 15:
        if (aaliasing) DO_MEM_AA_ROTATE(15, *d=_blender_func15(_blender_col_15, pixel, color))
        else DO_MEM_ROTATE(15, *d=_blender_func15(_blender_col_15, pixel, color));
        break;

     case 16:
        if (aaliasing) DO_MEM_AA_ROTATE(16, *d=_blender_func16(_blender_col_16, pixel, color))
        else DO_MEM_ROTATE(16, *d=_blender_func16(_blender_col_16, pixel, color));
        break;

     default:
        set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
        LOG("\nmem_rotate_lit_sprite: Illegal color depth - %d.", bitmap_color_depth(sprite));
        exit(1);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
#define DO_MEM_DRAW_RLE(bpp)                                                \
 if (dst->clip)                                                             \
    {                                                                       \
     int tmp;                                                               \
                                                                            \
     tmp = dst->cl - dx;                                                    \
     sxbeg = ((tmp < 0) ? 0 : tmp);                                         \
     dxbeg = sxbeg + dx;                                                    \
                                                                            \
     tmp = dst->cr - dx;                                                    \
     w = ((tmp > src->w) ? src->w : tmp) - sxbeg;                           \
     if (w <= 0) return;                                                    \
                                                                            \
     tmp = dst->ct - dy;                                                    \
     sybeg = ((tmp < 0) ? 0 : tmp);                                         \
     dybeg = sybeg + dy;                                                    \
                                                                            \
     tmp = dst->cb - dy;                                                    \
     h = ((tmp > src->h) ? src->h : tmp) - sybeg;                           \
     if (h <= 0) return;                                                    \
    }                                                                       \
 else                                                                       \
    {                                                                       \
     w = src->w;                                                            \
     h = src->h;                                                            \
     sxbeg = 0;                                                             \
     sybeg = 0;                                                             \
     dxbeg = dx;                                                            \
     dybeg = dy;                                                            \
    }                                                                       \
                                                                            \
 s = (signed short *) (src->dat);                                           \
                                                                            \
 /* Clip top.  */                                                           \
 for (y = sybeg - 1; y >= 0; y--)                                           \
     {                                                                      \
      long c = *s++;                                                        \
                                                                            \
      while ((unsigned short)c!=MASK_COLOR_##bpp)                           \
        {                                                                   \
         if (c>0) s+=c;                                                     \
         c = *s++;                                                          \
        }                                                                   \
     }                                                                      \
                                                                            \
 /* Visible part.  */                                                       \
 if (sxbeg || dx+src->w >= dst->cr)                                         \
    {                                                                       \
     for (y = 0; y < h; y++)                                                \
         {                                                                  \
          long c = *s++;                                                    \
                                                                            \
          d = ((unsigned short *)dst->line[dybeg + y])+dxbeg;               \
                                                                            \
          /* Clip left.  */                                                 \
          for (x = sxbeg; x > 0; )                                          \
              {                                                             \
               if (c==MASK_COLOR_##bpp) goto next_line_##bpp;               \
               else if (c > 0)                                              \
                 {                                                          \
                  /* Run of solid pixels.  */                               \
                  if ((x - c) >= 0)                                         \
                     {                                                      \
                      /* Fully clipped.  */                                 \
                      x -= c;                                               \
                      s += c;                                               \
                     }                                                      \
                  else                                                      \
                     {                                                      \
                      /* Visible on the right.  */                          \
                      c -= x;                                               \
                      s += x;                                               \
                      break;                                                \
                     }                                                      \
                 }                                                          \
               else                                                         \
                 {                                                          \
                  /* Run of transparent pixels.  */                         \
                  if ((x + c) >= 0)                                         \
                     {                                                      \
                      /* Fully clipped.  */                                 \
                      x += c;                                               \
                     }                                                      \
                  else                                                      \
                     {                                                      \
                      /* Visible on the right.  */                          \
                      c += x;                                               \
                      break;                                                \
                     }                                                      \
                 }                                                          \
                                                                            \
               c = *s++;                                                    \
              }                                                             \
                                                                            \
          /* Visible part.  */                                              \
          for (x = w; x > 0; )                                              \
             {                                                              \
              if (c==MASK_COLOR_##bpp) goto next_line_##bpp;                \
              else if (c > 0)                                               \
                 {                                                          \
                  /* Run of solid pixels.  */                               \
                  if ((x - c) >= 0)                                         \
                     {                                                      \
                      /* Fully visible.  */                                 \
                      x -= c;                                               \
                      for (c--; c >= 0; s++, d++, c--) {PUTPIXEL;}          \
                     }                                                      \
                  else                                                      \
                     {                                                      \
                      /* Clipped on the right.  */                          \
                      c -= x;                                               \
                      for (x--; x >= 0; s++, d++, x--) {PUTPIXEL;}          \
                      break;                                                \
                     }                                                      \
                 }                                                          \
              else                                                          \
                 {                                                          \
                  /* Run of transparent pixels.  */                         \
                  x += c;                                                   \
                  d = d-c;                                                  \
                 }                                                          \
                                                                            \
              c = *s++;                                                     \
             }                                                              \
                                                                            \
          /* Clip right.  */                                                \
          while ((unsigned short)c!=MASK_COLOR_##bpp)                       \
             {                                                              \
              if (c > 0) s += c;                                            \
              c = *s++;                                                     \
             }                                                              \
next_line_##bpp:;                                                           \
         }                                                                  \
    }                                                                       \
 else                                                                       \
    {                                                                       \
     for (y = 0; y < h; y++)                                                \
         {                                                                  \
          long c = *s++;                                                    \
                                                                            \
          d = ((unsigned short *)dst->line[dybeg + y])+dxbeg;               \
                                                                            \
          /* Visible part.  */                                              \
          for (x = w; x > 0; )                                              \
             {                                                              \
              if (c==MASK_COLOR_##bpp) goto next_line2_##bpp;               \
              else if (c > 0)                                               \
                 {                                                          \
                  /* Run of solid pixels.  */                               \
                  if ((x - c) >= 0)                                         \
                     {                                                      \
                      /* Fully visible.  */                                 \
                      x -= c;                                               \
                      for (c--; c >= 0; s++, d++, c--) {PUTPIXEL;}          \
                     }                                                      \
                  else                                                      \
                     {                                                      \
                      /* Clipped on the right.  */                          \
                      c -= x;                                               \
                      for (x--; x >= 0; s++, d++, x--) {PUTPIXEL;}          \
                      break;                                                \
                     }                                                      \
                 }                                                          \
              else                                                          \
                 {                                                          \
                  /* Run of transparent pixels.  */                         \
                  x += c;                                                   \
                  d = d-c;                                                  \
                 }                                                          \
                                                                            \
              c = *s++;                                                     \
             }                                                              \
next_line2_##bpp:;                                                          \
         }                                                                  \
    }                                                                       \

void _draw_trans_rle_sprite(BITMAP *dst, RLE_SPRITE *src, int dx, int dy)
{
 int x, y, w, h;
 int dxbeg, dybeg;
 int sxbeg, sybeg;
 short *s;
 unsigned short *d;
 int col1, col2, result, n;

 n = (_blender_alpha + 1) >> 3;

 if (depth==15)
    {
     #define PUTPIXEL                                                    \
        {                                                                \
         col2=*d;                                                        \
         col1=*(unsigned short *)s;                                      \
                                                                         \
         col1 = (col1 | (col1 << 16)) & 0x3E07C1F;                       \
         col2 = (col2 | (col2 << 16)) & 0x3E07C1F;                       \
                                                                         \
         result = (((col1 - col2) * n >> 5) + col2) & 0x3E07C1F;         \
                                                                         \
         *d=((result & 0xFFFF) | (result >> 16));                        \
        }
 
     DO_MEM_DRAW_RLE(15);

     #undef PUTPIXEL
    }
 else
    {
     #define PUTPIXEL                                                    \
        {                                                                \
         col2=*d;                                                        \
         col1=*(unsigned short *)s;                                      \
                                                                         \
         col1 = (col1 | (col1 << 16)) & 0x7E0F81F;                       \
         col2 = (col2 | (col2 << 16)) & 0x7E0F81F;                       \
                                                                         \
         result = (((col1 - col2) * n >> 5) + col2) & 0x7E0F81F;         \
                                                                         \
         *d=((result & 0xFFFF) | (result >> 16));                        \
        }

     DO_MEM_DRAW_RLE(16);

     #undef PUTPIXEL
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _draw_add_rle_sprite(BITMAP *dst, RLE_SPRITE *src, int dx, int dy)
{
 int x, y, w, h;
 int dxbeg, dybeg;
 int sxbeg, sybeg;
 short *s;
 unsigned short *d;
 int col1, col2, r, g, b, n;

 n = (_blender_alpha + 1) >> 3;

 if (depth==15)
    {
     #define PUTPIXEL                                                       \
        {                                                                   \
         col1=*d;                                                           \
         col2=*(unsigned short *)s;                                         \
                                                                            \
         r = _getr15(col1) + ((_getr15(col2)*n) >> 5);                      \
         g = _getg15(col1) + ((_getg15(col2)*n) >> 5);                      \
         b = _getb15(col1) + ((_getb15(col2)*n) >> 5);                      \
                                                                            \
         *d=_makecol15(r, g, b);                                            \
        }

     DO_MEM_DRAW_RLE(15);

     #undef PUTPIXEL
    }
 else
    {
     #define PUTPIXEL                                                       \
        {                                                                   \
         col1=*d;                                                           \
         col2=*(unsigned short *)s;                                         \
                                                                            \
         r = _getr16(col1) + ((_getr16(col2)*n) >> 5);                      \
         g = _getg16(col1) + ((_getg16(col2)*n) >> 5);                      \
         b = _getb16(col1) + ((_getb16(col2)*n) >> 5);                      \
                                                                            \
         *d=_makecol16(r, g, b);                                            \
        }

     DO_MEM_DRAW_RLE(16);

     #undef PUTPIXEL
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _draw_trans_add_rle_sprite(BITMAP *dst, RLE_SPRITE *src, int dx, int dy)
{
 int x, y, w, h;
 int dxbeg, dybeg;
 int sxbeg, sybeg;
 short *s;
 unsigned short *d;
 int col1, col2, c1, c2, result, n, n2, r, g, b;

 n = (_blender_alpha + 1) >> 3;
 n2 = (_blender_alpha2 + 1) >> 3;

 if (depth==15)
    {
     #define PUTPIXEL                                                    \
        {                                                                \
         col1=*(unsigned short *)s;                                      \
         col2=*d;                                                        \
                                                                         \
         if (_blender_col_15==0)                                         \
            {                                                            \
             c2=((col1 & 0xFFFF) | (col1 << 16)) & 0x3E07C1F;            \
                                                                         \
             result=(((0 - c2) * n >> 5) + c2) & 0x3E07C1F;              \
             result=((result & 0xFFFF) | (result >> 16));                \
                                                                         \
             r = _getr15(col2) + ((_getr15(result)*n2) >> 5);            \
             g = _getg15(col2) + ((_getg15(result)*n2) >> 5);            \
             b = _getb15(col2) + ((_getb15(result)*n2) >> 5);            \
                                                                         \
             *d=_makecol15(r, g, b);                                     \
            }                                                            \
         else                                                            \
            {                                                            \
             r = _getr15(col1) + ((_getr15(_blender_col_15)*n2) >> 5);   \
             g = _getg15(col1) + ((_getg15(_blender_col_15)*n2) >> 5);   \
             b = _getb15(col1) + ((_getb15(_blender_col_15)*n2) >> 5);   \
                                                                         \
             result=_makecol15(r, g, b);                                 \
                                                                         \
             c1 = ((result & 0xFFFF) | (result << 16)) & 0x3E07C1F;      \
             c2 = ((col2 & 0xFFFF) | (col2 << 16)) & 0x3E07C1F;          \
                                                                         \
             result = (((c1 - c2) * n >> 5) + c2) & 0x3E07C1F;           \
                                                                         \
             *d=((result & 0xFFFF) | (result >> 16));                    \
            }                                                            \
        }
 
     DO_MEM_DRAW_RLE(15);

     #undef PUTPIXEL
    }
 else
    {
     #define PUTPIXEL                                                    \
        {                                                                \
         col1=*(unsigned short *)s;                                      \
         col2=*d;                                                        \
                                                                         \
         if (_blender_col_16==0)                                         \
            {                                                            \
             c2=((col1 & 0xFFFF) | (col1 << 16)) & 0x7E0F81F;            \
                                                                         \
             result=(((0 - c2) * n >> 5) + c2) & 0x7E0F81F;              \
             result=((result & 0xFFFF) | (result >> 16));                \
                                                                         \
             r = _getr16(col2) + ((_getr16(result)*n2) >> 5);            \
             g = _getg16(col2) + ((_getg16(result)*n2) >> 5);            \
             b = _getb16(col2) + ((_getb16(result)*n2) >> 5);            \
                                                                         \
             *d=_makecol16(r, g, b);                                     \
            }                                                            \
         else                                                            \
            {                                                            \
             r = _getr16(col1) + ((_getr16(_blender_col_16)*n2) >> 5);   \
             g = _getg16(col1) + ((_getg16(_blender_col_16)*n2) >> 5);   \
             b = _getb16(col1) + ((_getb16(_blender_col_16)*n2) >> 5);   \
                                                                         \
             result=_makecol16(r, g, b);                                 \
                                                                         \
             c1 = ((result & 0xFFFF) | (result << 16)) & 0x7E0F81F;      \
             c2 = ((col2 & 0xFFFF) | (col2 << 16)) & 0x7E0F81F;          \
                                                                         \
             result = (((c1 - c2) * n >> 5) + c2) & 0x7E0F81F;           \
                                                                         \
             *d=((result & 0xFFFF) | (result >> 16));                    \
            }                                                            \
        }

     DO_MEM_DRAW_RLE(16);

     #undef PUTPIXEL
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
unsigned long __blender_trans16(unsigned long x, unsigned long y, unsigned long n)
{
 unsigned long result;

 n = (n + 1) >> 3;

 x = ((x & 0xFFFF) | (x << 16)) & 0x7E0F81F;
 y = ((y & 0xFFFF) | (y << 16)) & 0x7E0F81F;

 result = (((x - y) * n >> 5) + y) & 0x7E0F81F;

 return ((result & 0xFFFF) | (result >> 16));
}
//---------------------------------------------------------------------------
unsigned long __blender_trans15(unsigned long x, unsigned long y, unsigned long n)
{
 unsigned long result;

 n = (n + 1) >> 3;

 x = ((x & 0xFFFF) | (x << 16)) & 0x3E07C1F;
 y = ((y & 0xFFFF) | (y << 16)) & 0x3E07C1F;

 result = (((x - y) * n >> 5) + y) & 0x3E07C1F;

 return ((result & 0xFFFF) | (result >> 16));
}
//---------------------------------------------------------------------------
unsigned long __blender_add15(unsigned long x, unsigned long y, unsigned long n)
{
 int r, g, b;

 x&=0xffff;
 y&=0xffff;

 r = _getr15(y) + _getr15(x);
 g = _getg15(y) + _getg15(x);
 b = _getb15(y) + _getb15(x);

 return _makecol15(r, g, b);
}
//---------------------------------------------------------------------------
unsigned long __blender_add16(unsigned long x, unsigned long y, unsigned long n)
{
 int r, g, b;

 x&=0xffff;
 y&=0xffff;

 r = _getr16(y) + _getr16(x);
 g = _getg16(y) + _getg16(x);
 b = _getb16(y) + _getb16(x);

 return _makecol16(r, g, b);
}
//---------------------------------------------------------------------------
unsigned long __blender_trans_add16(unsigned long x, unsigned long y, unsigned long n)
{
 unsigned long result;

 if (_blender_col_16==0)
    {
     result=__blender_trans16(0, x, n);
     return _blender_add16(result, y, _blender_alpha2);
    }
 else
    {
     result=_blender_add16(_blender_col_16, x, _blender_alpha2);
     return __blender_trans16(result, y, n);
    }
}
//---------------------------------------------------------------------------
unsigned long __blender_trans_add15(unsigned long x, unsigned long y, unsigned long n)
{
 unsigned long result;

 if (_blender_col_15==0)
    {
     result=__blender_trans15(0, x, n);
     return _blender_add15(result, y, _blender_alpha2);
    }
 else
    {
     result=_blender_add15(_blender_col_15, x, _blender_alpha2);
     return __blender_trans15(result, y, n);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_set_trans_blender(int r, int g, int b, int a)                                     \
{
 set_blender_mode(__blender_trans15, __blender_trans16, NULL, r, g, b, a);
}
void sw_set_add_blender(int r, int g, int b, int a)                                     \
{
 if (a==255) set_blender_mode(__blender_add15, __blender_add16, NULL, r, g, b, 255);
 else set_add_blender(r, g, b, a);
}
void sw_set_trans_add_blender(int r, int g, int b, int a)                                     \
{
 set_blender_mode(__blender_trans_add15, __blender_trans_add16, NULL, r, g, b, a);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_trans_rectfill(BITMAP *bmp, int x1, int y1, int x2, int y2, int c)
{
 short w, h;
 unsigned char cr, cg, cb;
 register unsigned short *d, *we, *he;
 int c1;

 w=MIN(x1, x2);
 h=MAX(x1, x2);
 x1=MAX(w, 0)+1;
 x2=MIN(h, bmp->w);

 w=MIN(y1, y2);
 h=MAX(y1, y2);
 y1=MAX(w, 0)+1;
 y2=MIN(h, bmp->h);

 w=(x2-x1);
 h=bmp->w-w;

 d=&((unsigned short *)bmp->line[y1])[x1];
 we=d+w;
 he=d+bmp->w*(y2-y1);

 c&=0xffff;
 if (depth==15)
    {
     cr=_getr15(c);
     cg=_getg15(c);
     cb=_getb15(c);

     for (;d<he;d+=h, we=d+w)
     for (;d<we;d++)
        {
         c1=(*d)&0xffff;
         *d=_makecol15(_getr15(c1) + cr, _getg15(c1) + cg, _getb15(c1) + cb);
        }
    }
 else
    {
     cr=_getr16(c);
     cg=_getg16(c);
     cb=_getb16(c);

     for (;d<he;d+=h, we=d+w)
     for (;d<we;d++)
        {
         c1=(*d)&0xffff;
         *d=_makecol16(_getr16(c1) + cr, _getg16(c1) + cg, _getb16(c1) + cb);
        }
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
INLINE void trans_putpixel(BITMAP *bmp, int x, int y, int c)
{
 unsigned short *d;
 int c1;

 if (x<0 || y<0 || x>=bmp->w || y>=bmp->h) return;

 d=&((unsigned short *)bmp->line[y])[x];

 c&=0xffff;
 c1=(*d)&0xffff;

 if (depth==15) *d=_makecol15(_getr15(c1) + _getr15(c), _getg15(c1) + _getg15(c), _getb15(c1) + _getb15(c));
 else *d=_makecol16(_getr16(c1) + _getr16(c), _getg16(c1) + _getg16(c), _getb16(c1) + _getb16(c));
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
#define DO_LINE(x1, y1, x2, y2)                                         \
    {                                                                   \
     int px, py, inc;                                                   \
     float d;                                                           \
                                                                        \
     px=ABS(x2-x1);                                                     \
     py=ABS(y2-y1);                                                     \
     if (px>py)                                                         \
        {                                                               \
         int x;                                                         \
         float y;                                                       \
                                                                        \
         d=(float)py/(float)px;                                         \
         if (x1<x2)                                                     \
            {                                                           \
             inc=SGN(y2-y1);                                            \
             d*=inc;                                                    \
             y=y1;                                                      \
             for (x=x1;x<x2;x++, y+=d) {PUTPIX0};                       \
            }                                                           \
         else                                                           \
            {                                                           \
             inc=SGN(y1-y2);                                            \
             d*=inc;                                                    \
             y=y2;                                                      \
             for (x=x2;x<x1;x++, y+=d) {PUTPIX0};                       \
            }                                                           \
        }                                                               \
     else                                                               \
        {                                                               \
         int y;                                                         \
         float x;                                                       \
                                                                        \
         d=(float)px/(float)py;                                         \
         if (y1<y2)                                                     \
            {                                                           \
             inc=SGN(x2-x1);                                            \
             d*=inc;                                                    \
             x=x1+0.5;                                                  \
             for (y=y1;y<y2;y++, x+=d) {PUTPIX1};                       \
            }                                                           \
         else                                                           \
            {                                                           \
             inc=SGN(x1-x2);                                            \
             d*=inc;                                                    \
             x=x2+0.5;                                                  \
             for (y=y2;y<y1;y++, x+=d) {PUTPIX1};                       \
            }                                                           \
        }                                                               \
    }                                                                   \

void aa_line(BITMAP *bmp, int x1, int y1, int x2, int y2, int c)
{
 float f;
 int r, g, b;

 r=getr(c);
 g=getg(c);
 b=getb(c);

#define PUTPIX0                                                         \
     f=(float)ABS((int)(y)-y);                                          \
     trans_putpixel(bmp, x, y+1, makecol((float)r*f, (float)g*f, (float)b*f));\
     trans_putpixel(bmp, x, y, c);                                      \
     trans_putpixel(bmp, x, y-1, makecol((float)r*(1-f), (float)g*(1-f), (float)b*(1-f)));

#define PUTPIX1                                                         \
     f=(float)ABS((int)(x)-x);                                          \
     trans_putpixel(bmp, x+1, y, makecol((float)r*f, (float)g*f, (float)b*f));\
     trans_putpixel(bmp, x, y, c);                                      \
     trans_putpixel(bmp, x-1, y, makecol((float)r*(1-f), (float)g*(1-f), (float)b*(1-f)));

 DO_LINE(x1, y1, x2, y2);

#undef PUTPIX0
#undef PUTPIX1
}
/*****************************************************************************

    Function:


    Description:
    Parameters:
    Return:

*****************************************************************************/
void aa_circle(BITMAP *bmp, int x, int y, float r, int c)
{
 circle(bmp, x, y, r, c);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_draw_quantity(BITMAP *bmp, int q, int max_q, int x, int y, int w, int h, int c)
{
 int l, r, g, b, cc;
 float ratio;

 ratio=((float)q/(float)max_q);
 l=ratio * (float)(w-2);

 if (l<=0) return;

 r=getr(c);
 g=getg(c);
 b=getb(c);

 r=MIN(255, r+(255 - ratio * 255.0));
 g=MIN(255, g+(255 - ratio * 255.0));
 b=MIN(255, b+(255 - ratio * 255.0));

 cc=makecol(r, g, b);

 if (h>1) rect(bmp, x, y, x+w, y+h, c);
 rectfill(bmp, x, y, x+l, y+h, cc);
}
/*****************************************************************************

    Function: draw_target

    Description: deseneaza o tinta
    Parameters: (x, y, w, h) - coordonatele si dimensiunile
                (s)          - dimensiunea marginii
                (c)          - culoarea
    Return: N/A

*****************************************************************************/
void sw_draw_target(BITMAP *bmp, int x, int y, int w, int h, int s, int c, fixed rot)
{
 int w2=w/2, h2=h/2;
 int x1, y1;

 x+=w2; y+=h2;

 if (x<-w || x>=bmp->w+w || y<-h || y>=bmp->h+h) return;

 drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
 set_add_blend(0, 0, 0, 255);

 if (gfx_flags&GFX_FLAG_AALIASING)
    {
     aa_circle(bmp, x, y, (s<<1)-(s>>1), c);
     aa_circle(bmp, x, y, (s<<1)-(s>>1)-2, c);

     x1=fixtoi(fixcos(rot)*(s-4));
     y1=fixtoi(fixsin(rot)*(s-4));
     aa_line(bmp, x, y, x+x1, y+y1, c);

     x1=fixtoi(fixcos(rot+itofix(64))*(s-4));
     y1=fixtoi(fixsin(rot+itofix(64))*(s-4));
     aa_line(bmp, x, y, x+x1, y+y1, c);

     x1=fixtoi(fixcos(rot+itofix(128))*(s-4));
     y1=fixtoi(fixsin(rot+itofix(128))*(s-4));
     aa_line(bmp, x, y, x+x1, y+y1, c);

     x1=fixtoi(fixcos(rot+itofix(192))*(s-4));
     y1=fixtoi(fixsin(rot+itofix(192))*(s-4));
     aa_line(bmp, x, y, x+x1, y+y1, c);
    }
 else
    {
     circle(bmp, x, y, (s<<1)-(s>>1), c);
     circle(bmp, x, y, (s<<1)-(s>>1)-2, c);

     x1=fixtoi(fixcos(rot)*(s-4));
     y1=fixtoi(fixsin(rot)*(s-4));
     line(bmp, x, y, x+x1, y+y1, c);

     x1=fixtoi(fixcos(rot+itofix(64))*(s-4));
     y1=fixtoi(fixsin(rot+itofix(64))*(s-4));
     line(bmp, x, y, x+x1, y+y1, c);

     x1=fixtoi(fixcos(rot+itofix(128))*(s-4));
     y1=fixtoi(fixsin(rot+itofix(128))*(s-4));
     line(bmp, x, y, x+x1, y+y1, c);

     x1=fixtoi(fixcos(rot+itofix(192))*(s-4));
     y1=fixtoi(fixsin(rot+itofix(192))*(s-4));
     line(bmp, x, y, x+x1, y+y1, c);
    }

 drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}
/*****************************************************************************

    Function: draw_lightning

    Description: deseneaza un fulger
    Parameters: (x1, y1, x2, y2)- coordonatele
                (d)             - dirty
    Return: N/A

*****************************************************************************/
void sw_draw_lightning(BITMAP *bmp, int x1, int y1, int x2, int y2, int d)
{
 int x[10];
 int y[10];
 int dx;
 int dy;
 int var;
 int i, c1, c2, c3;

 dx=(x2-x1)/8;
 dy=(y2-y1)/8;
 var=(MAX(abs(x2-x1),abs(y2-y1)) / 5);

 if (var < 2) var=1+(rand()%4);
 if (var > 9) var = 9;

 x[0] = x1;
 y[0] = y1;
 x[9] = x2;
 y[9] = y2;

 for (i=1; i<9; i++)
    {
     x[i] = x1+(dx*i) - (var>>1) + (rand()%var);
     y[i] = y1+(dy*i) - (var>>1) + (rand()%var);
    }

 if (ABS(x2-x1)<192 && ABS(y2-y1)<192 && d)
    {
     if (d) add_dirty(MIN(x1, x2)-8, MIN(y1, y2)-8, MAX(x1, x2)+8, MAX(y1, y2)+8, d);
     d=0;
    }

 c1=makecol(180, 180, 190);
 c2=makecol(0, 0, 241);
 c3=makecol(20, 0, 48);

#define PUTPIX0\
    trans_putpixel(bmp, x, y-2, c3);\
    trans_putpixel(bmp, x, y+2, c3);\
    trans_putpixel(bmp, x, y-1, c2);\
    trans_putpixel(bmp, x, y+1, c2);\
    trans_putpixel(bmp, x, y, c1);

#define PUTPIX1\
    trans_putpixel(bmp, x-2, y, c3);\
    trans_putpixel(bmp, x+2, y, c3);\
    trans_putpixel(bmp, x-1, y, c2);\
    trans_putpixel(bmp, x+1, y, c2);\
    trans_putpixel(bmp, x, y, c1);

 for (i=0; i<9; i++)
    {
     x1=x[i]; y1=y[i];
     x2=x[i+1]; y2=y[i+1];

     DO_LINE(x1, y1, x2, y2);
     if (d) add_dirty(MIN(x1, x2)-4, MIN(y1, y2)-4, MAX(x1, x2)+4, MAX(y1, y2)+4, d);
    }

#undef PUTPIX0
#undef PUTPIX1
}
/*****************************************************************************

    Function: cache_sprite

    Description: incarca animatia respectiva in cache
    Parameters: (anim) - animatia
    Return:  0 - totul ok
            -1 - nu mai e memorie pt cache

*****************************************************************************/
int cache_sprite(int s, int a, int aaliasing)
{
 BITMAP *sprite=gfx[s-sprite_cache_bank*SPRITE_CACHE_BANK_SIZE].dat;

 if (sprite_cache[s].rot==NULL)
    {
     sprite_cache[s].rot=malloc(MAX_ROTATIONS*sizeof(RLE_SPRITE));
     if (sprite_cache[s].rot==NULL)
        {
         flush_sprite_cache(MAX_ROTATIONS*sizeof(RLE_SPRITE));

         return -1;
        }
     memset(sprite_cache[s].rot, 0, MAX_ROTATIONS*sizeof(RLE_SPRITE));
    }
 else if (sprite_cache[s].rot[a]) return 1;

 //daca este destul cache, atunci ...
 if (sprite_cache_size<max_sprite_cache_size)
    {
     sprite_cache[s].rot[a]=mem_get_rotated_rle_sprite(sprite, (a*ROTATION_DIV)<<16, aaliasing);
     if (sprite_cache[s].rot[a])
        {
         sprite_cache[s].rot_count++;
         sprite_cache[s].size+=sprite_cache[s].rot[a]->size;
         sprite_cache_size+=(sizeof(RLE_SPRITE)+sprite_cache[s].rot[a]->size);

         return 1;
        }
     else max_sprite_cache_size=sprite_cache_size;
    }

 flush_sprite_cache(sprite_cache[s].size/MAX_ROTATIONS);

 return -1;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int precache_sprites(int nr)
{
 int i, j, n=0;

 if (sprite_cache_size>=max_sprite_cache_size-1024000) return -1;

 for (j=0;j<MAX_SPRITES;j++)
  if (sprite_cache[j].rot && sprite_cache[j].rot_count<MAX_ROTATIONS)
  if ((sprite_cache[j].rot[0] && sprite_cache[j].rot_count>1) || !sprite_cache[j].rot[0])
    {
     for (i=1;i<MAX_ROTATIONS;i++)
      if (sprite_cache[j].rot[i])
        {
         current_palette=palette[j/SPRITE_CACHE_BANK_SIZE];
         sprite_cache_bank=j/SPRITE_CACHE_BANK_SIZE;

         for (i=0;i<MAX_ROTATIONS;i++)
          if (!sprite_cache[j].rot[i])
            {
             if (cache_sprite(j, i, (gfx_flags&GFX_FLAG_AALIASING))>=0) n++;
             else goto ERROR;

             if (n>=nr) goto DONE;
            }

         break;
        }
    }

ERROR:
 sprite_cache_bank=0;
 return -1;

DONE:
 sprite_cache_bank=0;
 return 0;
}
/*****************************************************************************

    Function: flush_sprite_cache

    Description: curata cache-ul
    Parameters: (size) - cel mai vechi si mai mare sprite mai mic decat (size)
                         va fi sters
    Return: N/A

*****************************************************************************/
void flush_sprite_cache(int size)
{
 int i;
 int best_sprite=-1;
 int best_time=-1;

 size=size>0?size:64000;

 for (i=0;i<MAX_SPRITES;i++)//cauta ceva vechi
  if (sprite_cache[i].size>0 && sprite_cache[i].rot)
    {
     if (game_count-sprite_cache[i].timer>best_time ||
        (game_count-sprite_cache[i].timer==best_time && sprite_cache[i].size>sprite_cache[best_sprite].size))
        {
         best_sprite=i;
         best_time=game_count-sprite_cache[i].timer;
        }
    }

 if (best_sprite<0) return;

 if (best_time>=sprite_cache_timeout ||
    (best_time<sprite_cache_timeout && size>sprite_cache[best_sprite].size*2))//a gasit un sprite mult mai mic
    {
     sprite_cache[best_sprite].rot_count=0;
     sprite_cache[best_sprite].size=0;

     for (i=0;i<MAX_ROTATIONS;i++)
      if (sprite_cache[best_sprite].rot[i])
        {
         sprite_cache_size-=(sizeof(RLE_SPRITE)+sprite_cache[best_sprite].rot[i]->size);

         free(sprite_cache[best_sprite].rot[i]);
         sprite_cache[best_sprite].rot[i]=NULL;
        }

     free(sprite_cache[best_sprite].rot);
     sprite_cache[best_sprite].rot=NULL;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void purge_sprite_cache()
{
 int i, j;

 for (j=0;j<MAX_SPRITES;j++)
  if (sprite_cache[j].rot)
    {
     for (i=0;i<MAX_ROTATIONS;i++)
      if (sprite_cache[j].rot[i])
        {
         sprite_cache_size-=(sizeof(RLE_SPRITE)+sprite_cache[j].rot[i]->size);

         free(sprite_cache[j].rot[i]);
         sprite_cache[j].rot[i]=NULL;
        }

     sprite_cache[j].size=0;
     sprite_cache[j].rot_count=0;

     free(sprite_cache[j].rot);
     sprite_cache[j].rot=NULL;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sprite_cache_init()
{
 sprite_cache_bank=0;

 memset(sprite_cache, 0, sizeof(SPRITE_CACHE)*MAX_SPRITES);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sprite_cache_shutdown()
{
 purge_sprite_cache();
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_set_gfx_flags(int flags)
{
 if ((gfx_flags&GFX_FLAG_AALIASING)!=(flags&GFX_FLAG_AALIASING)) purge_sprite_cache();

 gfx_flags=flags;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void switch_callback(void)
{
 add_dirty(0, 0, 640, 480, 8);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int sw_init2()
{
 int i, j;
 int r, g, b;
 int obj;

 obj=get_object(gfx, "PAL0");
 if (obj<0)
    {
     sprintf(error_msg, "Could not find PAL0 object in gfx.dat");
     error_flag=1;

     return -1;
    }

 for (j=0;j<7;j++)
 for (i=0;i<256;i++)
    {
     r=((RGB *)gfx[obj+j].dat)[i].r*4;
     g=((RGB *)gfx[obj+j].dat)[i].g*4;
     b=((RGB *)gfx[obj+j].dat)[i].b*4;

     palette[j][i]=makecol(r, g, b)&0xffff;
    }

 current_palette=palette[0];

 for (i=0;i<256;i++)
    {
     if (depth==15)
        {
         r_table[i]=MIN(i, 31)<<10;
         g_table[i]=MIN(i, 31)<<5;
         b_table[i]=MIN(i, 31);
        }
     else
        {
         r_table[i]=MIN(i, 31)<<11;
         g_table[i]=MIN(i, 63)<<5;
         b_table[i]=MIN(i, 31);
        }
    }		 

 font=gfx[get_object(gfx, "FONT0")].dat;

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int sw_init()
{
 char m[256];

 error_flag=0;
 if (open_config_file("config.ini")<0)
    {
     strcpy(error_msg, "Error opening 'config.ini'");
     error_flag=1;

     return -1;
    }

 x_res=640; y_res=480;
 card=_get_config_int("gfx", "driver", 0);
 _set_config_int("gfx", "driver", card);
 switch (card)
    {
     case 0:
         card=GFX_AUTODETECT_FULLSCREEN;
         sprintf(m, "Fullscreen autodetect driver");
        break;
     case 1:
         card=GFX_AUTODETECT_WINDOWED;
         sprintf(m, "Windowed autodetect driver");
        break;
     case 2:
         card=GFX_DIRECTX_ACCEL;
         sprintf(m, "Hardware DirectX driver");
        break;
     case 3:
         card=GFX_DIRECTX_SOFT;
         sprintf(m, "Software DirectX driver");
        break;
     case 4:
         card=GFX_DIRECTX_WIN;
         sprintf(m, "Windowed DirectX driver");
        break;
     case 5:
         card=GFX_GDI;
         sprintf(m, "GDI driver");
        break;
     default:
         sprintf(error_msg, "Unknown gfx driver - %d", card);
         error_flag=1;

         return -1;
        break;
    }

 depth=_get_config_int("gfx", "color depth", 16);
 _set_config_int("gfx", "color depth", depth);
 if (depth!=15 && depth!=16)
    {
     sprintf(error_msg, "Color depth not allowed - %d. Use only 15 or 16 bpp.", depth);
     error_flag=1;

     return -1;
    }

 max_sprite_cache_size=_get_config_int("gfx", "max cache", 4000000);
 _set_config_int("gfx", "max cache", max_sprite_cache_size);

 sprite_cache_timeout=_get_config_int("gfx", "cache timeout", 1000);
 _set_config_int("gfx", "cache timeout", sprite_cache_timeout);

 close_config_file();

 LOG("\n\t%s, %dx%dx%dbpp", m, x_res, y_res, depth);

 set_color_depth(depth);
 if (set_gfx_mode(card, x_res, y_res, 0, 0)<0)
    {
	 LOG("...%s", allegro_error);

	 depth=(depth==15)?16:15;
	 LOG("\n\tTrying %s, %dx%dx%dbpp", m, x_res, y_res, depth);

	 set_color_depth(depth);
	 if (set_gfx_mode(card, x_res, y_res, 0, 0)<0)
		{
		 strcpy(error_msg, allegro_error);
		 error_flag=1;

		 return -1;
		}
    }
 LOG("...ok");

 LOG("\n\t%s \n\t%s", gfx_driver->name, gfx_driver->desc);
 LOG("\n\tSprite cache size: %d", max_sprite_cache_size);
 LOG("\n\tSprite cache timeout: %d", sprite_cache_timeout);

 buffer=create_bitmap(x_res, y_res);
 if (!buffer)
    {
     strcpy(error_msg, "Not enough memory for screen buffer!");
     error_flag=1;

     return -1;
    }
 clear_bitmap(buffer);
 camera=create_sub_bitmap(buffer, CAMERA_X, CAMERA_Y, CAMERA_W, CAMERA_H);

 background=create_bitmap(x_res, y_res);
 if (!background)
    {
     strcpy(error_msg, "Not enough memory for background bitmap!");
     error_flag=1;

     return -1;
    }

 sprite_cache_init();

 text_mode(-1);
 set_mouse_speed(0, 0);

 dirty_w=SCREEN_W/DIRTY_DIV;
 dirty_h=SCREEN_H/DIRTY_DIV;
 add_dirty(0, 0, SCREEN_W, SCREEN_H, 2);

/* {
  BITMAP *bmp;

  bmp=load_bitmap("logo1.pcx", NULL);
  if (bmp) blit(bmp, screen, 0, 0, 0, 0, 640, 480);

  if (bmp) destroy_bitmap(bmp);
 }
*/
 set_color_conversion(COLORCONV_PARTIAL);

 set_display_switch_mode(SWITCH_BACKAMNESIA);
 switch (get_display_switch_mode())
	{
	 case SWITCH_NONE: LOG("\n\tSwitching is disabled."); break;
     case SWITCH_PAUSE: LOG("\n\tSwitch mode: SWITCH_PAUSE"); break;
	 case SWITCH_AMNESIA: LOG("\n\tSwitch mode: SWITCH_AMNESIA"); break;
	 case SWITCH_BACKGROUND: LOG("\n\tSwitch mode: SWITCH_BACKGROUND"); break;
	 case SWITCH_BACKAMNESIA: LOG("\n\tSwitch mode: SWITCH_BACKAMNESIA"); break;
	 default: LOG("\n\tSwitch mode: unknown!"); break;
	}

 if (set_display_switch_callback(SWITCH_IN, switch_callback)<0) LOG("\n\tSwitch in callback not installed.");
 else LOG("\n\tSwitch in callback installed.");
 if (set_display_switch_callback(SWITCH_OUT, switch_callback)<0) LOG("\n\tSwitch out callback not installed.");
 else LOG("\n\tSwitch out callback installed.");
 
 gfx_flags=0;
 gfx_flags|=GFX_FLAG_AALIASING;
 gfx_flags|=GFX_FLAG_PRECACHE;
 gfx_flags|=GFX_FLAG_SOFTWARE;
 gfx_flags|=GFX_FLAG_INITIALIZED;
 
 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_shutdown()
{
 if (camera)        destroy_bitmap(camera);
 if (buffer)        destroy_bitmap(buffer);
 if (background)    destroy_bitmap(background);

 sprite_cache_shutdown();

 gfx_flags&=~GFX_FLAG_INITIALIZED;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_flip()
{
 short int i, j;
 short int start, start_d;
 unsigned char *d;
 static volatile long timer;

 frame_count++;

 frame_time=game_count-timer;
 timer=game_count;
 if ((gfx_flags&GFX_FLAG_PRECACHE) && frame_time<50) precache_sprites(MAX(1, (50-frame_time)/15));

// drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);

 if (gfx_flags&GFX_FLAG_VSYNC) vsync();

 acquire_screen();
 acquire_bitmap(buffer);
 acquire_bitmap(camera);

 for (j=0;j<dirty_h;j++)
    {
     d=dirty_list[j];
     start=-1;

     for (i=0;i<dirty_w;i++)
        {
         if (d[i]>0)
            {
             if (start<0)
                {
                 start=i;
                 start_d=d[i];
                }

             d[i]--;
            }
         else if (start>=0)
            {
             blit(buffer, screen, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, (i-start)*DIRTY_DIV, DIRTY_DIV);
             blit(background, buffer, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, (i-start)*DIRTY_DIV, DIRTY_DIV);
//           if (d[i-1]>-1) rect(screen, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS,  (start<<DIRTY_DIV_BITS)+(i-start)*DIRTY_DIV-1, (j<<DIRTY_DIV_BITS)+DIRTY_DIV-1, 255);

             start=-1;
            }
        }

     if (start>=0)
        {
         blit(buffer, screen, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, (i-start)*DIRTY_DIV, DIRTY_DIV);
         blit(background, buffer, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, start<<DIRTY_DIV_BITS, j<<DIRTY_DIV_BITS, (i-start)*DIRTY_DIV, DIRTY_DIV);
        }
    }
// clear(camera);

 release_bitmap(camera);
 release_bitmap(buffer);
 release_screen();
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_draw_anim_lights(BITMAP *bmp, ANIM *anim, int x, int y)
{
 int a, s, rot;
 int lx, ly;
 int i, w, h;
 BITMAP *sprite;

 rot=anim->rot_flag?0:anim->rot;
 FIX_ANGLE(rot);
 a=rot/ROTATION_DIV;

 for (i=0;i<MAX_LOCATIONS;i++)
  if (anim->ls[i]>=1)
    {
     lx=anim->lx[i];
     ly=anim->ly[i];
     get_rotated_pos(&lx, &ly, a*ROTATION_DIV);
     lx=lx + x + ((BITMAP *)gfx[anim->sprite].dat)->w/2;
     ly=ly + y + ((BITMAP *)gfx[anim->sprite].dat)->h/2;

     s=anim->ls[i];
     sprite=gfx[s].dat;

     s+=sprite_cache_bank*SPRITE_CACHE_BANK_SIZE;
     if (cache_sprite(s, a, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING))>=0)
        {
         sprite_cache[s].timer=game_count;

         if (anim->trans>0)
            {
             if (anim->trans>=255) return;

             set_trans_add_blend(0, 0, 0, anim->trans);
             _blender_alpha2=255;
            }
         else set_add_blend(0, 0, 0, 255);
            
         draw_trans_rle_sprite_centre(bmp, sprite_cache[s].rot[a], lx, ly);
         add_dirty_centre(lx, ly, sprite_cache[s].rot[a]->w, sprite_cache[s].rot[a]->h, 2);
        }
     else
        {
         w=sprite->w;
         h=sprite->h;

         if (anim->trans>0)
            {
             if (anim->trans>=255) return;

             set_trans_add_blend(0, 0, 0, anim->trans);
             _blender_alpha2=255;
            }
         else set_add_blend(0, 0, 0, 255);

         mem_rotate_trans_sprite_centre(bmp, sprite, lx, ly, (a*ROTATION_DIV)<<16, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING));

         if (a) get_rotated_dim(&w, &h, a);
         add_dirty_centre(lx, ly, w, h, 2);
        }
    }
}
/*****************************************************************************

    Function: draw_anim

    Description: deseneaza o animatie folosind un cache pt faze
    Parameters: blah
    Return: N/A

*****************************************************************************/
void sw_draw_anim(BITMAP *bmp, ANIM *anim, int x, int y)
{
 int a, s, rot;
 BITMAP *sprite;
 int rx, ry;

 rot=anim->rot_flag?0:anim->rot;
 FIX_ANGLE(rot);
 a=rot/ROTATION_DIV;
 s=anim->sprite;
 if (!s) return;

 sprite=gfx[s].dat;
 
 if (bitmap_color_depth(sprite)==8)
    {
     current_palette=palette[current_player->color];
     sprite_cache_bank=current_player->color;
    }
 else 
    {
     current_palette=palette[0];
     sprite_cache_bank=0;
    }
  
 s+=sprite_cache_bank*SPRITE_CACHE_BANK_SIZE;
 if (cache_sprite(s, a, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING))>=0)
    {
     rx=x-(sprite_cache[s].rot[a]->w-sprite->w)/2;
     ry=y-(sprite_cache[s].rot[a]->h-sprite->h)/2;
    
     sprite_cache[s].timer=game_count;

     if (anim->lit>0)
        {
         if (anim->trans>0)
            {
             if (anim->trans>=255) return;

             set_trans_add_blend(anim->lit_r, anim->lit_g, anim->lit_b, 255-anim->trans);
             _blender_alpha2=anim->lit;

             _draw_trans_add_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry);
            }
         else
            {
             set_add_blend(anim->lit_r, anim->lit_g, anim->lit_b, 0);
             draw_lit_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry, anim->lit);
            }
        }
     else if (anim->trans>0)
        {
         if (anim->trans>=255) return;
    
         set_trans_blend(0, 0, 0, 255-anim->trans);
         _draw_trans_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry);
        }
     else if (anim->add>0)
        {
         set_add_blend(0, 0, 0, anim->add);
         _draw_add_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry);
        }
     else draw_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry);
    }
 else
    {
     rx=x;
     ry=y;

     if (anim->lit)
        {
         if (anim->trans>0)
            {
             if (anim->trans>=255) return;

             set_trans_add_blend(anim->lit_r, anim->lit_g, anim->lit_b, 255-anim->trans);
             _blender_alpha2=anim->lit;

             mem_rotate_trans_sprite(bmp, sprite, rx, ry, rot<<16, anim->aaliasing &&   (gfx_flags&GFX_FLAG_AALIASING));
            }
         else
            {
             set_add_blend(anim->lit_r, anim->lit_g, anim->lit_b, 0);
             mem_rotate_lit_sprite(bmp, sprite, rx, ry, rot<<16, anim->lit, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING));
            }
        }
     else if (anim->trans>0)
        {
         if (anim->trans>=255) return;

         set_trans_blend(0, 0, 0, 255-anim->trans);
         mem_rotate_trans_sprite(bmp, sprite, rx, ry, rot<<16, anim->aaliasing &&   (gfx_flags&GFX_FLAG_AALIASING));
        }
     else if (anim->add>0)
        {
         set_add_blend(0, 0, 0, anim->add);
         mem_rotate_trans_sprite(bmp, sprite, rx, ry, rot<<16, anim->aaliasing &&   (gfx_flags&GFX_FLAG_AALIASING));
        }
     else mem_rotate_sprite(bmp, sprite, rx, ry, rot<<16, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING));
    }
}
/*****************************************************************************

    Function: draw_trans_anim

    Description: deseneaza o animatie transparenta fara a tine seama de flags
    Parameters: (bmp)   - bitmap-ul unde va desena
                (p)     - pointer la animatie
                (x, y)  - pozitia
    Return: N/A

*****************************************************************************/
void sw_draw_trans_anim(BITMAP *bmp, ANIM *anim, int x, int y)
{
 int a, s, rot;
 BITMAP *sprite;
 int rx, ry;

 rot=anim->rot_flag?0:anim->rot;
 FIX_ANGLE(rot);
 a=rot/ROTATION_DIV;
 s=anim->sprite;
 if (!s) return;

 sprite=gfx[s].dat;

 if (bitmap_color_depth(sprite)==8)
    {
     current_palette=palette[current_player->color];
     sprite_cache_bank=current_player->color;
    }
 else 
    {
     current_palette=palette[0];
     sprite_cache_bank=0;
    }
  
 s+=sprite_cache_bank*SPRITE_CACHE_BANK_SIZE;
 if (cache_sprite(s, a, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING))>=0)
    {
     rx=x-(sprite_cache[s].rot[a]->w-sprite->w)/2;
     ry=y-(sprite_cache[s].rot[a]->h-sprite->h)/2;
    
     sprite_cache[s].timer=game_count;
    
     draw_trans_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry);
    }
 else
    {
     rx=x;
     ry=y;

     mem_rotate_trans_sprite(bmp, sprite, rx, ry, rot<<16, gfx_flags&GFX_FLAG_AALIASING);
    }
}
/*****************************************************************************

    Function: draw_lit_anim

    Description: deseneaza o animatie luminata fara a tine seama de flags
    Parameters: (bmp)   - bitmap-ul unde va desena
                (p)     - pointer la animatie
                (x, y)  - pozitia
                (color) - gradul de iluminare
    Return: N/A

*****************************************************************************/
void sw_draw_lit_anim(BITMAP *bmp, ANIM *anim, int x, int y, int color)
{
 int a, s, rot;
 BITMAP *sprite;
 int rx, ry;

 rot=anim->rot_flag?0:anim->rot;
 FIX_ANGLE(rot);
 a=rot/ROTATION_DIV;
 s=anim->sprite;
 if (!s) return;

 sprite=gfx[s].dat;

 if (bitmap_color_depth(sprite)==8)
    {
     current_palette=palette[current_player->color];
     sprite_cache_bank=current_player->color;
    }
 else 
    {
     current_palette=palette[0];
     sprite_cache_bank=0;
    }
  
 s+=sprite_cache_bank*SPRITE_CACHE_BANK_SIZE;
 if (cache_sprite(s, a, anim->aaliasing && (gfx_flags&GFX_FLAG_AALIASING))>=0)
    {
     rx=x-(sprite_cache[s].rot[a]->w-sprite->w)/2;
     ry=y-(sprite_cache[s].rot[a]->h-sprite->h)/2;
    
     sprite_cache[s].timer=game_count;
    
     draw_lit_rle_sprite(bmp, sprite_cache[s].rot[a], rx, ry, color);
    }
 else
    {
     rx=x;
     ry=y;

     mem_rotate_lit_sprite(bmp, sprite, rx, ry, rot<<16, color, gfx_flags&GFX_FLAG_AALIASING);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void sw_get_anim_dims(ANIM *anim)
{
 int w, h, rot;
 RLE_SPRITE *rs=NULL;

 FIX_ANGLE(anim->rot);
 rot=anim->rot_flag?0:anim->rot;
 if (sprite_cache[anim->sprite].rot) rs=sprite_cache[anim->sprite].rot[rot/ROTATION_DIV];

 if (rs)
    {
     w=rs->w;
     h=rs->h;
    }
 else
    {
     BITMAP *s=gfx[anim->sprite].dat;

     w=s->w;
     h=s->h;

     get_rotated_dim(&w, &h, anim->rot);
    }

 anim->w=w;
 anim->h=h;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
GFX_ENGINE_DRIVER software_gfx_driver=
    {
     sw_init,
     sw_init2,
     sw_shutdown,
     sw_flip,
     sw_set_gfx_flags,
     sw_add_dirty,
     sw_draw_anim_lights,
     sw_draw_anim,
     sw_draw_trans_anim,
     sw_draw_lit_anim,
     sw_get_anim_dims,
     sw_trans_rectfill,
     sw_draw_quantity,
     sw_draw_target,
     sw_draw_lightning,
     sw_set_trans_blender,
     sw_set_add_blender,
     sw_set_trans_add_blender
    };

