#ifndef _GFX_H_
#define _GFX_H_

//--------------------------------------------------------------------------
//#include "main.h"
//--------------------------------------------------------------------------
#define RES_MAX_W                       640
#define RES_MAX_H                       480
#define DIRTY_DIV                       8
#define DIRTY_DIV_BITS                  3
#define CAMERA_X                        0
#define CAMERA_Y                        0
#define CAMERA_W                        640
#define CAMERA_H                        342	 

#define FONT_SCRATCHPAD_HEIGHT			128
#define FONT_SCRATCHPAD_WIDTH			256

#define GFX_FLAG_INITIALIZED            1
#define GFX_FLAG_VSYNC                  1024
#define GFX_FLAG_AALIASING              2048
#define GFX_FLAG_PRECACHE               4096
#define GFX_FLAG_SOFTWARE               8192

#define ANIM_STOP_FLAG                  1
#define ANIM_MOVE_FLAG                  2
#define ANIM_BUILD_FLAG                 4
#define ANIM_DIE_FLAG                   8
#define ANIM_FIRE_FLAG                  16
#define ANIM_FOCUS_FLAG                 32
#define ANIM_DOUBLE_FLAG                64

#define MAX_LOCATIONS                   12

#define draw_target_centre(bmp, x, y, w, h, s, c, rot) draw_target(bmp, (x)-((w)>>1), (y)-((h)>>1), (w), (h), (s), (c), (rot))

#define draw_anim_lights_centre(bmp, anim, x, y) {if (anim) draw_anim_lights(bmp, anim, x-(((BITMAP *)gfx[(anim)->sprite].dat)->w>>1), y-(((BITMAP *)gfx[(anim)->sprite].dat)->h>>1));}
#define draw_anim_centre(bmp, anim, x, y) {if (anim) draw_anim(bmp, anim, x-(((BITMAP *)gfx[(anim)->sprite].dat)->w>>1), y-(((BITMAP *)gfx[(anim)->sprite].dat)->h>>1));}
#define draw_trans_anim_centre(bmp, anim, x, y) {if (anim) draw_trans_anim(bmp, anim, x-(((BITMAP *)gfx[(anim)->sprite].dat)->w>>1), y-(((BITMAP *)gfx[(anim)->sprite].dat)->h>>1));}
#define draw_lit_anim_centre(bmp, anim, x, y, c) {if (anim) draw_lit_anim(bmp, anim, x-(((BITMAP *)gfx[(anim)->sprite].dat)->w>>1), y-(((BITMAP *)gfx[(anim)->sprite].dat)->h>>1), c);}

#define add_dirty(x, y, w, h, n) _add_dirty((x), (y), (w), (h), (n), 0, 0, 640, 480);
#define add_dirty_centre(x, y, w, h, n) _add_dirty((x)-(w)/2, (y)-(h)/2, (w), (h), (n), 0, 0, 640, 480);
#define add_camera_dirty(x, y, w, h, n) _add_dirty((x)+CAMERA_X, (y)+CAMERA_Y, (w), (h), (n), CAMERA_X, CAMERA_Y, CAMERA_X+CAMERA_W, CAMERA_Y+CAMERA_H+DIRTY_DIV);
#define add_camera_dirty_centre(x, y, w, h, n) _add_dirty((x)+CAMERA_X-(w)/2, (y)+CAMERA_Y-(h)/2, (w), (h), (n), CAMERA_X, CAMERA_Y, CAMERA_X+CAMERA_W, CAMERA_Y+CAMERA_H+DIRTY_DIV);

#define clear_sprite(b) clear_to_color(b, bitmap_mask_color(b))

#define CALL_ANIM_SCRIPT1(var, proc, a1)                                    \
    {                                                                       \
     if ((var)->prog && (var)->_##proc##_>0)                                \
        {                                                                   \
         int old_rot=(var)->rot;                                            \
         int old_sprite=(var)->sprite;                                      \
                                                                            \
         scCall_Instance((var)->prog, (var)->_##proc##_, a1);               \
                                                                            \
         if ((var)->rot!=old_rot || (var)->sprite!=old_sprite)              \
            {                                                               \
             if (current_gfx_driver) if (current_gfx_driver->get_anim_dims) \
             (current_gfx_driver->get_anim_dims)(var);                      \
            }                                                               \
                                                                            \
         if ((var)->done)                                                   \
            {                                                               \
             CALL_SCRIPT1(var, shutdown, var);                              \
                                                                            \
             scFree_Instance((var)->prog);                                  \
             (var)->prog=NULL;                                              \
            }                                                               \
        }                                                                   \
    }

//--------------------------------------------------------------------------
typedef struct ANIM
    {
     int    w, h;
     int    x, y;                       //pozitia vechii afisari

     int    _init_;                     //adresele procedurilor
     int    _shutdown_;
     int    _draw_;
     int    _flags_;
     int    _process_;

     scInstance *prog;                  //instructiunile de prelucrare a frame-urilor

     int    flags;
     int    lx[MAX_LOCATIONS];          //x
     int    ly[MAX_LOCATIONS];          //y
     int    ls[MAX_LOCATIONS];          //sprite-ul din locatie
     int    wx[MAX_LOCATIONS];          //x
     int    wy[MAX_LOCATIONS];          //y
     int    ws[MAX_LOCATIONS];          //sprite-ul din locatie
     float  timer;
     int    sprite;                     //sprite-ul de afisat
     float  speed;
     int    dir;
     int    trans;                      //transparenta
     int    add;                        //add
     int    lit, lit_r, lit_g, lit_b;   //lit
     int    aaliasing;                  //cu antialiasing sau nu
     int    rot_flag;                   //rotatia (dez)activata
     int    rot;                        //rotatia frame-ului
     int    done;                       //1 - s-a terminat
    } ANIM;

typedef struct GFX_ENGINE_DRIVER
    {
     int  (*init)();
     int  (*init2)();
     void (*shutdown)();
     void (*flip)();
     void (*set_gfx_flags)(int flags);
     void (*add_dirty)(int x, int y, int w, int h, int n, int x1, int y1, int x2, int y2);
     void (*draw_anim_lights)(BITMAP *dest, ANIM *anim, int x, int y);
     void (*draw_anim)(BITMAP *dest, ANIM *anim, int x, int y);
     void (*draw_trans_anim)(BITMAP *dest, ANIM *anim, int x, int y);
     void (*draw_lit_anim)(BITMAP *dest, ANIM *anim, int x, int y, int c);
     void (*get_anim_dims)(ANIM *anim);
     void (*trans_rectfill)(BITMAP *bmp, int x1, int y1, int x2, int y2, int c);
     void (*draw_quantity)(BITMAP *bmp, int q, int max_q, int x, int y, int w, int h, int c);
     void (*draw_target)(BITMAP *bmp, int x, int y, int w, int h, int s, int c, fixed rot);
     void (*draw_lightning)(BITMAP *bmp, int x1, int y1, int x2, int y2, int d);
     void (*set_trans_blender)(int r, int g, int b, int a);
     void (*set_add_blender)(int r, int g, int b, int a);
     void (*set_trans_add_blender)(int r, int g, int b, int a);
    } GFX_ENGINE_DRIVER;

//--------------------------------------------------------------------------
BITMAP *buffer, *camera, *background;

extern GFX_ENGINE_DRIVER software_gfx_driver;
GFX_ENGINE_DRIVER *current_gfx_driver;

int x_res, y_res, depth, card, gfx_flags;
float camera_x, camera_y, camera_tx, camera_ty;

volatile int fps, frame_count, frame_time;

BITMAP *font_scratchpad;
int font_aliasmap[8];
int font_aliasmap_foreground;
int font_aliasmap_background;
int font_aliasmap_depth;

//--------------------------------------------------------------------------
int  init_gfx();
int  init_gfx_data();
void shutdown_gfx();
void flip();
void set_gfx_flags(int flags);
ANIM *animdup(ANIM *anim);
void destroy_anim(ANIM *anim);
void _add_dirty(int x, int y, int w, int h, int n, int x1, int y1, int x2, int y2);
void set_trans_blend(int r, int g, int b, int a);
void set_add_blend(int r, int g, int b, int a);
void set_trans_add_blend(int r, int g, int b, int a);

void aa_textout(BITMAP *bmp, FONT *font, char *string, int x, int y, int color);
void aa_textout_centre(BITMAP *bmp, FONT *font, char *string, int x, int y, int color);
void aa_textprintf(BITMAP *bmp, FONT *font, int x, int y, int color, char *format, ...);
void aa_textprintf_centre(BITMAP *bmp, FONT *font, int x, int y, int color, char *format, ...);

void trans_rectfill(BITMAP *bmp, int x1, int y1, int x2, int y2, int c);
void draw_quantity(BITMAP *bmp, int q, int max_q, int x, int y, int w, int h, int c);
void draw_target(BITMAP *bmp, int x, int y, int w, int h, int s, int c, fixed rot);
void draw_lightning(BITMAP *bmp, int x1, int y1, int x2, int y2, int d);
int  process_anim(struct ANIM *anim);
int  process_anim_lines(ANIM *anim);
void anim_flags(ANIM *anim, int flags);
void get_anim_dims(ANIM *anim);
void draw_anim_lights(BITMAP *bmp, ANIM *anim, int x, int y);
void draw_anim(BITMAP *bmp, struct ANIM *anim, int x, int y);
void draw_trans_anim(BITMAP *bmp, struct ANIM *anim, int x, int y);
void draw_lit_anim(BITMAP *bmp, struct ANIM *anim, int x, int y, int);

#endif
