/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Dummy gfx functions. They call real functions implemented in driver files as 'gfxsw.c'
 */

#include "standard.h"
#include "gfx.h"
#include <allegro/internal/aintern.h>

#include "script.h"
#include "alliance.h"
#include "misc.h"
#include "file.h"
#include "particle.h"
#include "panel.h"


/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_setup_aliasmap (int fg, int bg, int depth)
{
 int cr, cg, cb, tr, tg, tb;
 int(*colmaker)(int,int,int);

 int darkness, index;

 switch(depth)
	{
     case(15):
		cr = getr15(fg);
        cg = getg15(fg);
        cb = getb15(fg);

        tr = getr15(bg);
        tg = getg15(bg);
        tb = getb15(bg);

        colmaker = makecol15;
        break;
     case(16):
        cr = getr16(fg);
        cg = getg16(fg);
        cb = getb16(fg);

        tr = getr16(bg);
        tg = getg16(bg);
        tb = getb16(bg);

        colmaker = makecol16;
        break;
      }

 darkness = 37;
 for(index=1;index<7;index++)
	{
     font_aliasmap[index] = colmaker((cr*darkness+(255-darkness)*tr)>>8,
                                     (cg*darkness+(255-darkness)*tg)>>8,
                                     (cb*darkness+(255-darkness)*tb)>>8);
     darkness += 37;
    }
 
 font_aliasmap[0] = bg;
 font_aliasmap[7] = fg;

 font_aliasmap_foreground = fg;
 font_aliasmap_background = bg;
 font_aliasmap_depth = depth;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_prepare_aliasmap (int fg, int bg, int depth)
{
 if ((fg!=font_aliasmap_foreground) || (bg!=font_aliasmap_background) || (depth!=font_aliasmap_depth))
	{
     font_setup_aliasmap(fg,bg,depth);
    }

 if ((font_scratchpad==NULL) || (bitmap_color_depth(font_scratchpad)!=depth))
    {
     if (font_scratchpad!=NULL) destroy_bitmap(font_scratchpad);
     font_scratchpad = create_bitmap_ex(depth, FONT_SCRATCHPAD_WIDTH, FONT_SCRATCHPAD_HEIGHT);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_antialiased_15_or_16bit_filled_render (struct BITMAP *b, struct BITMAP *bmp, int x, int y)
{
 int i;

 for(i = 0; i < b->h; i++)
	{
     unsigned char* input = b->line[i];
     unsigned short* output = (short*)font_scratchpad->line[i];
     const unsigned char* inputend = &b->line[i][b->w];

     while(input!=inputend) *output++ = font_aliasmap[*input++>>5];
	} 

 blit(font_scratchpad, bmp, 0, 0, x, y, b->w, b->h);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_antialiased_15bit_filled_render (struct BITMAP *b, int fg, int bg, struct BITMAP *bmp, int x, int y)
{
 font_prepare_aliasmap(fg,bg,15);
 font_antialiased_15_or_16bit_filled_render(b,bmp,x,y);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_antialiased_15bit_empty_render (struct BITMAP *b, int fg, struct BITMAP *bmp, int x, int y)
{
 int xx, i, yy, xxend;
 unsigned char *input;

 _farsetsel(bmp->seg);

 for(i = 0; i < b->h; i++)
	{
     input = b->line[i];

     yy = y+i;
     if(yy>=bmp->cb) return;
      
     if(yy>=bmp->ct)
		{
         int pix = 0;
         if(x<bmp->cl)
			{
             pix = bmp->cl - x;
             input += pix;
            }

         xxend = x + b->w;
         if(xxend>=bmp->cr) xxend = bmp->cr;
            
         xxend *= 2;
         for(xx = (x + pix)*2; xx < xxend; xx+=2)
			{
             const unsigned int blendlevel = *input++;

             if (blendlevel)
				{
                 unsigned int back = _farnspeekw(bmp_read_line(bmp,yy)+xx);
                 back = _blender_trans15(fg,back,blendlevel);

                 _farnspokew(bmp_write_line(bmp,yy)+xx, back);
				}
			}
		}
	}
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_antialiased_16bit_filled_render (struct BITMAP *b, int fg, int bg, struct BITMAP *bmp, int x, int y)
{
 font_prepare_aliasmap(fg,bg,16);
 font_antialiased_15_or_16bit_filled_render(b,bmp,x,y);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void font_antialiased_16bit_empty_render (struct BITMAP *b, int fg, struct BITMAP *bmp, int x, int y)
{
 int xx, i, yy, xxend;
 unsigned char *input;

 _farsetsel(bmp->seg);

 for(i = 0; i < b->h; i++)
	{
     input = b->line[i];

     yy = y+i;
     if(yy>=bmp->cb) return;
      
     if(yy>=bmp->ct)
		{
         int pix = 0;
         if(x<bmp->cl)
            {
             pix = bmp->cl - x;
             input += pix;
            }

         xxend = x + b->w;
         if(xxend>=bmp->cr) xxend = bmp->cr;

         xxend *=2;
         for(xx = (x + pix)*2; xx < xxend; xx+=2)
			{
             unsigned int blendlevel = *input++;

             if (blendlevel)
				{
                 unsigned int back = _farnspeekw(bmp_read_line(bmp,yy)+xx);
                 back = _blender_trans16(fg,back,blendlevel);

                 _farnspokew(bmp_write_line(bmp,yy)+xx, back);
				}
			}
		}
	}
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
static BITMAP* find_glyph(FONT* f, int ch)
{
 FONT_COLOR_DATA* fcd = (FONT_COLOR_DATA*)(f->data);

 while(fcd) 
	{
     if(ch >= fcd->begin && ch < fcd->end) return fcd->bitmaps[ch - fcd->begin];
     fcd = fcd->next;
	}

 if (ch != ' ') return find_glyph(f, ' ');

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int font_antialiased_render(FONT *f, int ch, int fg, int bg, struct BITMAP *bmp, int x, int y)
{
 BITMAP* b = find_glyph(f, ch);

 if (!b) return 0;

 if (fg<0) 
	{
     bmp->vtable->draw_256_sprite(bmp, b, x, y);
	}
 else 
	{
     switch(bitmap_color_depth(bmp))
		{
         case(15):
			if(bg>=0) font_antialiased_15bit_filled_render(b,fg,bg,bmp,x,y);
            else font_antialiased_15bit_empty_render(b,fg,bmp,x,y);
            break;

         case(16):
			if(bg>=0) font_antialiased_16bit_filled_render(b,fg,bg,bmp,x,y);
            else font_antialiased_16bit_empty_render(b,fg,bmp,x,y);
            break;
		}
	}

 return b->w;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void aa_textout(BITMAP *bmp, FONT *font, char *string, int x, int y, int color)
{
 int ch;

 if ((font->vtable == font_vtable_mono) || (text_height(font)>FONT_SCRATCHPAD_HEIGHT)) 
	{
     textout(bmp, font, string, x, y, color);
     return;
	}

 while ((ch = *string) != 0) 
	{
     x += font_antialiased_render(font, ch, color, _textmode, bmp, x, y);
     if (x >= bmp->cr) return;

     ++string;
	}
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void aa_textout_centre(BITMAP *bmp, FONT *font, char *string, int x, int y, int color)
{
 aa_textout(bmp, font, string, x - (text_length(font, string) / 2), y, color);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void aa_textprintf(BITMAP *bmp, FONT *font, int x, int y, int color, char *format, ...)
{
 char buf[256];

 va_list ap;
 va_start(ap, format);
 vsprintf(buf, format, ap);
 va_end(ap);

 aa_textout(bmp, font, buf, x, y, color);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void aa_textprintf_centre(BITMAP *bmp, FONT *font, int x, int y, int color, char *format, ...)
{
 char buf[256];

 va_list ap;
 va_start(ap, format);
 vsprintf(buf, format, ap);
 va_end(ap);

 aa_textout_centre(bmp, font, buf, x, y, color);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_trans_blend(int r, int g, int b, int a)
{
 if (current_gfx_driver) if (current_gfx_driver->set_trans_blender)
 (current_gfx_driver->set_trans_blender)(r, g, b, a);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_add_blend(int r, int g, int b, int a)
{
 if (current_gfx_driver) if (current_gfx_driver->set_add_blender)
 (current_gfx_driver->set_add_blender)(r, g, b, a);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_trans_add_blend(int r, int g, int b, int a)
{
 if (current_gfx_driver) if (current_gfx_driver->set_trans_add_blender)
 (current_gfx_driver->set_trans_add_blender)(r, g, b, a);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _add_dirty(int x, int y, int w, int h, int n, int x1, int y1, int x2, int y2)
{
 if (current_gfx_driver) if (current_gfx_driver->add_dirty)
 (current_gfx_driver->add_dirty)(x, y, w, h, n, x1, y1, x2, y2);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void trans_rectfill(BITMAP *bmp, int x1, int y1, int x2, int y2, int c)
{
 if (current_gfx_driver) if (current_gfx_driver->trans_rectfill)
 (current_gfx_driver->trans_rectfill)(bmp, x1, y1, x2, y2, c);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_quantity(BITMAP *bmp, int q, int max_q, int x, int y, int w, int h, int c)
{
 if (current_gfx_driver) if (current_gfx_driver->draw_quantity)
 (current_gfx_driver->draw_quantity)(bmp, q, max_q, x, y, w, h, c);
}
/*****************************************************************************

    Function: draw_target

    Description: deseneaza o tinta
    Parameters: (x, y, w, h) - coordonatele si dimensiunile
                (s)          - dimensiunea marginii
                (c)          - culoarea
    Return: N/A

*****************************************************************************/
void draw_target(BITMAP *bmp, int x, int y, int w, int h, int s, int c, fixed rot)
{
 if (current_gfx_driver) if (current_gfx_driver->draw_target)
 (current_gfx_driver->draw_target)(bmp, x, y, w, h, s, c, rot);
}
/*****************************************************************************

    Function: draw_lightning

    Description: deseneaza un fulger
    Parameters: (x1, y1, x2, y2)- coordonatele
                (d)             - dirty
    Return: N/A

*****************************************************************************/
void draw_lightning(BITMAP *bmp, int x1, int y1, int x2, int y2, int d)
{
 if (current_gfx_driver) if (current_gfx_driver->draw_lightning)
 (current_gfx_driver->draw_lightning)(bmp, x1, y1, x2, y2, d);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_anim_lights(BITMAP *bmp, ANIM *anim, int x, int y)
{
 if (!anim) return;
 if (x<-anim->w || x>=bmp->w+anim->w || y<-anim->h || y>=bmp->h+anim->h) return;

 if (current_gfx_driver) if (current_gfx_driver->draw_anim_lights)
 (current_gfx_driver->draw_anim_lights)(bmp, anim, x, y);
}
/*****************************************************************************

    Function: draw_anim

    Description: deseneaza o animatie folosind un cache pt faze
    Parameters: blah
    Return: N/A

*****************************************************************************/
void draw_anim(BITMAP *bmp, ANIM *anim, int x, int y)
{
 if (!anim) return;

 anim->x=x;
 anim->y=y;
 if (x<-anim->w || x>=bmp->w+anim->w || y<-anim->h || y>=bmp->h+anim->h) return;

 CALL_ANIM_SCRIPT1(anim, draw, anim);

 if (current_gfx_driver) if (current_gfx_driver->draw_anim)
 (current_gfx_driver->draw_anim)(bmp, anim, x, y);
}
/*****************************************************************************

    Function: draw_trans_anim

    Description: deseneaza o animatie transparenta fara a tine seama de flags
    Parameters: (bmp)   - bitmap-ul unde va desena
                (p)     - pointer la animatie
                (x, y)  - pozitia
    Return: N/A

*****************************************************************************/
void draw_trans_anim(BITMAP *bmp, ANIM *anim, int x, int y)
{
 if (!anim) return;

 anim->x=x;
 anim->y=y;
 if (x<-anim->w || x>=bmp->w+anim->w || y<-anim->h || y>=bmp->h+anim->h) return;

 CALL_ANIM_SCRIPT1(anim, draw, anim);

 if (current_gfx_driver) if (current_gfx_driver->draw_trans_anim)
 (current_gfx_driver->draw_trans_anim)(bmp, anim, x, y);
}
/*****************************************************************************

    Function: draw_lit_anim

    Description: deseneaza o animatie luminata fara a tine seama de flags
    Parameters: (bmp)   - bitmap-ul unde va desena
                (p)     - pointer la animatie
                (x, y)  - pozitia
                (color) - gradul de iluminare
    Return: N/A

*****************************************************************************/
void draw_lit_anim(BITMAP *bmp, ANIM *anim, int x, int y, int color)
{
 if (!anim) return;

 anim->x=x;
 anim->y=y;
 if (x<-anim->w || x>=bmp->w+anim->w || y<-anim->h || y>=bmp->h+anim->h) return;

 CALL_ANIM_SCRIPT1(anim, draw, anim);

 if (current_gfx_driver) if (current_gfx_driver->draw_lit_anim)
 (current_gfx_driver->draw_lit_anim)(bmp, anim, x, y, color);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void anim_flags(ANIM *anim, int flags)
{
 anim->flags=flags;
 CALL_ANIM_SCRIPT1(anim, flags, anim);
 //process_anim(anim);
}
/*****************************************************************************

    Function: process_anim

    Description: proceseaza o animatie
    Parameters: (p) - pointer la animatie
    Return:  0 - daca totul OK
            -1 - daca animatia s-a terminat

*****************************************************************************/
int process_anim(ANIM *anim)
{
 if (!anim) return -1;

 anim->timer+=anim->speed;
 CALL_ANIM_SCRIPT1(anim, process, anim);

 if (current_gfx_driver) if (current_gfx_driver->get_anim_dims)
 (current_gfx_driver->get_anim_dims)(anim);

 return anim->done;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
ANIM *animdup(ANIM *anim)
{
 ANIM *temp;

 if (!anim) return NULL;

 temp=alloc_mem(sizeof(ANIM));
 if (!temp) return NULL;

 memcpy(temp, anim, sizeof(ANIM));

 if (anim->prog) temp->prog=scCreate_Instance(anim->prog->code, "");

 if (temp->prog)
    {
     temp->_init_=scGet_Symbol(temp->prog, "init");
     temp->_shutdown_=scGet_Symbol(temp->prog, "shutdown");
     temp->_flags_=scGet_Symbol(temp->prog, "flags");
     temp->_draw_=scGet_Symbol(temp->prog, "draw");
     temp->_process_=scGet_Symbol(temp->prog, "process");
    }

 CALL_ANIM_SCRIPT1(temp, init, temp);

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void destroy_anim(ANIM *anim)
{
 if (!anim) return;

 CALL_ANIM_SCRIPT1(anim, shutdown, anim);

 scFree_Instance(anim->prog);
 free_mem(anim);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_gfx_flags(int flags)
{
 if (current_gfx_driver) if (current_gfx_driver->set_gfx_flags)
 (current_gfx_driver->set_gfx_flags)(flags);
}
/*****************************************************************************

    Function: gfx_init

    Description: seteaza o rezolutie. Aloca memorie pt buffer, pt background
                 si seteaza paleta; Suporta DoubleBuffer.
    Parameters:

    Return:  0 - totul OK
            -1 - eroare

*****************************************************************************/
int init_gfx(GFX_ENGINE_DRIVER *driver)
{
 if (!driver)
    {
     sprintf(error_msg, "No gfx driver!");
     error_flag=1;
     return -1;
   }

 current_gfx_driver=driver;
 if (current_gfx_driver) if (current_gfx_driver->init)
 return (current_gfx_driver->init)();

 sprintf(error_msg, "Bad gfx driver (No init function)!");
 error_flag=1;
 return -1;
}
/*****************************************************************************

    Function: gfx_init

    Description: seteaza o rezolutie. Aloca memorie pt buffer, pt background
                 si seteaza paleta; Suporta DoubleBuffer.
    Parameters:

    Return:  0 - totul OK
            -1 - eroare

*****************************************************************************/
int init_gfx_data()
{
 if (current_gfx_driver) if (current_gfx_driver->init2)
 return (current_gfx_driver->init2)();

 return 0;
}
/*****************************************************************************

    Function: gfx_shutdown

    Description: dezaloca totul
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void shutdown_gfx()
{
 if (current_gfx_driver) if (current_gfx_driver->shutdown) (current_gfx_driver->shutdown)();
}
/*****************************************************************************

    Function: blit_buffer

    Description: afiseaza buffer-ul pe ecran cu/fara dirty folosind DoubleBuffer
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void flip()
{
 if (current_gfx_driver) if (current_gfx_driver->flip) (current_gfx_driver->flip)();
}


