#ifndef _FILE_H_
#define _FILE_H_

//---------------------------------------------------------------------------
#define DEFAULT_STR             "-999"
#define DEFAULT_INT             -999

//define-uri care ajuta la citirea string-urilor si integer-urilor
//GET_INT
//GET_FLT
//GET_STR - (var) ia valoarea variabilei (name) din sectiunea (section)
//GET_PROP_STR - are nevoie de 2 variabile: char _ds[256], int _di
//          (_ds) va contine stringul gasit la variabila (name), sectiunea
//          (section). Acest string este cautat in tabela (table) care are
//          (table_nr) elemente si index-ul gasit este stocat in (var)

#define GET_INT(var, section, name)\
            var=_get_config_int(section,    name, DEFAULT_INT);\
            if (var==DEFAULT_INT)\
                {\
                 sprintf(error_msg, "Integer '%s->%s' not found. Check config file.",   section, name);\
                 error_flag=1;\
                }

#define GET_FLT(var, section, name)\
            var=_get_config_float(section, name,    DEFAULT_INT);\
            if (var==DEFAULT_INT)\
                {\
                 sprintf(error_msg, "Float '%s->%s' not found. Check config file.", section, name);\
                 error_flag=1;\
                }

#define GET_STR(var, section, name)\
            strcpy(var, _get_config_string(section, name, DEFAULT_STR));\
            if (!stricmp(var, DEFAULT_STR))\
                {\
                 sprintf(error_msg, "String '%s->%s' not found. Check config file.", section,   name);\
                 error_flag=1;\
                }

#define SET_STR(var, section, name)\
            _set_config_string(section, name, var);

/*#define GET_PROP_STR(var, prop, types, section, vname)                  \
            {                                                           \
             char _ds[256];                                             \
             int _di;                                                   \
                                                                        \
             GET_STR(_ds, section, vname);                              \
             if (!error_flag)                                           \
                {                                                       \
                 var=-1;                                                \
                 for (_di=0;_di<types;_di++) if (!stricmp(_ds, prop[_di].name)) var=_di;\
                 if (var<0)                                             \
                    {                                                   \
                     sprintf(error_msg, "Unknown %s->%s type - '%s'", section, vname, _ds);\
                     error_flag=1;                                      \
                    }                                                   \
                }                                                       \
            }
*/
#define CHECK_STATUS if (error_flag) break;
#define CHECK_STATUS2 if (error_flag) {error_flag=0;break;}

//---------------------------------------------------------------------------
typedef struct CLINE
    {
     int  data_size;
     char *data;

     struct CLINE *prev, *next;
    } CLINE;

typedef struct CFILE
    {
     char filename[32];
     struct CLINE *lines, *last_line;
    } CFILE;

//---------------------------------------------------------------------------
CFILE   *current_config_file;

char    current_section_name[256];
CLINE   *current_section_line;

//---------------------------------------------------------------------------
void LOG(char *format, ...);
struct ANIM *compile_animation(char *name);
int  read_rules();
void fputi(int i, FILE *f);
int  fgeti(FILE *f);
int  fsize(FILE *f);
char *get_game_filename(char *name);
int  get_object(DATAFILE *d, char *name);
void log_to_file(char *format, ...);

int compare_file_time(char *f1, char *f2);
time_t get_file_time(char *f);
void set_file_time(char *f, time_t t);

void insert_line(CFILE *f, CLINE *l, CLINE *last);
void add_line(CFILE *f, CLINE *l);
void remove_line(CFILE *f, CLINE *l);
int   open_config_file(char *filename);
void  close_config_file();
CLINE *_find_section(char *section);
CLINE *find_section(char *section);
char  *_get_config_string(char *section, char *name, char *def);
float _get_config_float(char *section, char *name, float def);
int   _get_config_int(char *section, char *name, int def);
void  _set_config_string(char *section, char *name, char *val);
void  _set_config_float(char *section, char *name, float val);
void  _set_config_int(char *section, char *name, int val);

//---------------------------------------------------------------------------
#endif

