/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.	   
 *
 *	File I/O
 */

#include "standard.h"
#include "file.h"

#include "script.h"
#include "alliance.h"
#include "unit.h"
#include "player.h"
#include "particle.h"
#include "gfx.h"
#include "misc.h"

//#define   printf dummy_printf

extern int   order_param[MAX_ORDER_TYPES];

//int dummy_printf(char *format, ...) {return 0;}

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
char *get_game_filename(char *name)
{
 static char filename[256];

 sprintf(filename, "%s\\%s", game_dir, name);

 return filename;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void strip_spaces(char *str)
{
 int i;
 int length=MIN(256, strlen(str));
 char str1[256];

 for (i=length-2;i>=0;i--) if (str[i]!=32) break;
 length=i+2;
 str[length]=0;

 for (i=0;i<length;i++) if (str[i]!=32) break;
 strcpy(str1, &str[i]);
 strcpy(str, str1);
}
/*****************************************************************************

    Function: get_object

    Description: gaseste un obiect intr-un datafile
    Parameters: (d)   - datafile
                (name)- numele obiectului
    Return: indexul obiectului daca il gaseste
            -1 daca nu

*****************************************************************************/
int get_object(DATAFILE *d, char *name)
{
 int i;

 for (i=0;d[i].type!=DAT_END;i++)
    {
     if (!strcmp(name, get_datafile_property(&d[i], DAT_NAME))) break;
    }

 if (d[i].type==DAT_END) return -1;

 return i;
}
/*****************************************************************************

    Function: compile_animation

    Description: citeste o animatie
    Parameters: (name) - numele sectiunii unde se gaseste animatia
    Return: OK   - pointer la animatie
            NULL - eroare

*****************************************************************************/
ANIM *compile_animation(char *name)
{
 ANIM *anim;

 error_flag=0;

 anim=alloc_mem(sizeof(ANIM));
 if (!anim)
    {
     sprintf(error_msg, "Could not allocate %ld bytes for '%s'", sizeof(ANIM), name);
     error_flag=1;

     return NULL;
    }

 scSeeR_Set(scSeeR_StackSize, anim_stack_size);
 anim->prog=compile_file("anim\\", name);
 if (error_flag!=0) return NULL;

 if (anim->prog)
    {
     anim->_init_    =scGet_Symbol(anim->prog, "init");
     anim->_shutdown_=scGet_Symbol(anim->prog, "shutdown");
     anim->_flags_   =scGet_Symbol(anim->prog, "flags");
     anim->_draw_    =scGet_Symbol(anim->prog, "draw");
     anim->_process_ =scGet_Symbol(anim->prog, "process");
    }

 CALL_SCRIPT1(anim, init, anim);

 return anim;
}
/*****************************************************************************

    Function: read_rules

    Description: citeste fisierul de configurare si incarca toate structurile
    Parameters: N/A
    Return:  0 - OK
            -1 - Error

*****************************************************************************/
int read_rules()
{
 int i, j, k;
 char str[256],  str1[256], str2[256], *tok;
 scInstance *prog;

 //citeste numele unitatilor
 error_flag=0;
 unit_types=0;
 for (j=0;j<MAX_UNIT_TYPES;j++, unit_types++)
    {
     UPDATE_LOAD_LEVEL(1);
     sprintf(str, "UNIT %d", j);
     if (!find_section(str)) break;

     GET_STR(unit_prop[j].name, str, "Name"); CHECK_STATUS;
	 for (i=0;i<j;i++) 
	  if (!stricmp(unit_prop[i].name, unit_prop[j].name))
		{
		 sprintf(error_msg, "Duplicate names - %s", unit_prop[j].name);
		 error_flag=1;
		 return -1;
		}
	}
 if (error_flag==1) return -1;

 //citeste proprietatile fiecarei  arme
 error_flag=0;
 weapon_types=0;
 for (j=0;j<MAX_WEAPON_TYPES;j++, weapon_types++)
    {
//     UPDATE_LOAD_LEVEL(1);
     sprintf(str, "WEAPON %d", j);
     if (!find_section(str)) break;

     GET_STR(weapon_prop[j].name,       str,    "Name");        CHECK_STATUS;
     GET_INT(weapon_prop[j].bullet_type,str,    "Bullet type"); CHECK_STATUS;
     GET_INT(weapon_prop[j].damage,     str,    "Damage");      CHECK_STATUS;
     GET_INT(weapon_prop[j].rate,       str,    "Rate");        CHECK_STATUS;
     GET_INT(weapon_prop[j].splash,     str,    "Splash");      CHECK_STATUS;
     GET_INT(weapon_prop[j].range,      str,    "Range");       CHECK_STATUS;
     GET_INT(weapon_prop[j].speed,      str,    "Speed");       CHECK_STATUS;

     GET_STR(str1, str, "Animation");       CHECK_STATUS;
     weapon_prop[j].anim=compile_animation(str1);
     CHECK_STATUS;
    }
 if (error_flag==1) return -1;

 //citeste proprietatile fiecarui ordin
 error_flag=0;
 order_types=0;
 for (j=0;j<MAX_ORDER_TYPES;j++, order_types++)
    {
     UPDATE_LOAD_LEVEL(1);
     sprintf(str, "ORDER %d", j);
     if (!find_section(str)) break;

     order_prop[j].params=order_param[j];
     GET_STR(order_prop[j].name,        str,    "Name");        CHECK_STATUS;
     GET_STR(str1,                      str,    "Shortcut");    CHECK_STATUS;
     order_prop[j].key=str1[0];

     GET_STR(str1,                      str,    "Icon");        CHECK_STATUS;
     order_prop[j].icon=compile_animation(str1);
     CHECK_STATUS;
    }
 if (error_flag==1) return -1;

 //citeste proprietatile fiecarei constructii
 error_flag=0;
 build_types=0;
 for (j=0;j<MAX_BUILD_TYPES;j++, build_types++)
    {
     UPDATE_LOAD_LEVEL(1);
     sprintf(str, "BUILD %d", j);
     if (!find_section(str)) break;

     GET_STR(build_prop[j].name,        str,    "Name");        CHECK_STATUS;
     GET_INT(build_prop[j].time,        str,    "Time");        CHECK_STATUS;
     GET_INT(build_prop[j].aluminium,   str,    "Aluminium");   CHECK_STATUS;
     GET_INT(build_prop[j].steel,       str,    "Steel");       CHECK_STATUS;
     GET_INT(build_prop[j].gold,        str,    "Gold");        CHECK_STATUS;
     GET_STR(str1,                      str,    "Shortcut");    CHECK_STATUS;
     build_prop[j].key=str1[0];

	 for (i=0;i<unit_types;i++) if (!stricmp(build_prop[j].name, unit_prop[i].name)) break;
     if (i>=unit_types && stricmp(build_prop[j].name, "Nothing"))//nu a gasit
        {
		 sprintf(error_msg, "Build '%s' (%s) - there is no such unit!", build_prop[j].name, str);
		 error_flag=1;
		 break;
        }
	 build_prop[j].unit=i;

     GET_STR(str1,                      str,    "Icon");        CHECK_STATUS;
     build_prop[j].icon=compile_animation(str1);
     CHECK_STATUS;
    }
 if (error_flag==1) return -1;

 //citeste proprietatile fiecarui upgrade
 error_flag=0;
 upgrade_types=0;
 for (j=0;j<MAX_UPGRADE_TYPES;j++, upgrade_types++)
    {
     UPDATE_LOAD_LEVEL(1);
     sprintf(str, "UPGRADE %d", j);
     if (!find_section(str)) break;

     GET_STR(upgrade_prop[j].name,              str, "Name");               CHECK_STATUS;
     GET_INT(upgrade_prop[j].time,              str, "Time");               CHECK_STATUS;
     GET_INT(upgrade_prop[j].aluminium,         str, "Aluminium");          CHECK_STATUS;
     GET_INT(upgrade_prop[j].aluminium_factor,  str, "Aluminium factor");   CHECK_STATUS;
     GET_INT(upgrade_prop[j].steel,             str, "Steel");              CHECK_STATUS;
     GET_INT(upgrade_prop[j].steel_factor,      str, "Steel factor");       CHECK_STATUS;
     GET_INT(upgrade_prop[j].gold,              str, "Gold");               CHECK_STATUS;
     GET_INT(upgrade_prop[j].gold_factor,       str, "Gold factor");        CHECK_STATUS;
     GET_STR(str1,                              str, "Shortcut");           CHECK_STATUS;
     upgrade_prop[j].key=str1[0];

     GET_STR(str1,                              str, "Icon");               CHECK_STATUS;
     upgrade_prop[j].icon=compile_animation(str1);
     CHECK_STATUS;
    }
 if (error_flag==1) return -1;

 //citeste proprietatile animatiilor particulelor
 error_flag=0;
 particle_types=0;
 for (j=0;j<MAX_PARTICLES;j++, particle_types++)
    {
     UPDATE_LOAD_LEVEL(1);
     sprintf(str, "Particle %d", j);
     if (find_section(str))
        {
         GET_STR(str1,                              str, "Animation");      CHECK_STATUS;
         particle_prop[j].anim=compile_animation(str1);
         CHECK_STATUS;
        }
    }
 if (error_flag==1) return -1;

 error_flag=0;
 for (j=0;j<MAX_UNIT_TYPES;j++)
    {
     UPDATE_LOAD_LEVEL(2);
     sprintf(str, "UNIT %d", j);
     if (!find_section(str)) break;

     //citeste proprietetile initiale ale unitatii
     GET_INT(unit_prop[j].supply,       str, "Supply");         CHECK_STATUS;
     GET_INT(unit_prop[j].aluminium,    str, "Aluminium");      CHECK_STATUS;
     GET_INT(unit_prop[j].steel,        str, "Steel");          CHECK_STATUS;
     GET_INT(unit_prop[j].gold,         str, "Gold");           CHECK_STATUS;
     GET_INT(unit_prop[j].life,         str, "Life");           CHECK_STATUS;
     GET_INT(unit_prop[j].mana,         str, "Mana");           CHECK_STATUS;
     GET_INT(unit_prop[j].shield,       str, "Shield");         CHECK_STATUS;
     GET_INT(unit_prop[j].armour,       str, "Armour");         CHECK_STATUS;
     GET_INT(unit_prop[j].speed,        str, "Speed");          CHECK_STATUS;
     GET_INT(unit_prop[j].agressivity,  str, "Agressivity");    CHECK_STATUS;
     GET_INT(unit_prop[j].radar_range,  str, "Radar range");    CHECK_STATUS;
     GET_INT(unit_prop[j].radar_type,   str, "Radar type");     CHECK_STATUS;
     GET_INT(unit_prop[j].cloaking_type,str, "Cloaking type");  CHECK_STATUS;
     GET_INT(unit_prop[j].rot_speed,    str, "Rot speed");      CHECK_STATUS;

     GET_STR(str1, str, "Animation");							CHECK_STATUS;
     unit_prop[j].anim=compile_animation(str1);
     CHECK_STATUS;

     GET_STR(str1, str, "Icon");								CHECK_STATUS;
     unit_prop[j].icon=compile_animation(str1);
     CHECK_STATUS;

     GET_STR(str1, str, "Script");								CHECK_STATUS;
     scSeeR_Set(scSeeR_StackSize, ai_stack_size);
     prog=compile_file("ai\\", str1);
     CHECK_STATUS;
     if (prog) unit_prop[j].script=prog->code;
     if (prog) scFree_Instance(prog);

     build_prop[j+1].supply=unit_prop[j].supply;

	 GET_STR(str1, str, "Weapon");
	 if (!error_flag)
		{
		 for (i=0;i<weapon_types;i++) if (!stricmp(str1, weapon_prop[i].name)) break;
		 if (i>=weapon_types) 
			{
			 sprintf(error_msg, "Unknown %s (%s) weapon - '%s'", unit_prop[j].name, str, str1);
			 error_flag=1;
			 break;
			}
		 unit_prop[j].weapon=i;
		}
	 error_flag=0;
     
     GET_STR(str1, str, "Pre-requiste");
	 if (!error_flag)
		{
		 tok=strtok(str1, ",");
		 while (tok && unit_prop[j].prerequiste_count<MAX_UNIT_TYPES)
			{
			 strcpy(str2, tok);
			 strip_spaces(str2);

			 for (i=0;i<unit_types;i++) if (!stricmp(str2, unit_prop[i].name)) break;
			 if (i>=unit_types) 
				{
				 sprintf(error_msg, "Unknown %s (%s) pre-requiste - '%s'", unit_prop[j].name, str, str2);
				 error_flag=1;
				 break;
				}
			 unit_prop[j].prerequiste[unit_prop[j].prerequiste_count]=i;
			 unit_prop[j].prerequiste_count++;
			 tok=strtok(NULL, ",");
			}

		 CHECK_STATUS;
		}
	 error_flag=0;

	 unit_prop[j].order[0]=ORD_DIE;
	 unit_prop[j].order_count++;

     GET_STR(str1, str, "Orders");
	 if (!error_flag)
		{
		 tok=strtok(str1, ",");
		 while (tok && unit_prop[j].order_count<MAX_ORDER_TYPES)
			{
			 strcpy(str2, tok);
			 strip_spaces(str2);

			 for (i=0;i<order_types;i++) if (!stricmp(str2, order_prop[i].name)) break;
			 if (i>=order_types) 
				{
				 sprintf(error_msg, "Unknown %s (%s) order - '%s'", unit_prop[j].name, str, str2);
				 error_flag=1;
				 break;
				}
			 unit_prop[j].order[unit_prop[j].order_count]=i;
			 unit_prop[j].order_count++;
			 tok=strtok(NULL, ",");
			}

		 CHECK_STATUS;
		}
	 error_flag=0;
     
     GET_STR(str1, str, "Builds");
	 if (!error_flag)
		{
		 tok=strtok(str1, ",");
		 while (tok && unit_prop[j].build_count<MAX_BUILD_TYPES)
			{
			 strcpy(str2, tok);
			 strip_spaces(str2);

			 for (i=0;i<build_types;i++) if (!stricmp(str2, build_prop[i].name)) break;
			 if (i>=build_types) 
				{
				 sprintf(error_msg, "Unknown %s (%s) build - '%s'", unit_prop[j].name, str, str2);
				 error_flag=1;
				 break;
				}

			 unit_prop[j].build[unit_prop[j].build_count]=i;
			 unit_prop[j].build_count++;
			 tok=strtok(NULL, ",");
			}

		 CHECK_STATUS;
		}
	 error_flag=0;

     GET_STR(str1, str, "Upgrades");
	 if (!error_flag)
		{
		 tok=strtok(str1, ",");
		 while (tok && unit_prop[j].upgrade_count<MAX_UPGRADE_TYPES)
			{
			 strcpy(str2, tok);
			 strip_spaces(str2);

			 for (i=0;i<upgrade_types;i++) if (!stricmp(str2, upgrade_prop[i].name)) break;
			 if (i>=upgrade_types) 
				{
				 sprintf(error_msg, "Unknown %s (%s) upgrade - '%s'", unit_prop[j].name, str, str2);
				 error_flag=1;
				 break;
				}
			 unit_prop[j].upgrade[unit_prop[j].upgrade_count]=i;
			 unit_prop[j].upgrade_count++;
			 tok=strtok(NULL, ",");
			}

		 CHECK_STATUS;
		}
 	 error_flag=0;
    }
 if (error_flag==1) return -1;

 error_flag=0;
 sprintf(str, "GENERAL");

 GET_STR(str1, str, "Brain script");
 if (error_flag) return -1;

 scSeeR_Set(scSeeR_StackSize, ai_stack_size);
 prog=compile_file("ai\\", str1);
 if (error_flag) return -1;

 if (prog) brain_script=prog->code;
 if (prog) scFree_Instance(prog);

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void fputi(int i, FILE *f)
{
 unsigned char *c0, *c1, *c2, *c3;

 c0=(unsigned char *)&i;
 c1=c0+1;
 c2=c0+2;
 c3=c0+3;

 fputc(*c0, f);
 fputc(*c1, f);
 fputc(*c2, f);
 fputc(*c3, f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int fgeti(FILE *f)
{
 int i;
 unsigned char c0, c1, c2, c3, *c;

 c0=fgetc(f);
 c1=fgetc(f);
 c2=fgetc(f);
 c3=fgetc(f);

 c=(unsigned char *)&i;

 *c=c0;
 *(c+1)=c1;
 *(c+2)=c2;
 *(c+3)=c3;

 return i;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int fsize(FILE *f)
{
 int size;
 int pos=ftell(f);

 fseek(f, 0, SEEK_END);
 size=ftell(f);

 fseek(f, pos, SEEK_SET);

 return size;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int compare_file_time(char *f1, char *f2)
{
 unsigned long t1, t2;

 t1=file_time(f1);
 t2=file_time(f2);

 if (t1 < t2) return 1;
 else if (t1 > t2) return -1;
 else return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
time_t get_file_time(char *f)
{
 return file_time(f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_file_time(char *f, time_t tt)
{
 struct utimbuf t;

 t.modtime=tt;
 t.actime=tt;

 utime(f, &t);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void LOG(char *format, ...)
{
 FILE *f;
 char buf[1024];
 static int y=0;

 va_list ap;
 va_start(ap, format);
 vsprintf(buf, format, ap);
 va_end(ap);

 f=fopen("alliance.log", "at");
 if (!f) return;

 fputs(buf, f);
 fflush(f);

 fclose(f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void insert_line(CFILE *f, CLINE *l, CLINE *last)
{
 if (last)
    {
     if (last->next)
        {
         last->next->prev=l;
         l->next=last->next;
        }
     last->next=l;
     l->prev=last;

     if (f->last_line==last) f->last_line=l;
    }
 else f->lines=l;

 _find_section(current_section_name);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void add_line(CFILE *f, CLINE *l)
{
 if (f->lines==NULL) f->lines=l;
 else
    {
     l->prev=f->last_line;
     f->last_line->next=l;
    }

 f->last_line=l;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void remove_line(CFILE *f, CLINE *l)
{
 if (f->lines==l)
    {
     f->lines=l->next;
     if (l->next) l->next->prev=NULL;
    }
 else
    {
     if (l->prev) l->prev->next=l->next;
     if (l->next) l->next->prev=l->prev;
    }

 if (f->last_line==l) f->last_line=l->prev;

 _find_section(current_section_name);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int open_config_file(char *filename)
{
 CFILE *cf;
 CLINE *line, *line1;
 FILE *f;
 char data[256], name[256];
 int done=0;
 int i, c;

 sprintf(name, "%s", filename);

 f=fopen(name, "rt");
 if (!f) goto ERROR;

 cf=alloc_mem(sizeof(CFILE));
 if (!cf) goto ERROR;

 strcpy(cf->filename, name);

 while (!done)
    {
     i=0;
     c=32;
     do {
         if (i>0 || (c!=32 && c!=9)) data[i++]=c;
         c=fgetc(f);
     } while (i<256 && !feof(f) && c!='\n');

     data[i++]=0;

//   if (data[0]!='#' && i>1)
        {
         line=alloc_mem(sizeof(CLINE));
         if (!line) goto ERROR;

         line->data_size=i;
         line->data=strdup(data);
         if (!line->data) goto ERROR;

         add_line(cf, line);
        }

     if (feof(f)) done=1;
    }

 fclose(f);

 line=cf->last_line;//elimina liniile de la sfarsit goale
 while (line)
    {
     line1=line->prev;

     if (line->data_size<2) remove_line(cf, line);
     else break;

     line=line1;
    }

 //if (current_config_file) close_config_file(current_config_file);
 current_config_file=cf;

 return 0;

ERROR:
 return -1;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void close_config_file()
{
 FILE *f;
 CLINE *line, *line1;

 if (!current_config_file) return;

 f=fopen(current_config_file->filename, "wt");
 if (!f) return;

 line=current_config_file->lines;
 while (line)
    {
     line1=line->next;

     fprintf(f, "%s\n", line->data);
     free_mem(line->data);
     free_mem(line);

     line=line1;
    }

 current_config_file=NULL;

 fclose(f);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
CLINE *_find_section(char *section)
{
 CLINE *line;
 int len;

 if (!current_config_file) return NULL;

 len=strlen(section);

 line=current_config_file->lines;
 while (line)
    {
     if (line->data_size>=len+2) if (line->data[0]=='[') if (!strnicmp(line->data+1,    section, len))
        {
         strcpy(current_section_name, section);
         current_section_line=line;

         return line;
        }

     line=line->next;
    }

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
CLINE *find_section(char *section)
{
 if (!current_config_file) return NULL;

 if (!stricmp(section, current_section_name)) return current_section_line;
 else return _find_section(section);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
char *_get_config_string(char *section, char *name, char *def)
{
 CLINE *line;
 int len;
 int done=0;

 if (!current_config_file) return NULL;

 line=find_section(section);
 if (!line) return def;

 len=strlen(name);

 while (!done)
    {
     if (line->data_size>=len) if (!strnicmp(line->data,    name, len))
        {
         while (line->data[len]!='=' && len<line->data_size) len++;
         len++;
         while ((line->data[len]==32 || line->data[len]==9) && len<line->data_size) len++;

         return &line->data[len];
        }

     line=line->next;

     if (!line) done=1;
     else if (line->data_size>0) if (line->data[0]=='[') done=1;
    }

 return def;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
float _get_config_float(char *section, char *name, float def)
{
 char *val;

 val=_get_config_string(section, name, NULL);
 if (!val) return def;
 else return atof(val);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int _get_config_int(char *section, char *name, int def)
{
 char *val;

 val=_get_config_string(section, name, NULL);
 if (!val) return def;
 else return atoi(val);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _set_config_string(char *section, char *name, char *val)
{
 CLINE *line;
 int len;
 int done=0;
 char data[256];

 if (!current_config_file) return;

 line=find_section(section);
 if (!line) return;

 len=strlen(name);

 while (!done)
    {
     if (line->data_size>=len) if (!strnicmp(line->data,    name, len))
        {
         sprintf(data, "%s = %s", name, val);

         free_mem(line->data);
         line->data=strdup(data);

         return;
        }

     line=line->next;

     if (!line) done=1;
     else if (line->data_size>0) if (line->data[0]=='[') done=1;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _set_config_float(char *section, char *name, float val)
{
 char sval[50];

 sprintf(sval, "%.2f", val);

 _set_config_string(section, name, sval);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _set_config_int(char *section, char *name, int val)
{
 char sval[50];

 sprintf(sval, "%d", val);

 _set_config_string(section, name, sval);
}


