/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Buillet code.
 */

#include "standard.h"
#include "bullet.h"

#include "panel.h"
#include "gui.h"
#include "player.h"
#include "alliance.h"
#include "unit.h"
#include "gfx.h"
#include "misc.h"
#include "file.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
BULLET *nr2bullet(UNIT *u, int nr)
{
 BULLET *temp;

 if (u==NULL || nr<0) return NULL;

 temp=u->bullets;
 while (temp)
    {
     if (temp->nr==nr) break;

     temp=temp->next;
    }

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int bullet2nr(BULLET *b)
{
 if (!b) return -1;
 else return b->nr;
}
/*****************************************************************************

    Function: add_bullet

    Description: adauga un glont
    Parameters: (unit) - cui apartine
                (nr)   - numarul unitatii - -1 ca sa aloce singur un numar
                (type) - tipul unitatii
                (x, y) - pozitia pe harta

    Return: pointer la unitate daca ok
            NULL daca erroare

*****************************************************************************/
BULLET *add_bullet(UNIT *u, UNIT *target, int nr, int type)
{
 BULLET *temp=NULL;
 int x, y, w, h, i;

 u->bullet_timer-=UPDATE_TIME;
 if (u->bullet_timer>=weapon_prop[type].rate) return NULL;
 u->bullet_timer+=weapon_prop[type].rate;

 w=((BITMAP *)gfx[u->anim->sprite].dat)->w;
 h=((BITMAP *)gfx[u->anim->sprite].dat)->h;

 for (i=0;i<MAX_LOCATIONS;i++)
  if (u->anim->ws[i]>0)
    {
     temp=alloc_mem(sizeof(BULLET));
     if (!temp) return NULL;

     temp->type=type;
     if (nr<0) temp->nr=global_object_nr++;
     else temp->nr=nr;
     temp->target=target;
     temp->unit=u;

     x=u->anim->wx[i];
     y=u->anim->wy[i];
     get_rotated_pos(&x, &y, u->anim->rot);

     temp->x=temp->unit->x + x;
     temp->y=temp->unit->y + y;

     temp->anim=animdup(weapon_prop[unit_prop[u->type].weapon].anim);

     if (temp->anim) temp->anim->rot=u->anim->ws[i]+u->anim->rot;

     link_bullet(u, temp);
    }

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void link_bullet(struct UNIT *u, BULLET *b)
{
 b->unit=u;

 if (u->bullets==NULL) u->bullets=b;
 else
    {
     b->next=u->bullets;
     u->bullets->prev=b;
     u->bullets=b;
    }
}
/*****************************************************************************

    Function: remove_bullet

    Description: sterge un glont din lista
    Parameters: pointer la glont
    Return: N/A

*****************************************************************************/
void remove_bullet(BULLET *b)
{
 assert(b);

 if (b->unit->bullets==b)
    {
     b->unit->bullets=b->next;
     if (b->next) b->next->prev=NULL;
    }
 else
    {
     if (b->prev) b->prev->next=b->next;
     if (b->next) b->next->prev=b->prev;
    }

 destroy_anim(b->anim);
 free_mem(b);
}
/*****************************************************************************

    Function: draw_bullets

    Description: deseneaza gloantele
    Parameters: (unit) - unitatea
    Return: N/A

*****************************************************************************/
void draw_bullets(UNIT *unit)
{
 BULLET *temp;
 int xs, ys;
 int w, h;

 for (temp=unit->bullets; temp; temp=temp->next)
    {
     xs=temp->x-camera_x;
     ys=temp->y-camera_y;

     switch (weapon_prop[temp->type].bullet_type)
        {
         case WPN_TYPE_BULLET:
         case WPN_TYPE_MISSILE:
             if (!get_unit_visibility(me, unit)) break;//daca unitatea nu e vizibila
             if (!temp->anim || !temp->tx) break;

             draw_anim_centre(camera, temp->anim, xs, ys);
             draw_anim_lights_centre(camera, temp->anim, xs, ys);
             add_camera_dirty_centre(xs, ys, temp->anim->w, temp->anim->h, 2);
            break;

         case WPN_TYPE_FLASH:
             temp->i0++;
             if (!get_unit_visibility(me, unit)) break;//daca unitatea nu e vizibila

             w=temp->target->anim->w/2;
             h=temp->target->anim->h/2;

             draw_lightning(camera, xs, ys, temp->target->x-camera_x+(rand()%w)-w/2, temp->target->y-camera_y+(rand()%h)-h/2, 2);
             draw_lightning(camera, xs, ys, temp->target->x-camera_x+(rand()%w)-w/2, temp->target->y-camera_y+(rand()%h)-h/2, 0);
            break;
        }
    }
}
/*****************************************************************************

    Function: process_bullets

    Description: proceseaza gloantele
    Parameters: (u) - unitatea
    Return: N/A

*****************************************************************************/
void process_bullets(UNIT *unit)
{
 BULLET *temp, *temp1;
 UNIT *target;
 ORDER o;

 if (unit->alive==FLAG_DEAD)//daca parintele a murit
    {
     while (unit->bullets) remove_bullet(unit->bullets);

     return;
    }

 unit->bullet_count=0;
 temp=unit->bullets;
 while (temp)
    {
     temp1=temp->next;

     target=temp->target;
     if (target->alive==FLAG_DEAD)//daca tinta a murit
        {
         remove_bullet(temp);
        }
     else switch (weapon_prop[temp->type].bullet_type)
        {
         case WPN_TYPE_BULLET://loveste tinta imediat
             process_anim(temp->anim);

             if (temp->flag==0)
                {
                 float rot, dist;

                 rot=get_rot(unit->x, unit->y, target->x, target->y)+192;
                 temp->anim->rot=(int)rot%256;

                 dist=get_point2unit_dist(unit->x, unit->y, target);

                 temp->x=unit->x+fixtof(fixcos(ftofix(rot-192)))*dist;
                 temp->y=unit->y+fixtof(fixsin(ftofix(rot-192)))*dist;

                 damage(target, unit);
                 temp->flag=1;
                 temp->tx=999;
                }
             if (temp->flag==1)
                {
                 if (get_unit_visibility(me, unit)) 
                    {
                     anim_flags(temp->anim, ANIM_DIE_FLAG);
                     if (temp->anim->done) remove_bullet(temp);
                    }
                 else remove_bullet(temp);
                }
             break;

         case WPN_TYPE_MISSILE://urmareste tinta
             process_anim(temp->anim);

             if (temp->flag==0)
                {
                 temp->tx=999;

                 temp->i1=8;
                 temp->flag=1;
                }
             if (temp->flag==1)
                {
                 int rot, dist;

                 dist=get_point2unit_dist(temp->x, temp->y, target);

                 rot=get_rot(temp->x, temp->y, target->x, target->y)+192;
                 rotate(&temp->anim->rot, rot, MAX(64-dist, 3));

                 temp->dx=fixtof(fixcos(ftofix(temp->anim->rot-192)))*weapon_prop[temp->type].speed;
                 temp->dy=fixtof(fixsin(ftofix(temp->anim->rot-192)))*weapon_prop[temp->type].speed;

                 temp->x+=temp->dx;
                 temp->y+=temp->dy;

                 if (dist<12)
                    {
                     damage(target, unit);
                     temp->flag=2;
                    }
                }
             if (temp->flag==2)
                {
                 if (get_unit_visibility(me, unit)) 
                    {
                     anim_flags(temp->anim, ANIM_DIE_FLAG);
                     if (temp->anim->done) remove_bullet(temp);
                    }
                 else remove_bullet(temp);
                }
            break;

         case WPN_TYPE_FLASH://fulgere - lovesc tinta imediat
             temp->i1++;
             if ((temp->i0>0 && temp->i1>6) || unit->speed>0)
                {
                 damage(target, unit);
                 remove_bullet(temp);
                }
            break;

         case WPN_TYPE_KAMIKAZE://explozie in care moare unitatea lansatoare
             damage(target, unit);
             remove_bullet(temp);
             o.order=ORD_DIE;
			 add_unit_order(unit, &o, 0);
            break;
        }

     unit->bullet_count++;
     temp=temp1;
    }
}
