/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Building code.
 */

#include "standard.h"
#include "building.h"

#include "alliance.h"
#include "player.h"
#include "gfx.h"
#include "misc.h"
#include "panel.h"
#include "gui.h"
#include "file.h"
#include "script.h"

/*****************************************************************************

    Function: remove_unit

    Description: sterge o unitate din lista
    Parameters: pointer la unitate
    Return: N/A

*****************************************************************************/
UNIT *add_building(struct PLAYER *p, int nr, char *name, int x, int y)
{
 UNIT *temp;
 int i, type;

 for (i=0;i<unit_types;i++)
  if (!stricmp(name, unit_prop[i].name)) break;

 if (i>=unit_types) return NULL;
 type=i;

 if (unit_prop[type].type!=TYPE_BUILDING) return NULL;

 temp=alloc_mem(sizeof(UNIT));
 if (!temp) return NULL;

 temp->alive=FLAG_ALIVE;
 temp->type=type;
 if (nr<0) temp->nr=global_object_nr++;
 else temp->nr=nr;
 temp->x=x;
 temp->y=y;
 temp->life     =unit_prop[type].life;
 temp->shield   =unit_prop[type].shield;
 temp->mana     =unit_prop[type].mana;
 temp->aluminium=unit_prop[type].aluminium;
 temp->steel    =unit_prop[type].steel;
 temp->gold     =unit_prop[type].gold;
 temp->player   =p;

 if (unit_prop[type].script)
    {
     temp->prog=scCreate_Instance(unit_prop[type].script, "");
     if (!temp->prog) goto ERROR;

     temp->_init_=scGet_Symbol(temp->prog, "init");
     temp->_shutdown_=scGet_Symbol(temp->prog, "shutdown");
     temp->_kill_=scGet_Symbol(temp->prog, "kill");
     temp->_damage_=scGet_Symbol(temp->prog, "damage");
     temp->_draw_=scGet_Symbol(temp->prog, "draw");
     temp->_process_=scGet_Symbol(temp->prog, "process");
     temp->_process_ai_=scGet_Symbol(temp->prog, "process_ai");
    }

 temp->anim=animdup(unit_prop[type].anim);
 temp->icon=animdup(unit_prop[type].icon);

 fix_map_coords_centre_f(&temp->x, &temp->y, temp->anim->w, temp->anim->h);

 link_building(p, temp);

 return temp;

ERROR:
 if (temp->prog)
    {
     scKill_Instance(temp->prog);
     scFree_Instance(temp->prog);
    }

 destroy_anim(temp->icon);
 destroy_anim(temp->anim);
 free_mem(temp);

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void link_building(struct PLAYER *p, UNIT *b)
{
 b->player=p;

 if (p->buildings==NULL) p->buildings=b;
 else
    {
     b->prev=p->last_building;
     p->last_building->next=b;
    }
 p->last_building=b;

 CALL_SCRIPT1(b, init, b);
}
/*****************************************************************************

    Function: remove_unit

    Description: sterge o unitate din lista
    Parameters: pointer la unitate
    Return: N/A

*****************************************************************************/
void remove_building(UNIT *b)
{
 assert(b);

 if (b->player->buildings==b)
    {
     b->player->buildings=b->next;
     if (b->next) b->next->prev=NULL;
    }
 else
    {
     if (b->prev) b->prev->next=b->next;
     if (b->next) b->next->prev=b->prev;
    }

 if (b->player->last_building==b) b->player->last_building=b->prev;

 CALL_SCRIPT1(b, shutdown, b);
 if (b->prog) scFree_Instance(b->prog);

 while (b->bullets) remove_bullet(b->bullets);

 destroy_anim(b->icon);
 destroy_anim(b->anim);

 free_mem(b);
}
/*****************************************************************************

    Function: remove_unit

    Description: sterge o unitate din lista
    Parameters: pointer la unitate
    Return: N/A

*****************************************************************************/
