#ifndef _MAIN_H_
#define _MAIN_H_

//--------------------------------------------------------------------------
//#include "ship.h"
//#include "weapon.h"
//#include "gfx.h"

//--------------------------------------------------------------------------
#define VER                 19
#define UPDATE_TIME         30
#define MAX_STACK           512

#define GAME_FLAG_PAUSED    1

#define ENTER LOG("\nE%s", __FUNCTION__)
#define LEAVE LOG("\nL%s", __FUNCTION__)

#define START_LOAD_LEVEL(x, y, w, h, c)                                   \
    {                                                                     \
     load_level=0;                                                        \
     load_x=x;                                                            \
     load_y=y;                                                            \
     load_w=w;                                                            \
     load_h=h;                                                            \
     load_color=c;                                                        \
                                                                          \
     acquire_screen();                                                    \
     rect(screen, load_x, load_y, load_x+1+load_w, load_y+1+load_h, makecol(64, 64, 255));\
     release_screen();                                                    \
    }                                                                         

#define UPDATE_LOAD_LEVEL(x)                                              \
    {                                                                     \
     int __x=(x);                                                         \
     if (load_level+__x>=load_w-1) __x=load_w-load_level-2;               \
                                                                          \
     acquire_screen();                                                    \
     rectfill(screen, load_x+load_level, load_y+1, load_x+load_level+__x, load_y+load_h, load_color);\
     release_screen();                                                    \
                                                                          \
     load_level+=__x;                                                     \
    }                                                                         

#define END_LOAD_LEVEL() UPDATE_LOAD_LEVEL(load_w-load_level)

//#undef UPDATE_LOAD_LEVEL
//#define UPDATE_LOAD_LEVEL(x)

//--------------------------------------------------------------------------
DATAFILE *gfx;

volatile long game_count, start_time;

int load_level, load_x, load_y, load_w, load_h, load_color;

char error_msg[256];
int error_flag;
unsigned long game_flags;
long free_phisical, free_virtual, total_phisical, total_virtual;

float stack[MAX_STACK];
int stack_level;

int global_object_nr;

char game_dir[256];

//---------------------------------------------------------------------------
void push(float v);
float pop();

void get_mem_info();
void fatal(char *format, ...);

int  init();
void shutdown();
int  init_game();
void shutdown_game();
int  init_data();
void shutdown_data();

void process_everything();
void draw_everything();

//---------------------------------------------------------------------------
#endif
