/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *  
 *  Main file. Diagnostic and generic functions
 */

#include "standard.h"

#define select		____select
#define shutdown	____shutdown
#include <winalleg.h>
#undef select
#undef shutdown
#undef ERROR

#include "alliance.h"

#include "script.h"
#include "file.h"
#include "gfx.h"
#include "panel.h"
#include "player.h"
#include "unit.h"
#include "map.h"
#include "gui.h"
#include "guiproc.h"
#include "particle.h"
#include "misc.h"

//---------------------------------------------------------------------------
void fps_proc(void)
{
 fps=(fps+frame_count*4)/2;
 frame_count=0;

// net_flow=net_flow_count;
// net_flow_count=0;
}
END_OF_FUNCTION(fps_proc);
//---------------------------------------------------------------------------
void game_proc(void)
{
 game_count+=5;
}
END_OF_FUNCTION(game_proc);
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void push(float v)
{
 if (stack_level<MAX_STACK)
    {
     stack[stack_level]=v;
     stack_level++;
    }
 else fatal("Internal stack overflow - increase stack size!!!");
}
float pop()
{
 if (stack_level>0)
    {
     stack_level--;
     return stack[stack_level];
    }

 fatal("Internal stack underflow - check code!!!");

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void fatal(char *format,...)
{
 char buf[512];

 va_list ap;
 va_start(ap, format);
 vsprintf(buf, format, ap);
 va_end(ap);
 
 allegro_message("Fatal error:\n%s\nPlease read the troubleshooting section.", buf);
 LOG("\nFATAL ERROR: %s", buf);

 shutdown();

 exit(0);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void get_mem_info()
{
 static int first_time=1;
 MEMORYSTATUS mem_info;
 unsigned char *buffer[32];
 int i;

 GlobalMemoryStatus(&mem_info);

 if (first_time)//calculeaza totalul de memorie doar prima data
    {
/*	 for (i=0;i<16;i++) buffer[i]=malloc(1048576);
	 for (i=0;i<16;i++) 
	  if (buffer[i])
		{
		 memset(buffer[i], 0, 1024);
		 free(buffer[i]);
//		 yield_timeslice();
		}
*/
     total_phisical=mem_info.dwTotalPhys;
     total_virtual=mem_info.dwTotalPageFile;
	 first_time=0;
    }

 free_phisical=mem_info.dwAvailPhys;
 free_virtual=mem_info.dwAvailPageFile;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void display_cpu_info()
{
 volatile long timer, mips;
 static char s[256];

 if (!strcmp(cpu_vendor, "")) strcpy(cpu_vendor, "Unknown");

 switch (cpu_family)
    {
     case 3: sprintf(s, "%s 386", cpu_vendor); break;

     case 4:
        switch (cpu_model)
            {
             case 0:
             case 1:
             case 3:  sprintf(s, "%s 486DX", cpu_vendor);  break;
             case 2:  sprintf(s, "%s 486SX", cpu_vendor);  break;
             case 4:  sprintf(s, "%s 486SL", cpu_vendor);  break;
             case 5:  sprintf(s, "%s 486SX2", cpu_vendor); break;
             case 7:  sprintf(s, "%s 486DX2", cpu_vendor); break;
             case 8:  sprintf(s, "%s 486DX4", cpu_vendor); break;
             case 14: sprintf(s, "Cyrix 486");             break;
             default: sprintf(s, "Unknown 486");           break;
            }
        break;

     case 5:
        sprintf(s, "%s Pentium class", cpu_vendor);

        if (strstr(cpu_vendor, "Intel")) sprintf(s, "%s Pentium", cpu_vendor);
        else if (strstr(cpu_vendor, "AMD"))
            {
             if (cpu_mmx)
                {
                 if (cpu_3dnow) sprintf(s, "%s K6(TM)-2", cpu_vendor);
                 else sprintf(s, "%s K6(TM)", cpu_vendor);
                }
             else sprintf(s, "%s K5", cpu_vendor);
            }
        else if (strstr(cpu_vendor, "Cyrix") || cpu_model==14) sprintf(s, "%s 6x86", cpu_vendor);
        break;

     case 6:
        sprintf(s, "%s Pentium Pro/II class", cpu_vendor);

        if (strstr(cpu_vendor, "Intel")) sprintf(s, "%s Pentium Pro/II", cpu_vendor);
        else if (strstr(cpu_vendor, "AMD")) sprintf(s, "%s Athlon", cpu_vendor);
        else if (strstr(cpu_vendor, "Cyrix") || cpu_model==14) sprintf(s, "%s M2", cpu_vendor);
        break;

     default:
        sprintf(s, "%s Unknown (family %d, model %d)", cpu_vendor, cpu_family, cpu_model);
        break;
    }

 mips=0;
 timer=game_count;
 while (game_count-timer<100) mips+=8;

 sprintf(s, "%s, (%ld MIPS)", s, mips*10/1000000);

 LOG("\n\t%s", s);

 LOG("\n\tCPUID             %s", cpu_capabilities&CPU_ID?"Yes":"No");
 LOG("\n\tFPU               %s", cpu_capabilities&CPU_FPU?"Yes":"No (Oh shit!!!)");
 LOG("\n\tMMX               %s", cpu_capabilities&CPU_MMX?"Yes":"No");
 LOG("\n\tMMX+              %s", cpu_capabilities&CPU_MMXPLUS?"Yes":"No");
 LOG("\n\tSSE               %s", cpu_capabilities&CPU_SSE?"Yes":"No");
 LOG("\n\tSSE2              %s", cpu_capabilities&CPU_SSE2?"Yes":"No");
 LOG("\n\t3DNow!            %s", cpu_capabilities&CPU_3DNOW?"Yes":"No");
 LOG("\n\tEnhanced 3DNow!   %s", cpu_capabilities&CPU_ENH3DNOW?"Yes":"No");
 LOG("\n\tCMOV              %s", cpu_capabilities&CPU_CMOV?"Yes":"No");
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int init()
{
 FILE *f;

 srand(time(0));

 stack_level=0;

 f=fopen("alliance.log", "wt");//sterge fisierul log - o metoda sigura
 if (f) fclose(f);

 LOG("\nAlliance v%.2f - CataSoft 2001.\n", (double)VER/100);

 LOG("\nInitializing %s...", allegro_id);
 if (allegro_init()<0)
    {
	 sprintf(error_msg, "%s", allegro_error);
     error_flag=1;
     return -1;
    }
 else 
	{
	 LOG("\n\tDate: %d/%02d/%02d (yyyy/mm/dd)", ALLEGRO_DATE/10000, ALLEGRO_DATE/10%100, ALLEGRO_DATE%100);
	 LOG("\n\tdone!");
	}

 LOG("\n\nInitializing Seer scripting engine v%s...", SeeR_VERSION_STR);
 if (init_script()<0)
    {
     error_flag=1;
     return -1;
    }
 else LOG("\n\tdone!");

 LOG("\n\nInitializing HawkNL network library v%d.%d...", NL_MAJOR_VERSION, NL_MINOR_VERSION);
 if (init_net()<0) 
	{
     error_flag=1;
     return -1;
	}
 else LOG("\n\tdone!");
 
 LOG("\n\nInstalling hooks...");
 LOG("\n\tTimer handler...");
 if (install_timer()<0)
    {
     sprintf(error_msg, "failed to install timer handler");
     error_flag=1;

     return -1;
    }
 else LOG("ok");

 LOG("\n\tKeyboard handler...");
 if (install_keyboard()<0)
    {
     sprintf(error_msg, "failed to install keyboard handler");
     error_flag=1;

     return -1;
    }
 else LOG("ok");

 LOG("\n\tMouse handler...");
 if (install_mouse()<0)
    {
     sprintf(error_msg, "mouse not detected - install a mouse driver first");
     error_flag=1;

     return -1;
    }
 else LOG("ok");
 LOG("\n\tdone!");

 LOCK_VARIABLE(fps);
 LOCK_VARIABLE(frame_count);
 LOCK_VARIABLE(net_flow);
 LOCK_VARIABLE(net_flow_count);
 LOCK_VARIABLE(game_count);

 LOCK_FUNCTION(fps_proc);
 LOCK_FUNCTION(game_proc);

 install_int(fps_proc, 250);
 install_int(game_proc, 5);

 LOG("\n\nChecking CPU...");
 display_cpu_info();
 LOG("\n\tdone!");

 LOG("\n\nMemory status...");
 get_mem_info();
 if (total_phisical/1048576<16) allegro_message("Warning!!!\nYou only have %dMb of RAM.\nThis game requires at least 16Mb.\nYou might experience poor game performance because of this!", total_phisical/1048576);
 LOG("\n\tPhisical memory avaiable...%dMb", free_phisical/1048576);
 LOG("\n\tVirtual memory avaiable...%dMb", free_virtual/1048576);
 LOG("\n\tdone!");

 LOG("\n\nSetting video mode...");
 if (init_gfx(&software_gfx_driver)<0) return -1;
 else LOG("\n\tdone!");

 return 0;
}
/*****************************************************************************

    Function: game_shutdown

    Description: deinitializeaza
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void shutdown()
{
 shutdown_net(); 
 shutdown_script();
 shutdown_gfx();
 allegro_exit();
}
/*****************************************************************************

    Function: game_init

    Description: initializeaza jocul
    Parameters: N/A
    Return:  0 - ok
            -1 - eroare

*****************************************************************************/
int init_game(char *name)
{
 long timer;
 char config_file[256];

 memset(unit_prop, 0, sizeof(UNIT_PROP)*MAX_UNIT_TYPES);
 memset(weapon_prop, 0, sizeof(WEAPON_PROP)*MAX_WEAPON_TYPES);
 memset(order_prop, 0, sizeof(ORDER_PROP)*MAX_ORDER_TYPES);
 memset(build_prop, 0, sizeof(BUILD_PROP)*MAX_BUILD_TYPES);
 memset(upgrade_prop, 0, sizeof(UPGRADE_PROP)*MAX_UPGRADE_TYPES);
 memset(&map, 0, sizeof(MAP));

 strcpy(game_dir, name);
 LOG("\n\nLoading game - '%s'", game_dir);

 set_window_title(name);
 set_window_close_button(0);

 strcpy(config_file, get_game_filename("rules.ini"));
 if (open_config_file(config_file)<0)
     {
      sprintf(error_msg, "Error opening %s", config_file);
      error_flag=1;

      return -1;
     }

// readkey();
 START_LOAD_LEVEL(1, 454, 320, 8, makecol(0, 0, 255));

 timer=game_count;
 LOG("\n\tLoading data...");
 if (init_data()<0) return -1;
 else LOG("done (%ldms)", game_count-timer);

 timer=game_count;
 LOG("\n\tReading rules...");
 if (read_rules()<0) return -1;
 else LOG("done (%ldms)", game_count-timer);

 END_LOAD_LEVEL();
// readkey();

 init_gfx_data();

 player_color[0]=makecol(0, 255, 0);
 player_color[1]=makecol(255, 0, 0);
 player_color[2]=makecol(255, 128, 0);
 player_color[3]=makecol(255, 255, 0);
 player_color[4]=makecol(0, 255, 255);
 player_color[5]=makecol(0, 0, 255);
 player_color[6]=makecol(255, 0, 255);

 LOG("\n\tdone!");
 LOG("\n\nEntering the world of '%s'", game_dir);

 return 0;
}
/*****************************************************************************

    Function: game_shutdown

    Description: deinitializeaza
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void shutdown_game()
{
 shutdown_data();

 //close_config_file();
}
/*****************************************************************************

    Function: data_init

    Description: incarca datele
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void load_callback(DATAFILE *d)
{
 static int i=0;

 d=d;
 
 if ((i++)%5==0) UPDATE_LOAD_LEVEL(1);
}

int init_data()
{
 char name[256];

 strcpy(name, get_game_filename("data\\gfx.dat"));
 gfx=load_datafile_callback(name, load_callback);
 if (gfx==NULL)
    {
     sprintf(error_msg, "couldn't load the datafile (%s)", name);
     error_flag=1;

     return -1;
    }

 return 0;
}
/*****************************************************************************

    Function: data_shutdown

    Description: descarca datele
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void shutdown_data()
{
 if (gfx) unload_datafile(gfx);
}
/*****************************************************************************

    Function: process_everything

    Description: proceseaza totul
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void process_everything()
{
 if (!(game_flags&GAME_FLAG_PAUSED))
    {
     process_map();
 //    process_buildings();
     process_players();
     process_particles();
     process_net(NULL);
    }

 process_panel();
}
/*****************************************************************************

    Function: draw_everything

    Description: deseneaza totul
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void draw_everything()
{
 acquire_bitmap(background);
 acquire_bitmap(buffer);
 acquire_bitmap(camera);
 
 draw_map();
 //draw_buildings();
 draw_players();
 draw_particles();
 draw_panel();
 
 release_bitmap(camera);
 release_bitmap(buffer);
 release_bitmap(background);
}
/*****************************************************************************

    Function: main

    Description: this must be a joke
    Parameters: pointer to UNIVERSE.
    Return: EVERYTHING

*****************************************************************************/
//proc                  x       y       w       h       fg      bg  flags   d1      d2      dp      dp2     dp3
CS_DIALOG main_dialog[]={
  {cs_box_proc,         220,    140,    200,    140},
  {cs_text_proc,        240,    160,    0,      0,      255,    0,  0,      0,      0,      "Welcome to Alliance!"},
  {cs_button_proc,      280,    230,    0,      0,      0,      0,  0,      0,      0,      "Ok", "Click here to start..."},
  {NULL,                0,      0,      0,      0}};

void do_main_dialog()
{
 CS_DIALOG_PLAYER *player;
 int mx, my;

 player=init_cs_dialog(main_dialog);
 while (player->ret!=D_CLOSE)
    {
     process_cs_dialog(player);
     draw_cs_dialog(player);

     my=mouse_pos;
     mx=my>>16;
     my=my-(mx<<16);

     process_anim(cursor0);
     draw_anim_centre(buffer, cursor0, mx, my);
     add_dirty_centre(mx-1, my, cursor0->w, cursor0->h, 2);

     flip();
    }
 shutdown_cs_dialog(player);
}
/*****************************************************************************

    Function: main

    Description: this must be a joke
    Parameters: pointer to UNIVERSE.
    Return: EVERYTHING

*****************************************************************************/
int main(int argc, char *argv[])
{
 long timer;

 if (init()<0) fatal("%s", error_msg);

 if (init_game("Alliance") < 0) fatal("%s", error_msg);
 if (init_panel()<0) fatal("%s", error_msg);

 init_relations();
 if (load_map("start.map")<0) fatal("%s", error_msg);

// if (alert(NULL, "Create game??", NULL, "yes", "no", 0, 0)==1) create_game();
// else join_game();

 do_main_dialog();

 timer=game_count;
 while (!key[KEY_ESC])
    {
     while (game_count-timer>UPDATE_TIME)
        {
         timer+=UPDATE_TIME;
         process_everything();
	    }

     draw_everything();
     flip();
    }

 unload_map();

 shutdown_panel();
 shutdown_game();

 shutdown();

 return 0;
}
END_OF_MAIN();