/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include "nvaderz.h"

/** note: all speed variables changed
  * from int to float
  */

/* variables to store the game's file paths */
char gamePath[256];
char gameDirectory[256];
char resourceDirectory[256];

/* settings variables */
int screen_mode;
int screen_width;
int screen_height;
int screen_baseline;
int screen_topline;

/* game area boundaries */
int left_boundary;
int right_boundary;

float player_x_speed;
int player_height;
int player_width;
int player_space_top;
int player_topline;
int player_bounds_offsetx1;
int player_bounds_offsetx2;
int player_bounds_offsety1;
int player_bounds_offsety2;

int invader_height;
int invader_width;
int invader_space_horizontal;
int invader_space_vertical;
int invader_columns;
int invader_rows;
int invader_number;

float horde_x_speed;
int horde_start_x;
int horde_start_y;

unsigned double_invader_start_level;
unsigned triple_invader_start_level;
unsigned double_invader_odds;
unsigned triple_invader_odds;
unsigned double_invader_odds_change;
unsigned triple_invader_odds_change;

float laser_y_speed;
int laser_height;
int laser_width;

float bomb_y_speed;
int bomb_height;
int bomb_width;
int dropFactor;
int dropOdds;

/* declare hud variables */
int score_digit_width;
int score_digit_height;
int score_digit_hspace;
int score_left_limit;
int score_right_limit;
int score_topline;
int num_score_digits;

int lives_unit_width;
int lives_unit_height;
int lives_unit_hspace;
int lives_left_limit;
int lives_right_limit;
int lives_topline;
int num_lives_units;
int lives_ship1_x;
int lives_ship2_x;
int lives_ship_y;
int lives_ship_width;
int lives_ship_height;

/* timer variables */
volatile long clockTicks;
int clockChangedFlag;
int gameSpeedInMilliseconds;

/* global variables */
int numberOfPlayers, gameover, lives[2], gamePause, firing[2][3];
unsigned score[2], totalinvaders, level;
unsigned extraLifePoints;
int splashFlag;

BITMAP *screen_buffer;

BITMAP *player_bmp[2];
BITMAP *laser_bmp;
BITMAP *bomb_bmp;
BITMAP *capsule_bmp[16];
BITMAP *missile_bmp;
BITMAP *rotatedMissile_bmp;
BITMAP *impact_bmp;

/* add support for multiple invader bitmaps */
BITMAP *invaders_bmp[3][5];

/* SPRITE theplayer; */
SPRITE theplayer[2];
SPRITE thehorde;
SPRITE thelaser[2][3];

/* need to find a way to use malloc() from setup() */
SPRITE invaders[INV_ROWS][INV_COLUMNS];

/* SPRITE *player; */
SPRITE *player[2];
SPRITE *horde;
SPRITE *laser[2][3];

/* need to find a way to use malloc() from setup() */
SPRITE bombs[INV_COLUMNS];
int bombarray[INV_COLUMNS];

SPRITE theshield;
SPRITE *shield;
int shieldArray[3][64];
BITMAP *shield_bmp;
int shieldTicks;
int shield_x;
int shield_y;
unsigned shield_width;
unsigned shield_height;
unsigned shieldSegmentWidth;
unsigned shieldSegmentHeight;
unsigned shieldSpace;

SPRITE capsules[6];
SPRITE missile;
SPRITE impact;

/* sound */
SAMPLE *fireSample;
SAMPLE *playerKilledSample;
SAMPLE *invaderKilledSample;
SAMPLE *shieldSample;
SAMPLE *backgroundSample;
SAMPLE *newGameSample;
SAMPLE *gameOverSample;
SAMPLE *navigateMenuSample;
SAMPLE *selectSample;
SAMPLE *navigateMainMenuSample;
SAMPLE *selectMainMenuSample;
SAMPLE *regenerationSample;
SAMPLE *extraLifeBonusSample;
SAMPLE *missileBlastSample;
SAMPLE *missileAlertSample;
int soundon;
int pan, pitch, volume;
