/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include "nvaderz.h"
#include "bonus.h"
#include "joystick.h"

static int firePressed_1;
static int downPressed;
static int altPressed;
static int sPressed;
static int pPressed;

void getinput(void)
{
	int num;

	/* reset all joystick variables before polling joystick */
	joyUp_p1 = 0;
	joyRight_p1 = 0;
	joyDown_p1 = 0;
	joyLeft_p1 = 0;
	joyFire_p1 = 0;
	joyReset_p1 = 0;

	joyUp_p2 = 0;
	joyRight_p2 = 0;
	joyDown_p2 = 0;
	joyLeft_p2 = 0;
	joyFire_p2 = 0;
	joyReset_p2 = 0;

	/* call to updatde joystick: if it fails, set all joystick
		variables to false */
	if(updateJoystickInfo()){
		joyUp_p1 = 0;
		joyRight_p1 = 0;
		joyDown_p1 = 0;
		joyLeft_p1 = 0;
		joyFire_p1 = 0;
		joyReset_p1 = 0;

		joyUp_p2 = 0;
		joyRight_p2 = 0;
		joyDown_p2 = 0;
		joyLeft_p2 = 0;
		joyFire_p2 = 0;
		joyReset_p2 = 0;
	}

	if(joyReset_p1 || key[KEY_ESC])
	{
		/* stop the background music */
		stop_sample(backgroundSample);

		/* gameover = 1; */
		if(gameover == 0)
		{
			endgame(0);
		}
	}

	/* player 1 controls (player 0, programmatically) */
	if((joyLeft_p1 || key[KEY_LEFT]) && clockChangedFlag)
		moveplayer(0, 3);

	if((joyRight_p1 || key[KEY_RIGHT]) && clockChangedFlag)
		moveplayer(0, 1);

	if(joyFire_p1 || key[KEY_SPACE])
	{
		if(!firePressed_1)
		{
			firePressed_1=1;
			fire(0); /* player 1 is 0 programmatically */
		}

		/* if guided missiles are active, steer the missile
		 * whenever fire is detected
		 */
		if(getGuidedStatus(0)) /* status of player 1 (0) */
		  setGuidedSteering(0, 1); /* player 1 (0), steering on (1) */
	}
	else
	{
		/* if guided missiles are active, turn steering off
		 * if no space bar is detected
		 */
		if(getGuidedStatus(0)) /* status of player 1 (0) */
		  setGuidedSteering(0, 0); /* player 1 (0), steering off (0) */

		firePressed_1 = 0;
	}

	if(joyDown_p1 || key[KEY_DOWN])
	{
		/* turn on player shield if one way shield not on */
		/* but only if player 1 (0) is alive */
		if((player[0]->alive > 0) && !downPressed && !(getOneWayStatus()))
		{
			if(soundon)
				play_sample(shieldSample, volume, pan,
					pitch, FALSE);

			shield->alive *= -1;
		}

		downPressed = 1;
	}
	else
		downPressed = 0;

	/* player 2 controls (player 1, programmatically) */
	if(joyLeft_p2 || key[KEY_A] && clockChangedFlag)
		moveplayer(1, 3);

	if(joyRight_p2 || key[KEY_D] && clockChangedFlag)
		moveplayer(1, 1);

	if(joyFire_p2 || key[KEY_ALT])
	{
		if(!altPressed)
		{
			altPressed=1;
			fire(1); /* player 2 is 1 programmatically */
		}

		/* if guided missiles are active, steer the missile
		 * whenever the space bar is detected
		 */
		if(getGuidedStatus(1)) /* status of player 2 (1) */
		  setGuidedSteering(1, 1); /* player 2 (1) turn on (1) */
	}
	else
	{
		/* if guided missiles are active, turn steering off
		 * if no space bar is detected
		 */
		if(getGuidedStatus(1)) /* status of player 2 (1) */
		  setGuidedSteering(1, 0); /* player 2 (1) turn off (0) */

		altPressed = 0;
	}

	if(joyDown_p2 || key[KEY_S])
	{
		/* turn on player shield if one way shield not on */
		/* but only if player 1 (0) is alive */
		if((player[1]->alive > 0) && !sPressed && !(getOneWayStatus()))
		{
			if(soundon)
				play_sample(shieldSample, volume, pan,
					pitch, FALSE);

			shield->alive *= -1;
		}

		sPressed = 1;
	}
	else
		sPressed = 0;

	/* game cheat codes */
	if(key[KEY_M])
	{
		/* activate the enemy missile */
		activateMissile();
	}

	if(key[KEY_G])
	{
		int num;

		/* activate player guided missile bonus */
		/* for both players */
		for(num = 0; num < numberOfPlayers; num++)
			activateGuided(num);
	}
	
	if(key[KEY_O])
	{
		/* activate player one-way shield */
		activateOneWay();
	}

	if(key[KEY_T])
	{
		/* activate player three-shot fire bonus
		** for both players
		*/
		for(num = 0; num < numberOfPlayers; num++)
			activateThreeShot(num);
	}

	if(key[KEY_P]) {
		if(!pPressed) {
			setPause(!getPause());
		}
		pPressed = 1;
	}
	else {
		pPressed = 0;
	}

}

void getPlayerName(char *playerName, int playerNum)
{
	char name[26], displayString[30], playerStr[2], tempStr[2];
	char greeting[50];
	int exitDialog, i, j;
	int dialogx1, dialogx2, dialogy1, dialogy2;
	int nameFieldx1, nameFieldx2, nameFieldy1, nameFieldy2;
	int keyPadx, keyPady, keyWidth, keyHeight;
	int upPressed, downPressed, leftPressed, rightPressed;
	int escPressed, spacePressed;
	int columnPos, rowPos;
	int buttonColor, textColor, fillColor;
	char keys[7][6] =
		{
			{'A', 'B', 'C', 'D', 'E', 'F'},
			{'G', 'H', 'I', 'J', 'K', 'L'},
			{'M', 'N', 'O', 'P', 'Q', 'R'},
			{'S', 'T', 'U', 'V', 'W', 'X'},
			{'Y', 'Z', '0', '1', '2', '3'},
			{'4', '5', '6', '7', '8', '9'},
			{'_', '<', ' ', ' ', ' ', ' '}
		};

	/* convert playerNum to a string 
	** Add 1 to playerNum before displaying, since the program
	** uses player numbers 0 and 1, and people use 1 and 2.
	*/
	playerStr[0] = (char)((playerNum + 1) + 48);
	playerStr[1] = '\0';

	strcpy(greeting, "Player ");
	strcat(greeting, playerStr);
	strcat(greeting, ", enter your name:");

	dialogx1 = 120;
	dialogx2 = 520;
	dialogy1 = 80;
	dialogy2 = 450;

	nameFieldx1 = 230;
	nameFieldy1 = 120;
	nameFieldx2 = 410;
	nameFieldy2 = 150;

	keyPadx = 230;
	keyPady = 175;
	keyWidth = 30;
	keyHeight = 30;

	tempStr[0] = '\0';
	tempStr[1] = '\0';

	exitDialog = 0;
	spacePressed=upPressed=downPressed=leftPressed=rightPressed=0;
	escPressed = 0;
	columnPos=rowPos=0;

	strcpy(name, "");

	/* if game is still registering pertinent key input
	 ** from a prior screen, set the applicable -pressed
	 ** variable
	 */

	if(key[KEY_ESC])
		escPressed = 1;
	if(key[KEY_RIGHT] || key[KEY_D])
		rightPressed = 1;
	if(key[KEY_LEFT] || key[KEY_A])
		leftPressed = 1;
	if(key[KEY_UP] || key[KEY_A])
		upPressed = 1;
	if(key[KEY_DOWN] || key[KEY_S])
		downPressed = 1;
	if(key[KEY_SPACE] || key[KEY_ALT])
		spacePressed = 1;
	while(!exitDialog)
	{
		/* draw the dialog */

		/* first, draw the background */
		rectfill(screen_buffer, dialogx1, dialogy1,
			dialogx2, dialogy2, BLACK);

		rect(screen_buffer, dialogx1 + 1, dialogy1 + 1,
			dialogx2 - 1, dialogy2 - 1, GREEN);

		/* next draw the greeting/instructions */
		textout_centre_ex(screen_buffer, font, greeting,
			dialogx1 + ((dialogx2 - dialogx1) / 2),
			nameFieldy1 - 20,
			RED, -1);
		

		/* next draw the name field box */
		rectfill(screen_buffer, nameFieldx1, nameFieldy1,
			nameFieldx2, nameFieldy2, BLACK);
		rect(screen_buffer, nameFieldx1, nameFieldy1,
			nameFieldx2, nameFieldy2, GREEN);

		strcpy(displayString, name);
		strcat(displayString, "_");
		textout_ex(screen_buffer, font, displayString,
				nameFieldx1 + 5,
				nameFieldy1 + ((nameFieldy2 -
					nameFieldy1) / 2),
				GREEN, -1);

		/* next, draw the keypad */
		for(i = 0; i < 7; i++)
			for(j = 0; j < 6; j++)
			{
				if(j == 2 && i == 6)
				{
					if(columnPos >= 2 &&
						rowPos == 6)
					{
						buttonColor = GREEN;
						fillColor = LTGREEN;
						textColor = BLACK;
						
						rect(screen_buffer,
							keyPadx + (j *
							  keyWidth
							  ),
							keyPady + (i *
							  keyHeight
							  ),
							keyPadx + (j *
							  keyWidth)+
							  keyWidth*4,
							keyPady + (i *
							  keyHeight)
							  + keyHeight,
							buttonColor
							);

						rectfill(screen_buffer,
							keyPadx + (j *
							  keyWidth
							  ),
							keyPady + (i *
							  keyHeight
							  ),
							keyPadx + (j *
							  keyWidth)+
							  keyWidth*4,
							keyPady + (i *
							  keyHeight)
							  + keyHeight,
							fillColor
							);

						textout_ex(
							screen_buffer,
							font,
							"OK",
							(keyPadx + (j *
							  keyWidth) +
							  keyWidth * 2)
							  - 10,
							keyPady + (i *
							  keyHeight) +
							  keyHeight/2,
							textColor, -1
							);

						j = 6;
						i = 7;
						break;
					}
					else
					{
						buttonColor = GREEN;
						textColor = GREEN;
						
						rect(screen_buffer,
							keyPadx + (j *
							  keyWidth
							  ),
							keyPady + (i *
							  keyHeight
							  ),
							keyPadx + (j *
							  keyWidth)+
							  keyWidth*4,
							keyPady + (i *
							  keyHeight)
							  + keyHeight,
							buttonColor
							);

						textout_ex(
							screen_buffer,
							font,
							"OK",
							(keyPadx + (j *
							  keyWidth) +
							  keyWidth * 2)
							  - 10,
							keyPady + (i *
							  keyHeight) +
							  keyHeight/2,
							textColor, -1
							);

						j = 6;
						i = 7;
						break;
					}
				}
				else if(columnPos == j && rowPos == i)
				{
					buttonColor = GREEN;
					fillColor = LTGREEN;
					textColor = BLACK;

					rect(screen_buffer,
						keyPadx + (j * keyWidth),
						keyPady + (i * keyHeight),
						keyPadx + (j * keyWidth)
							+ keyWidth,
						keyPady + (i * keyHeight)
							+ keyHeight,
						buttonColor);

					rectfill(screen_buffer,
						keyPadx + (j * keyWidth),
						keyPady + (i * keyHeight),
						keyPadx + (j * keyWidth)
							+ keyWidth,
						keyPady + (i * keyHeight)
							+ keyHeight,
						fillColor);

					tempStr[0] = keys[i][j];
					textout_ex(screen_buffer, font,
						tempStr,
						keyPadx + (j * keyWidth) + 15,
						keyPady + (i * keyHeight) + 15,
						textColor, -1
						);
				}
				else
				{
					buttonColor = GREEN;
					textColor = GREEN;
				
					rect(screen_buffer,
						keyPadx + (j * keyWidth),
						keyPady + (i * keyHeight),
						keyPadx + (j * keyWidth)
							+ keyWidth,
						keyPady + (i * keyHeight)
							+ keyHeight,
						buttonColor);
				

					tempStr[0] = keys[i][j];
					textout_ex(screen_buffer, font,
						tempStr,
						keyPadx + (j * keyWidth) + 15,
						keyPady + (i * keyHeight) + 15,
						textColor, -1
						);
				}
			}

		/* draw the some info text */
		textout_centre_ex(screen_buffer, font,
			"<FIRE> to press keys : [ESC] to cancel",
			dialogx1 + (dialogx2 - dialogx1) / 2,
			dialogy2 - 15,
			GREEN, -1);

		/* swap the buffered image to the main screen bitmap */
		blit(screen_buffer, screen, 0, 0, 0, 0,
			screen_buffer->w, screen_buffer->h);

		/* clear joystick buffer */
		if(joysticksAllowed) {
			if(playerNum==0) {
				while(1){
					updateJoystickInfo();
					if(!joyLeft_p1 && !joyRight_p1 && !joyUp_p1 && !joyDown_p1 &&
						!joyFire_p1 && !joyReset_p1)
						break;
				}
			}

			if(playerNum==1) {
				while(1){
					updateJoystickInfo();
					if(!joyLeft_p2 && !joyRight_p2 && !joyUp_p2 && !joyDown_p2 &&
						!joyFire_p2 && !joyReset_p2)
						break;
				}
			}
		}

		/* check for keypresses */
		while(1)
		{
			updateJoystickInfo();

			if(( ((playerNum == 0) && (key[KEY_RIGHT] || joyRight_p1)) ||
				((playerNum == 1) && (key[KEY_D] || joyRight_p2))) && !rightPressed)
			{
				/** if in "OK" key,
				 ** ignore internal columns
				 */
				if(rowPos == 6 && columnPos > 1)
					columnPos = 5;
				columnPos++;
				if(columnPos > 5)
					columnPos = 0;
				rightPressed = 1;

				/* play sound */
				if(soundon)
				  play_sample(navigateMenuSample,
				    volume, pan, pitch, FALSE);

				break;
			}
			if(( (playerNum == 0 && (joyLeft_p1 || key[KEY_LEFT])) ||
				(playerNum == 1 && (joyLeft_p2 || key[KEY_A]))) && !leftPressed)
			{
				/** if in "OK" key,
				 ** ignore internal columns
				 */
				if(rowPos == 6 && columnPos > 1)
					columnPos = 2;
				columnPos--;
				if(columnPos < 0)
					columnPos = 5;
				leftPressed = 1;

				/* play sound */
				if(soundon)
				  play_sample(navigateMenuSample,
				    volume, pan, pitch, FALSE);

				break;
			}
			if(( (playerNum ==0 && (joyUp_p1 || key[KEY_UP])) ||
				(playerNum == 1 && (joyUp_p2 || key[KEY_W]))) && !upPressed)
			{
				rowPos--;
				if(rowPos < 0)
					rowPos = 6;
				upPressed = 1;

				/* play sound */
				if(soundon)
				  play_sample(navigateMenuSample,
				    volume, pan, pitch, FALSE);

				break;
			}
			if(( (playerNum == 0 && (joyDown_p1 || key[KEY_DOWN])) ||
				(playerNum == 1 && (joyDown_p2 || key[KEY_S]))) && !downPressed)
			{
				rowPos++;
				if(rowPos > 6)
					rowPos = 0;
				downPressed = 1;

				/* play sound */
				if(soundon)
				  play_sample(navigateMenuSample,
				    volume, pan, pitch, FALSE);

				break;
			}
			if(( (playerNum == 0 && (joyFire_p1 || key[KEY_SPACE])) ||
				(playerNum == 1 && (joyFire_p2 || key[KEY_ALT])) ) && !spacePressed)
			{
				int nameLength;
				char currChar = keys[rowPos][columnPos];
				spacePressed = 1;
				nameLength = strlen(name);

				/* play sound */
				if(soundon)
				  play_sample(selectSample,
				    volume, pan, pitch, FALSE);


				if(currChar == '_')
				{
					if(nameLength < 25)
					{
						name[nameLength]= ' ';
						name[nameLength + 1]
							= '\0';
					}
					break;
				}
				else if(currChar == '<')
				{
					if(nameLength > 0)
					{
						name[nameLength - 1]
							= '\0';
					}
					break;
				}
				else if(currChar == ' ')
				{
					/* user pressed 'OK' */
					exitDialog = 1;
					break;
				}
				else if(nameLength < 25)
				{
					/* add character to name */
					name[nameLength] = currChar;
					name[nameLength + 1] = '\0';
					break;
				}
			};
			if(!key[KEY_UP] && !key[KEY_DOWN] &&
				!key[KEY_LEFT] && !key[KEY_RIGHT] &&
				!key[KEY_SPACE] && !key[KEY_ESC] &&
				!key[KEY_A] && !key[KEY_W] &&
				!key[KEY_D] && !key[KEY_S] && !key[KEY_ALT])
			{
				upPressed = 0;
				downPressed = 0;
				leftPressed = 0;
				rightPressed = 0;
				spacePressed = 0;
				escPressed = 0;
				
			}
			if(key[KEY_ESC] && !escPressed)
			{
				exitDialog = 1;
				strcpy(name, "[]");
				break;
			}
		}
	}
	
	if(strlen(name))
		strcpy(playerName, name);
	else
		strcpy(playerName, "[]");

}
