/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

/* hud.c */
#include <string.h>
#include "bonus.h"

#include "nvaderz.h"
#ifndef __HUD_H__
#include "hud.h"
#endif

/* define variables */
BITMAP *hudInterface_bmp;

BITMAP *hudInterfaceTop_bmp;
BITMAP *hudInterfaceBottom_bmp;
BITMAP *hudInterfaceLeft_bmp;
BITMAP *hudInterfaceRight_bmp;




BITMAP *hudZero_bmp;
BITMAP *hudOne_bmp;
BITMAP *hudTwo_bmp;
BITMAP *hudThree_bmp;
BITMAP *hudFour_bmp;
BITMAP *hudFive_bmp;
BITMAP *hudSix_bmp;
BITMAP *hudSeven_bmp;
BITMAP *hudEight_bmp;
BITMAP *hudNine_bmp;
BITMAP *digits_bmp[10];
BITMAP *livesDim_bmp;
BITMAP *lives_bmp;
BITMAP *livesShipDim_bmp;
BITMAP *livesShip_bmp;

/* bonus indicators */
BITMAP *repeat_bmp;
BITMAP *repeatDim_bmp;
BITMAP *guided_bmp;
BITMAP *guidedDim_bmp;
BITMAP *oneWay_bmp;
BITMAP *oneWayDim_bmp;

/* the array of each score digit for player 1 */
int scoreDigitsArray[2][NUM_SCORE_DIGITS];

char hudBitmapPath[256];
int setHudBitmapPath(char *filename);
int extractScoreDigits(int playerNumber);

int drawInterface(void)
{
	/* removed this snippet to add individual sections of the interface.
    masked_blit(hudInterface_bmp, screen_buffer, 0, 0, 0, 0, screen_width,
	    screen_height);
	*/

	/* use blit() for the sections, since no masking is needed */
	blit(hudInterfaceTop_bmp, screen_buffer, 0, 0, 14, 0, 612, 20);
	blit(hudInterfaceBottom_bmp, screen_buffer, 0, 0, 0, 383, 640, 97);
	blit(hudInterfaceLeft_bmp, screen_buffer, 0, 0, 0,0, 14, 383);
	blit(hudInterfaceRight_bmp, screen_buffer, 0, 0, 626, 0, 14, 383);

    return 0;
}

int drawScore(void)
{
    int num;

    BITMAP *tmp_bmp;

    /** score images are placed starting from a left and right limit,
      * and moving to the center
      */
    int offset, y, leftx, rightx, i;
    int width, height, numdigits;
    width = score_digit_width;
    height = score_digit_height;
    numdigits = num_score_digits;
    offset = score_digit_hspace;
    y = score_topline;
    leftx = score_left_limit;
    rightx = score_right_limit;

    /* extract the individual score digits */
    for(num = 0; num < 2; num++)
        extractScoreDigits(num);

    /* draw left side digits */
    for(i = 0; i < numdigits; ++i)
    {
        tmp_bmp = digits_bmp[scoreDigitsArray[0][i]];
        masked_stretch_blit(tmp_bmp, screen_buffer, 0, 0, tmp_bmp->w,
	    tmp_bmp->h, leftx + ((width + offset) * i), y, width,
            height);
    }

    /* draw right side digits */
    for(i = 1; i < numdigits + 1; ++i)
    {
        tmp_bmp = digits_bmp[scoreDigitsArray[1][numdigits - i]];
        masked_stretch_blit(tmp_bmp, screen_buffer, 0, 0, tmp_bmp->w,
            tmp_bmp->h, rightx - ((width + offset) * i), y, width,
            height);
    }

    return 0;
}

int drawIndicators(void)
{
    int repX, repY, repW, repH;
    int repX2;
    int shieldX, shieldY, shieldX2, shieldW, shieldH;
    int guideX, guideY, guideX2, guideW, guideH;

    repX = 87;
    repY = 392;
    repW = 40;
    repH = 40;
    repX2 = 513;

    shieldX = 168;
    shieldY = 392;
    shieldW = 40;
    shieldH = 40;
    shieldX2 = 432;

    guideX = 245;
    guideY = 392;
    guideW = 40;
    guideH = 40;
    guideX2 = 351;

    if(getThreeShotStatus(0))
      masked_stretch_blit(repeat_bmp, screen_buffer, 0, 0, repW,
	repH,repX, repY, repW, repH);
    else
      masked_stretch_blit(repeatDim_bmp, screen_buffer, 0, 0, repW,
	repH,repX, repY, repW, repH);

    if(getThreeShotStatus(1))
      masked_stretch_blit(repeat_bmp, screen_buffer, 0, 0, repW,
	repH, repX2, repY, repW, repH);
    else
      masked_stretch_blit(repeatDim_bmp, screen_buffer, 0, 0, repW,
	repH, repX2, repY, repW, repH);

    /* Turn on one-way shield indicator only if player is alive.
    **
    ** In this section we only have to worry about this for the
    ** one-way shield bonus because it is globally set. The other
    ** bonuses are managed individually.
    */
    if(getOneWayStatus() && player[0]->alive)
    {
      masked_stretch_blit(oneWay_bmp, screen_buffer, 0, 0, shieldW,
        shieldH, shieldX, shieldY, shieldW, shieldH);
    }
    else
    {
      masked_stretch_blit(oneWayDim_bmp, screen_buffer, 0, 0, shieldW,
        shieldH, shieldX, shieldY, shieldW, shieldH);
    }
    if(getOneWayStatus() && player[1]->alive) {
    masked_stretch_blit(oneWay_bmp, screen_buffer, 0, 0, shieldW,
        shieldH, shieldX2, shieldY, shieldW, shieldH);
    }
    else {
    masked_stretch_blit(oneWayDim_bmp, screen_buffer, 0, 0, shieldW,
        shieldH, shieldX2, shieldY, shieldW, shieldH);
    }

    if(getGuidedStatus(0))
    {
      masked_stretch_blit(guided_bmp, screen_buffer, 0, 0, guideW,
        guideH, guideX, guideY, guideW, guideH);
    }
    else
    {
      masked_stretch_blit(guidedDim_bmp, screen_buffer, 0, 0, guideW,
        guideH, guideX, guideY, guideW, guideH);
    }

    if(getGuidedStatus(1)) {
      masked_stretch_blit(guided_bmp, screen_buffer, 0, 0, guideW,
        guideH, guideX2, guideY, guideW, guideH);
    }
    else {
      masked_stretch_blit(guidedDim_bmp, screen_buffer, 0, 0, guideW,
          guideH, guideX2, guideY, guideW, guideH);
    }
    return 0;
}

int drawLives(void)
{
    BITMAP *tmp_bmp;
    int offset, y, leftx, rightx, i;
    int width, height, numUnits;
    width = lives_unit_width;
    height = lives_unit_height;
    numUnits = num_lives_units;
    offset = lives_unit_hspace;
    y = lives_topline;
    leftx = lives_left_limit;
    rightx = lives_right_limit;

    /* draw left side lives indicators */
    for(i = 0; i < numUnits; ++i)
    {
        if(lives[0] > numUnits - i - 1)
            tmp_bmp = lives_bmp;
        else
            tmp_bmp = livesDim_bmp;
        masked_stretch_blit(tmp_bmp, screen_buffer, 0, 0, tmp_bmp->w,
	    tmp_bmp->h, leftx + ((width + offset) * i), y, width,
            height);
    }

    /* draw right side lives indicators */
    for(i = 1; i < numUnits + 1; ++i)
    {
	if(lives[1] >= numUnits - i + 1)
		tmp_bmp = lives_bmp;
	else
		tmp_bmp = livesDim_bmp;
        masked_stretch_blit(tmp_bmp, screen_buffer, 0, 0, tmp_bmp->w,
            tmp_bmp->h, rightx - ((width + offset) * i), y, width,
            height);
    }

    /* draw left and right lives ship indicator */
    leftx = lives_ship1_x;
    rightx = lives_ship2_x;
    y = lives_ship_y;
    width = lives_ship_width;
    height = lives_ship_height;

    if(lives[0] >= 0)
        tmp_bmp = livesShip_bmp;
    else
        tmp_bmp = livesShipDim_bmp;
    masked_stretch_blit(tmp_bmp, screen_buffer, 0, 0, tmp_bmp->w,
        tmp_bmp->h, leftx, y, width, height);

    if(lives[1] >= 0)
        tmp_bmp = livesShip_bmp;
    else
        tmp_bmp = livesShipDim_bmp;
    masked_stretch_blit(tmp_bmp, screen_buffer, 0, 0, tmp_bmp->h,
        tmp_bmp->h, rightx, y, width, height);

    return 0;
}

int setUpHud(void)
{
	/* create a load test flag */
	int loadFlag = 0;

    setHudBitmapPath("InterfaceTop.bmp");
    if(hudInterfaceTop_bmp == NULL) 
        hudInterfaceTop_bmp = load_bitmap(hudBitmapPath, NULL);

	/* DEBUG: test if image loaded */
	if(hudInterfaceTop_bmp == NULL) {
		printf("InterfaceTop_bmp did not load.\n");
		loadFlag = 1;
	}

    setHudBitmapPath("InterfaceBottom.bmp");
    if(hudInterfaceBottom_bmp == NULL)
        hudInterfaceBottom_bmp = load_bitmap(hudBitmapPath, NULL);

	/* DEBUG: test if image loaded */
	if(hudInterfaceBottom_bmp == NULL) {
		printf("InterfaceBottom_bmp did not load.\n");
		loadFlag = 1;
	}

    setHudBitmapPath("InterfaceLeft.bmp");
    if(hudInterfaceLeft_bmp == NULL)
        hudInterfaceLeft_bmp = load_bitmap(hudBitmapPath, NULL);

	/* DEBUG: test if image loaded */
	if(hudInterfaceLeft_bmp == NULL) {
		printf("InterfaceLeft.bmp did not load.\n");
		loadFlag = 1;
	}

    setHudBitmapPath("InterfaceRight.bmp");
    if(hudInterfaceRight_bmp == NULL)
        hudInterfaceRight_bmp = load_bitmap(hudBitmapPath, NULL);

	/* DEBUG: test if image loaded */
	if(hudInterfaceRight_bmp == NULL) {
		printf("InterfaceRight.bmp did not load.\n");
		loadFlag = 1;
	}

    setHudBitmapPath("ZeroIcon.bmp");
    if(hudZero_bmp == NULL)
        hudZero_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[0] = hudZero_bmp;

    setHudBitmapPath("OneIcon.bmp");
    if(hudOne_bmp == NULL)
        hudOne_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[1] = hudOne_bmp;

    setHudBitmapPath("TwoIcon.bmp");
    if(hudTwo_bmp == NULL)
        hudTwo_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[2] = hudTwo_bmp;

    setHudBitmapPath("ThreeIcon.bmp");
    if(hudThree_bmp == NULL)
        hudThree_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[3] = hudThree_bmp;

    setHudBitmapPath("FourIcon.bmp");
    if(hudFour_bmp == NULL)
        hudFour_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[4] = hudFour_bmp;

    setHudBitmapPath("FiveIcon.bmp");
    if(hudFive_bmp == NULL)
        hudFive_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[5] = hudFive_bmp;

    setHudBitmapPath("SixIcon.bmp");
    if(hudSix_bmp == NULL)
        hudSix_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[6] = hudSix_bmp;

    setHudBitmapPath("SevenIcon.bmp");
    if(hudSeven_bmp == NULL)
        hudSeven_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[7] = hudSeven_bmp;

    setHudBitmapPath("EightIcon.bmp");
    if(hudEight_bmp == NULL)
        hudEight_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[8] = hudEight_bmp;

    setHudBitmapPath("NineIcon.bmp");
    if(hudNine_bmp == NULL)
        hudNine_bmp = load_bitmap(hudBitmapPath, NULL);
    digits_bmp[9] = hudNine_bmp;

    setHudBitmapPath("LivesIcon.bmp");
    if(lives_bmp == NULL)
        lives_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("LivesDim.bmp");
    if(livesDim_bmp == NULL)
        livesDim_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("LivesShipIcon.bmp");
    if(livesShip_bmp == NULL)
        livesShip_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("LivesShipDim.bmp");
    if(livesShipDim_bmp == NULL)
        livesShipDim_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("RepeatIcon.bmp");
    if(repeat_bmp == NULL)
        repeat_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("RepeatDim.bmp");
    if(repeatDim_bmp == NULL)
        repeatDim_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("GuidedDim.bmp");
    if(guidedDim_bmp == NULL)
        guidedDim_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("GuidedIcon.bmp");
    if(guided_bmp == NULL)
        guided_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("ShieldDim.bmp");
    if(oneWayDim_bmp == NULL)
        oneWayDim_bmp = load_bitmap(hudBitmapPath, NULL);

    setHudBitmapPath("ShieldIcon.bmp");
    if(oneWay_bmp == NULL)
        oneWay_bmp = load_bitmap(hudBitmapPath, NULL);

	if(loadFlag) {
		printf("ERROR: Necessary images did not load. Qutting. \n");
		exit(1);
	}
	
    return 0;
}

int setHudBitmapPath(char *filename)
{
    strcpy(hudBitmapPath, resourceDirectory);
    strcat(hudBitmapPath, "Hud/");
    strcat(hudBitmapPath, filename);

    return 0;
}

/* break the score down to individual digits,
 * and store in scoreDigitsArray_1 (and soon, scoreDigitsArray_2)
 */
int extractScoreDigits(int playerNumber)
{
  int tmp, power, nines, i, modScore, num;
  
  /** if score is greater than the number of digits to be displayed,
    * subtract 9s in each place until the score is within range.
    * This is basically a wrap-around functionality without having
    * to reset the integer value of the actual score.
    * Example: to display a 6-digit score, 1247050 - 999999 = 247051.
    */
  num = playerNumber;
  nines = 0;
  modScore = score[num];

  for(i = 0; i < num_score_digits; ++i)
  {
    nines = (nines * 10) + 9;
  }

  while( modScore > nines)
    modScore -= nines;

  
  /** find the max power of 10 to divide based on the number of digits.
    * A power of 10 representing each digit (and the result of that 
    * subtraction) will be subtracted from the score successively
    * to extract each digit.
    */
  power = 1;
  for(i = 1; i < num_score_digits; ++i)
    power *= 10;

  /* extract each digit */
  for(i = 0; i < num_score_digits; ++i)
  {
    tmp = modScore / power;
    scoreDigitsArray[num][i] = tmp;
    modScore -= tmp * power;
    power = power / 10;
  } 
  return 0;
}
