/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include <math.h>
#include "nvaderz.h"
#include "bonus.h"

void drawbackground(void)
{
	/* erase the screen with black */
	rectfill(screen_buffer, 0, 0, screen_width, screen_height, BLACK);
}

void drawplayer(void)
{
	int i;

	for(i = 0; i < numberOfPlayers; i++) {
		if(player[i]->alive && player[i]->visible)
		{
			/* draw the scaled player bitmap to the screen */
			masked_stretch_blit(player_bmp[i], screen_buffer, 0, 0,
					player_bmp[i]->w, player_bmp[i]->h,
					player[i]->x, player[i]->y,
					player[i]->width, player[i]->height);
		}
	}
}

void drawhorde(void)
{
	/* draw each "alive" invader */
	int i, j;
	SPRITE *temp;
	
	/* draw only if invader invisible bonus is not active */
	if(hordeVisible)
	{
		for(i = 0; i < invader_rows; i++)
			for(j = 0; j < invader_columns; j++)
			{
				temp = &(invaders[i][j]);
				if(temp->alive)
				{
				    /* support multiple invaders by using
				       the invaders_bmp[] array */
					masked_stretch_blit(
						invaders_bmp[temp->alive -1][i],
						screen_buffer, 0,
						0,
						invaders_bmp[temp->alive -1][i]->w,
						invaders_bmp[temp->alive -1][i]->h,
						roundoff(temp->x),
						roundoff(temp->y),
						temp->width, temp->height);
				}
			}
	} /* closing if(hordeVisible) */

	/* for debugging, uncomment to draw a rect of horde->bounds */
	/* rect(screen_buffer, horde->bounds.x1, horde->bounds.y1,
			horde->bounds.x2, horde->bounds.y2, WHITE); 
	*/

	/* for debugging, draw rect around fire-eligible invaders */
	/* for(i = 0; i < invader_columns; i++)
	{
		if(bombarray[i] >= 0)
		{
			rect(screen_buffer,
				invaders[bombarray[i]][i].x,
				invaders[bombarray[i]][i].y,
				invaders[bombarray[i]][i].x + invaders[bombarray[i]][i].width,
				invaders[bombarray[i]][i].y + invaders[bombarray[i]][i].height,
				WHITE);
		}
	} */
}

void drawlasers(void)
{
	int i, num;
	/* draw the bombs */
	for(i = 0; i < invader_columns; i++)
	{
		if(bombs[i].alive)
		stretch_blit(bomb_bmp, screen_buffer, 0, 0,
				bomb_bmp->w, bomb_bmp->h,
				bombs[i].x, bombs[i].y,
				bomb_width, bomb_height);
	}

		
	/* draw the player's laser (if alive) */
	for(num = 0; num < 2; num++)
		for(i = 0; i < 3; i++)
		{
		  if(laser[num][i]->alive)
		  {
			stretch_blit(laser_bmp, screen_buffer, 0, 0,
					laser_bmp->w, laser_bmp->h,
					laser[num][i]->x, laser[num][i]->y,
					laser[num][i]->width, laser[num][i]->height);
		  }
		}

}

void drawHud(void)
{
    drawInterface();
    
    drawScore();

    drawIndicators();

    drawLives();
}

void drawshield(void)
{
	/* if one-way shield is active, draw it instead of
	 * the regular shield
	 */
	if(getOneWayStatus())
	{
		int i;
		for(i = 0; i < 3; i++)
		{
			/* draw the beam */
			rectfill(screen_buffer,
			  shield_x,
			  shield_y + (i * (shieldSpace + shieldSegmentHeight)),
			  shield_x + (shield_width - 1),
			  shield_y + (i * (shieldSpace + shieldSegmentHeight)) + shieldSegmentHeight,
			  makecol(0, 255, 255)
			  );
		}
		return;
	}
	if(shield->alive > 0)
	{
		int i, j;
		for(i = 0; i < 3; i++)
			for(j = 0; j < 64; j++)
			{
				if(shieldArray[i][j])
				{
					blit(shield_bmp, screen_buffer,
						0, 0,
						shield->x + (j * shield_bmp->w),
						shield->y+(i*(shield_bmp->h+shieldSegmentHeight)),
						shield_bmp->w,
						shield_bmp->h
						);
				}
			}
	}
}

void drawscreen(void)
{
    blit(screen_buffer, screen, 0, 0, 0, 0, screen->w, screen->h);
}

void drawcapsules(void)
{
	int i;

	for(i = 0; i < 6; i++)
	{
		if(capsules[i].alive)
		{
		  /* choose rotated sprite based on the capsule's
		   * position along it's trajectory
		   */
		   unsigned rotation = (getCapsulePosition(i)
			% 16);

		   masked_stretch_blit(capsule_bmp[rotation],
				screen_buffer, 0, 0,
				capsule_bmp[rotation]->w,
				capsule_bmp[rotation]->h,
				capsules[i].x, capsules[i].y,
				capsules[i].width, capsules[i].height);
		   
		   

		}
	}
}

void drawmissile(void)
{
	if(missile.alive)
	{
		/* draw the missile */
		masked_stretch_blit(rotatedMissile_bmp,
			screen_buffer, 0, 0,
			missile_bmp->w, missile_bmp->h,
			missile.x, missile.y,
			missile.width, missile.height
			);

	}
}

void drawimpact(void)
{
	if(impact.alive)
	{
		masked_stretch_blit(impact_bmp,
			screen_buffer, 0, 0,
			impact_bmp->w, impact_bmp->h,
			impact.x, impact.y,
			impact.width, impact.height
			);
	}
}
