/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include "nvaderz.h"
#include "highscores.h"
#include "optionsmenu.h"
#include "joystick.h"

static int upPressed, downPressed, activeButton, i;
static int enterPressed, spacePressed;

typedef struct BUTTON
{
    int x1, y1, x2, y2, color;
    char *text;
} BUTTON;

static BUTTON buttons[4], *but;
static BUTTON status;

void drawmenu(void);

void doselection(int option);

void updatebuttons(int dir);

void drawHighScores(void);

void displaymenu(void)
{
    /* create buttons */
    buttons[0].x1 = 20;
    buttons[0].y1 = 56;
    buttons[0].x2 = 220;
    buttons[0].y2 = 106;
    buttons[0].color = GREEN;
    buttons[0].text = "START GAME";

    buttons[1].x1 = 20;
    buttons[1].y1 = 162;
    buttons[1].x2 = 220;
    buttons[1].y2 = 212;
    buttons[1].color = GREEN;
    buttons[1].text = "OPTIONS";

    buttons[2].x1 = 20;
    buttons[2].y1 = 268;
    buttons[2].x2 = 220;
    buttons[2].y2 = 318;
    buttons[2].color = GREEN;
    buttons[2].text = "HIGH SCORE";
    
    buttons[3].x1 = 20;
    buttons[3].y1 = 374;
    buttons[3].x2 = 220;
    buttons[3].y2 = 424;
    buttons[3].color = GREEN;
    buttons[3].text = "QUIT";

    

    status.x1 = 240;
    status.y1 = 56;
    status.x2 = 630;
    status.y2 = 424;
    status.color = GREEN; 

    activeButton = 3;
    updatebuttons(1);
    drawmenu();

    /* check for joystick input */
    updateJoystickInfo();

    /* in case keys are still registered as being pressed... */
    if(key[KEY_ENTER])
        enterPressed = 1;
    else
        enterPressed = 0;
    if(key[KEY_SPACE] || key[KEY_ALT] || joyFire_p1)
        spacePressed = 1;
    else
        spacePressed = 0;
    if(key[KEY_UP] || key[KEY_W] || joyUp_p1)
        upPressed = 1;
    else
        upPressed = 0;
    if(key[KEY_DOWN] || key[KEY_S] || joyDown_p1)
        downPressed = 1;
    else
        downPressed = 0;

    while(1)
    {
	/* need to recheck for joystick input each frame */
	updateJoystickInfo();

	if((key[KEY_UP] || key[KEY_W] || joyUp_p1) && !upPressed)
	{
	    if(soundon)
		play_sample(navigateMainMenuSample,
			volume, pan, pitch, FALSE);
	    updatebuttons(-1);
	    drawmenu();
	    upPressed = 1;
	}
	else if((key[KEY_DOWN] || key[KEY_S] || joyDown_p1) && !downPressed)
	{
	    if(soundon)
		play_sample(navigateMainMenuSample,
			volume, pan, pitch, FALSE);
	    updatebuttons(1);
	    drawmenu();
	    downPressed = 1;
	}

	if((key[KEY_ENTER] && !enterPressed) ||
		((key[KEY_SPACE] || key[KEY_ALT] || joyFire_p1) && !spacePressed))
	{
	    /** if "start" button is selected,
	      * return from main menu and
	      * begin game, else call selection function
	      */
	    if(activeButton) {
		doselection(activeButton);
		drawmenu();
	    }
	    else /* active button must be 0, the "start" button */
	    {
		/* play start music on first level */
		if(soundon)
			play_sample(newGameSample, volume, pan,
				pitch, FALSE);

		/* clear spacebar and tilde presses before moving on */
		while(key[KEY_SPACE]);
		while(key[KEY_ALT]);
		joyFire_p1 = 0;

		/* start the background music loop */
		if(soundon)
			play_sample(backgroundSample, volume, pan,
				pitch, TRUE);

		return;
	    }
	}

	if(!key[KEY_DOWN] && !key[KEY_UP] && !key[KEY_ENTER]
		&& !key[KEY_SPACE] && !key[KEY_W] && !key[KEY_S]
		&& !key[KEY_ALT] && !joyUp_p1 && !joyDown_p1
		&& !joyFire_p1)
	{
	    upPressed = 0;
	    downPressed = 0;
	    spacePressed = 0;
	    enterPressed = 0;
	}
    }
}

void updatebuttons(int dir)
{
    char *buttontexts[4];
    buttontexts[0] = "Play the game.";
    buttontexts[1] = "Configure settings.";
    buttontexts[2] = "High Scores.";
    buttontexts[3] = "Quit playing.";

    activeButton += dir;

    if(activeButton < 0)
	activeButton = 3;
    else if(activeButton > 3)
	activeButton = 0;

    for(i = 0; i < 4; i++)
    {
	if(i == activeButton)
	{
	    buttons[i].color = LTGREEN;
	    status.text = buttontexts[i];
	}
	else
	    buttons[i].color = GREEN;
    }

}

void doselection(int option)
{
    switch(option)
    {
	case 1:
	    /* activate the options menu */
            activateOptionsMenu();
            setup();
	    break;
	case 2:
	    /* do nothing yet */
	    break;
	case 3:
	    cleanup();
	    exit(0);
    }
}

void drawmenu(void)
{
    clear_bitmap(screen_buffer);

    /* draw screen outline */
    rect(screen_buffer, 0, 0, screen_width - 1, screen_height - 1,
	    GREEN);
    
    /* draw the option buttons */
    for(i = 0; i < 4; i++)
    {
	but = &buttons[i];
	rectfill(screen_buffer, but->x1, but->y1, but->x2, but->y2,
		but->color);
	textout_centre_ex(screen_buffer, font, but->text,
		(but->x1 + but->x2) / 2,
		(but->y1 + but->y2) / 2,
		BLACK, -1 );
    }

    /* draw status button */
    if(activeButton == 2)
        drawHighScores();
    else
    {
	    rect(screen_buffer, status.x1, status.y1, status.x2, status.y2,
		    status.color);
	    textout_centre_ex(screen_buffer, font, status.text,
		    (status.x1 + status.x2) / 2,
		    (status.y1 + status.y2) / 2,
		    WHITE, -1 );
    }

    /* swap screen_buffers */
    blit(screen_buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
}

void drawHighScores(void)
{
	int x1, y1, x2, y2, scorex, namex, levelx, scorey, yspace;
	int score_color;

	x1 = status.x1;
	y1 = status.y1;
	x2 = status.x2;
	y2 = status.y2;

	scorex = x1 + 10;
	namex = scorex + 100;
	levelx = namex + 225;
	yspace = 23;
	scorey = y1 + yspace + 7;

	rect(screen_buffer, x1, y1, x2, y2,
		status.color);

	rect(screen_buffer, x1 + 2, y1 + 2,
		x2 - 2, scorey - 5,
		DKGREEN);

	textout_ex(screen_buffer, font, "Score",
		scorex + 15, y1 + 10,
		LTGREEN, -1);

	textout_ex(screen_buffer, font, "Name",
		namex + 60, y1 + 10,
		LTGREEN, -1);

	textout_ex(screen_buffer, font, "Level",
		levelx - 8, y1 + 10,
		LTGREEN, -1);

	/* draw the scores */
	for(i = 0; i < 15; i++)
	{
		if(i%2)
		{
			rectfill(screen_buffer, x1 + 5,
				scorey - (yspace / 2),
				x2 - 5, scorey + (yspace / 2),
				DKGREEN);
		}
		else
		{
			/*
			rectfill(screen_buffer, x1 + 5,
				scorey - (yspace / 2),
				x2 - 5, scorey + (yspace / 2),
				LTGREEN);
			*/
		}

		/* highlight the top score */
		if(i == 0)
			score_color = RED_ORANGE;
		else
			score_color = LTGREEN;

		textout_ex(screen_buffer, font, high_scores[i][0],
			scorex, scorey, score_color, -1);

		textout_ex(screen_buffer, font, high_scores[i][1],
			namex, scorey, score_color, -1);

		textout_ex(screen_buffer, font, high_scores[i][2],
			levelx, scorey, score_color, -1);
		scorey += yspace;
	}
}
