/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

/* bonus.h */
#ifndef __BONUS_H__
#define __BONUS_H__

void setupBonuses(void);
int getCapsuleOdds(void);
void setCapsuleOdds(int newOdds);
void incrementAvailableCapsules(void);
void incrementCapsulePosition(int capsule);
void updateCapsules(void);
int getCapsulePosition(int capsuleNumber);
void resetCapsuleTicks(void);
int getCapsuleXValue(int capsuleNumber, int position);
int getCapsuleYValue(int capsuleNumber, int position);

/* randomly activate one of the player bonuses */
int activateBonus(int playerNumber);

/* 3-shot functionality */
int updateThreeShot(void);
int activateThreeShot(int playerNumber);
int getThreeShotStatus(int playerNumber);

/* randomly activate one of the invader bonuses */
int activateInvaderBonus(void);
int activateImpact(void);
int updateImpact(void);

/* guided missiles functionality */
int activateGuided(int playerNumber);
int updateGuided(void);
int setGuidedSteering(int playerNumber, int value);
int getGuidedStatus(int playerNumber);
int getGuidedSteeringStatus(int playerNumber);

/* one way shield functionality */
int activateOneWay(void);
int disableOneWay(void);
int updateOneWay(void);
int getOneWayStatus(void);

/* missile functionality */
void activateMissile(void);
void updateMissile(void);
int getMissilePosition(void);
int getMissileXValue(int position);
int getMissileYValue(int position);

/* invisible invaders bonus functionality */
extern int hordeVisible;
extern int invisibleActive;
int activateInvisible(void);
int updateInvisible(void);
int activateReveal(void);
#endif
