/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/
#include "nvaderz.h"
#include "joystick.h"
#include "optionsmenu.h"

int currentButton;
int leftPressed, rightPressed;
void drawOptionsMenu(int activeButton);
void clearKeyBuffer(void);
void clearJoystickButtons(void);

void activateOptionsMenu(void) {
	currentButton = numberOfPlayers - 1;
	leftPressed = 1;
	rightPressed = 1;
	clearKeyBuffer();

	drawOptionsMenu(currentButton);

	/* clear joystick fire buffer */
	if(joysticksAllowed) {
		while(1) {
			updateJoystickInfo();
			if(!joyFire_p1) break;
		}
	}

	while(1) {
		clearJoystickButtons();

		updateJoystickInfo();

		if((joyLeft_p1 || key[KEY_LEFT] || key[KEY_A]) && !leftPressed) {
				currentButton--;
				if(currentButton < 0)
					currentButton = 1;
				drawOptionsMenu(currentButton);
				leftPressed = 1;
		}

		if((joyRight_p1 || key[KEY_RIGHT] || key[KEY_D]) && !rightPressed) {
				currentButton++;
				if(currentButton > 1)
					currentButton = 0;
				drawOptionsMenu(currentButton);
				rightPressed = 1;
		}
		if(!key[KEY_LEFT] && !key[KEY_RIGHT] &&
			!key[KEY_A] && !key[KEY_D] &&
			!joyLeft_p1 && !joyRight_p1) {
				rightPressed = 0;
				leftPressed = 0;
		}
		
		if(joyFire_p1 || key[KEY_SPACE] || key[KEY_ALT] || key[KEY_ENTER] ) {
			numberOfPlayers = currentButton + 1;
			clearKeyBuffer();

			/* clear joystick fire button buffer */
			if(joysticksAllowed) {
				while(1) {
					updateJoystickInfo();
					if(!joyFire_p1) break;
				}
			}
			clearJoystickButtons();
			return;
		}

		if(key[KEY_ESC]) {
			clearKeyBuffer();
			return;
		}
	}

	return;

}

void drawOptionsMenu(int activeButton) {
	int menuX, menuY, menuWidth, menuHeight;
	int buttonX[2], buttonY, buttonWidth, buttonHeight;
	int buttonPadding;

	menuWidth = 300;
	menuHeight = 100;
	menuX = (screen_width / 2) - (menuWidth / 2);
	menuY = (screen_height / 2) - (menuHeight / 2);

	buttonPadding = 10;
	buttonWidth = (menuWidth / 2) - (buttonPadding +
		(buttonPadding / 2));
	buttonHeight = menuHeight / 2;
	buttonX[0] = menuX + buttonPadding;
	buttonX[1] = buttonX[0] + buttonWidth + buttonPadding;
	buttonY = menuY + (menuHeight / 2) - (buttonHeight / 2);

	/* draw the menu region */
	rectfill(screen_buffer, menuX - 2, menuY - 2, menuX + menuWidth + 2,
		menuY + menuHeight + 2, BLACK);

	/* draw the menu outline */
	rect(screen_buffer, menuX, menuY, menuX + menuWidth,
		menuY + menuHeight, GREEN);

	/* draw the buttons */
	if(activeButton == 0) {
	rectfill(screen_buffer, buttonX[0], buttonY, buttonX[0] + buttonWidth,
		buttonY + buttonHeight, LTGREEN);
	}
	else {
	rectfill(screen_buffer, buttonX[0], buttonY, buttonX[0] + buttonWidth,
		buttonY + buttonHeight, GREEN);
	}
	if(activeButton == 1) {
	rectfill(screen_buffer, buttonX[1], buttonY, buttonX[1] + buttonWidth,
		buttonY + buttonHeight, LTGREEN);
	}
	else {
	rectfill(screen_buffer, buttonX[1], buttonY, buttonX[1] + buttonWidth,
		buttonY + buttonHeight, GREEN);
	}

	/* draw the button text */
	textout_centre_ex(screen_buffer, font, "1 PLAYER",
		buttonX[0] + (buttonWidth / 2),
		buttonY + (buttonHeight / 2),
		BLACK, -1);

	textout_centre_ex(screen_buffer, font, "2 PLAYERS",
		buttonX[1] + (buttonWidth / 2),
		buttonY + (buttonHeight / 2),
		BLACK, -1);

	/* draw the menu title */
	textout_centre_ex(screen_buffer, font, "HOW MANY PLAYERS?",
		menuX + (menuWidth / 2),
		menuY + ((buttonY - menuY) / 2) - 2,
		RED, -1);

	/* swap screen buffers */
	blit(screen_buffer, screen, 0, 0, 0, 0, screen_width, screen_height);
}

void clearKeyBuffer(void) {
	while(key[KEY_UP]);
	while(key[KEY_DOWN]);
	while(key[KEY_LEFT]);
	while(key[KEY_RIGHT]);
	while(key[KEY_A]);
	while(key[KEY_W]);
	while(key[KEY_D]);
	while(key[KEY_S]);
	while(key[KEY_SPACE]);
	while(key[KEY_ALT]);
	while(key[KEY_ENTER]);
}

void clearJoystickButtons(void) {
	joyLeft_p1 = 0;
	joyRight_p1 = 0;
	joyUp_p1 = 0;
	joyDown_p1 = 0;
	joyFire_p1 = 0;
}
