/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#ifndef __NVADERZ_H__

#define __NVADERZ_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "allegro.h"

#include "hud.h"

#define VERSION_STRING "Version: CVS source code version"

#define MODE GFX_AUTODETECT_WINDOWED
#define WIDTH 640
#define HEIGHT 480
#define BASELINE 388
#define TOPLINE 10

/* game area boundaries */
#define LEFT_BOUNDARY 10
#define RIGHT_BOUNDARY 629

#define GAME_SPEED_IN_MILLISECONDS 1

#define PLAYER_H 25
#define PLAYER_W 25
#define PLAYER_SPACE_H 2
#define PLAYER_LINE BASELINE - PLAYER_H - PLAYER_SPACE_H

#define INVADER_H 27
#define INVADER_W 27
#define INV_SPACE_W 5
#define INV_SPACE_H 3
#define INV_COLUMNS 7
#define INV_ROWS 5 
#define NUMBER_OF_INVADERS INV_COLUMNS * INV_ROWS
#define HORDESTART_Y 85

/* define defaults for super invaders */
#define DOUBLE_INVADER_START_LEVEL 5
#define TRIPLE_INVADER_START_LEVEL 9
#define DOUBLE_INVADER_ODDS 40
#define TRIPLE_INVADER_ODDS 40
#define DOUBLE_INVADER_ODDS_CHANGE 10
#define TRIPLE_INVADER_ODDS_CHANGE 10

#define LASER_H 4
#define LASER_W 4

#define BOMB_H 4
#define BOMB_W 3
/* define some colors */
#define WHITE makecol(255, 255, 255)
#define BLACK makecol(0, 0, 0)
#define RED makecol(255, 0, 0)
#define PINK makecol(255, 200, 200)
#define GREEN makecol(0, 255, 0)
#define LTGREEN makecol(200, 255, 200)
#define DKGREEN makecol(0, 100, 0)
#define ORANGE makecol(255, 255, 0)
#define RED_ORANGE makecol(255, 200, 0)

/* define hud defaults */
#define SCORE_DIGIT_WIDTH 40
#define SCORE_DIGIT_HEIGHT 40
#define SCORE_DIGIT_HSPACE -5
#define SCORE_LEFT_LIMIT 80
#define SCORE_RIGHT_LIMIT 559
#define SCORE_TOPLINE 25
#define NUM_SCORE_DIGITS 6

#define LIVES_UNIT_WIDTH 40
#define LIVES_UNIT_HEIGHT 40
#define LIVES_UNIT_HSPACE -18
#define LIVES_LEFT_LIMIT 98
#define LIVES_RIGHT_LIMIT 523
#define LIVES_TOPLINE 429
#define NUM_LIVES_UNITS 6
#define LIVES_SHIP1_X 248
#define LIVES_SHIP2_X 352
#define LIVES_SHIP_Y 428
#define LIVES_SHIP_WIDTH 40
#define LIVES_SHIP_HEIGHT 40

/* variables to store the game's file paths */
extern char gamePath[256];
extern char gameDirectory[256];
extern char resourceDirectory[256];

/* define settings variables */
extern int screen_mode;
extern int screen_width;
extern int screen_height;
extern int screen_baseline;
extern int screen_topline;

/* game area boundaries */
extern int left_boundary;
extern int right_boundary;

/** all speed variables change
  * from int to float
  */
extern float player_x_speed;
extern int player_height;
extern int player_width;
extern int player_space_top;
extern int player_topline;
extern int player_bounds_offsetx1;
extern int player_bounds_offsetx2;
extern int player_bounds_offsety1;
extern int player_bounds_offsety2;

extern int invader_height;
extern int invader_width;
extern int invader_space_horizontal;
extern int invader_space_vertical;
extern int invader_columns;
extern int invader_rows;
extern int invader_number;

extern float horde_x_speed;
extern int horde_start_x;
extern int horde_start_y;

extern unsigned double_invader_start_level;
extern unsigned triple_invader_start_level;
extern unsigned double_invader_odds;
extern unsigned triple_invader_odds;
extern unsigned double_invader_odds_change;
extern unsigned triple_invader_odds_change;

extern float laser_y_speed;
extern int laser_height;
extern int laser_width;

extern float bomb_y_speed;
extern int bomb_height;
extern int bomb_width;
extern int dropFactor;
extern int dropOdds;

/* define hud global variables */
extern int score_digit_width;
extern int score_digit_height;
extern int score_digit_hspace;
extern int score_left_limit;
extern int score_right_limit;
extern int score_topline;
extern int num_score_digits;

extern int lives_unit_width;
extern int lives_unit_height;
extern int lives_unit_hspace;
extern int lives_left_limit;
extern int lives_right_limit;
extern int lives_topline;
extern int num_lives_units;
extern int lives_ship1_x;
extern int lives_ship2_x;
extern int lives_ship_y;
extern int lives_ship_width;
extern int lives_ship_height;

/* timer variables */
extern volatile long clockTicks;
extern int clockChangedFlag;
extern int gameSpeedInMilliseconds;

/* define global variables */
extern int numberOfPlayers, gameover, lives[2], firing[2][3], gamePause;
extern unsigned score[2], totalinvaders, level;
extern unsigned extraLifePoints;  /* extra life awarded after this many */
extern int splashFlag;

extern BITMAP *screen_buffer;

extern BITMAP *player_bmp[2];
extern BITMAP *laser_bmp;
extern BITMAP *bomb_bmp;
extern BITMAP *capsule_bmp[16];
extern BITMAP *missile_bmp;
extern BITMAP *rotatedMissile_bmp;
extern BITMAP *impact_bmp;

/* add support for multiple invader bitmaps */
extern BITMAP *invaders_bmp[3][5];

typedef struct BOUNDS
{
	int x1, y1, x2, y2;
} BOUNDS;

typedef struct SPRITE
{
    /** speed variables changed
      * from int to float
      */
	/* int x, y; */
        float x, y;
	unsigned width, height;
	float xspeed, yspeed;
	int dir;
	int alive;
	int moving;
	BOUNDS bounds;
	char *type;
	/* blink attributes */
	int blinking;
	int visible;
	int blinkDelay;
} SPRITE;

/* extern SPRITE theplayer; */
extern SPRITE theplayer[2];
extern SPRITE thehorde;
extern SPRITE thelaser[2][3];
extern SPRITE invaders[INV_ROWS][INV_COLUMNS];
/* extern SPRITE *player; */
extern SPRITE *player[2];
extern SPRITE *horde;
extern SPRITE *laser[2][3];

extern SPRITE bombs[INV_COLUMNS];
extern int bombarray[INV_COLUMNS];

extern SPRITE theshield;
extern SPRITE *shield;
extern int shieldArray[3][64];
extern BITMAP *shield_bmp;
extern int shieldTicks;
extern int shield_x;
extern int shield_y;
extern unsigned shield_width;
extern unsigned shield_height;
extern unsigned shieldSegmentWidth;
extern unsigned shieldSegmentHeight;
extern unsigned shieldSpace;

extern SPRITE capsules[6];
extern SPRITE missile;
extern SPRITE impact;

/* sound */
extern SAMPLE *fireSample;
extern SAMPLE *playerKilledSample;
extern SAMPLE *invaderKilledSample;
extern SAMPLE *shieldSample;
extern SAMPLE *backgroundSample;
extern SAMPLE *newGameSample;
extern SAMPLE *gameOverSample;
extern SAMPLE *navigateMenuSample;
extern SAMPLE *selectSample;
extern SAMPLE *navigateMainMenuSample;
extern SAMPLE *selectMainMenuSample;
extern SAMPLE *regenerationSample;
extern SAMPLE *extraLifeBonusSample;
extern SAMPLE *missileBlastSample;
extern SAMPLE *missileAlertSample;
extern int soundon;
extern int pan, pitch, volume;

void cleanup(void);
void displaysplash(int loadingFlag);
void updatehorde(void);
void applyflags(int args, char *strargs[]);
void fire(int playerNumber);
int testcollision(BOUNDS *projectile, BOUNDS *target);
void killplayer(int playerNumber);
void endgame(int endCode);
void reset(void);
void gonextlevel(void);
void setup(void);
void drawbackground(void);
int moveplayer(int playerNumber, int dir);
int movehorde(void);
void movelasers(void);
void drawplayer(void);
void drawhorde(void);
void drawlasers(void);
void drawshield(void);
void drawHud(void);
void displaystatus(void);
void getinput(void);
void displaygameover(void);
void initializegame(void);
int getfilesettings(void);
void setdefaults(void);
void displaymenu(void);
int roundoff(double value);
int calcInvaderLife(void);
void updateInvaderOdds(void);

/* pause and blinking functions */
void setPause(int pauseState);
int getPause(void);
int updateBlinking(void);

int shield_testcollision(SPRITE *projectile, char *direction);

void getPlayerName(char *playerName, int playerNum);

void drawscreen(void);

void movecapsules(void);

void updateShield(void);

void drawcapsules(void);

void movemissile(void);
void drawmissile(void);
void drawimpact(void);

int addToScore(int playerNumber, int modValue);

/* timer functions */
void setUpTimer(void);
void updateGameClock(void);
int checkClockUpdated(void);

/* variable to set whether we want joystick support */
extern int joysticksAllowed;

/* variable to store allegro graphics mode */
extern int mode;

#endif
