/*

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include "nvaderz.h"
#include "bonus.h"

/* declare the graphics mode variable */
int mode;

int main(int argc, char *argv[])
{
	/* check to see if an allegro graphics mode was passed on the
		command line:
		ex: nvaderz GFX_AUTODETECT_FULLSCREEN
	*/
	if(argc > 1) {
		/* only accept a valid graphics mode */
		if(!strcmp(argv[1], "GFX_AUTODETECT")) 
			mode = GFX_AUTODETECT;	
		else if(!strcmp(argv[1], "GFX_AUTODETECT_WINDOWED"))
			mode = GFX_AUTODETECT_WINDOWED;
		else if(!strcmp(argv[1], "GFX_AUTODETECT_FULLSCREEN"))
			mode = GFX_AUTODETECT_FULLSCREEN;
		else if(!strcmp(argv[1], "GFX_SAFE"))
			mode = GFX_SAFE;
		else if(!strcmp(argv[1], "GFX_TEXT"))
			mode = GFX_TEXT;
		/* otherwise, use whatever we set as default */
		else 
			mode = MODE;
		}
	/* or if no arguments were passed, use default */
	else
		mode = MODE;
	initializegame();

	/* set game paths (to do: be sure array not overrun) */
	strcpy(gamePath, argv[0]);
	strcpy(gameDirectory, gamePath);
	gameDirectory[ strlen(gameDirectory) - strlen("nvaderz") ] = 0;
	/* comment out: Do we really need the full path? */
	strcpy(resourceDirectory, gameDirectory);
	strcat(resourceDirectory, "Resources/");

	/* If we're on a Win32 system, make the Resource directory path
	** relative, rather than specifying the whole path, because
	** explicit paths aren't working when launching the game
	** from the Windows Vista desktop (It only works from the
	** command prompt.)
	*/
	if(os_type == OSTYPE_WIN3 || os_type == OSTYPE_WIN95 ||
		os_type == OSTYPE_WIN98 || os_type == OSTYPE_WINME ||
		os_type == OSTYPE_WINNT || os_type == OSTYPE_WIN2000 ||
		os_type == OSTYPE_WINXP || os_type == OSTYPE_WIN2003 ||
		os_type == OSTYPE_WINVISTA) {

		strcpy(resourceDirectory, "Resources/");
	}


	/* set splashFlag so displaysplash() will run in setup() */
	splashFlag = 1;

	/* set numberOfPlayers < 0 so setup() knows this is initial start */
	numberOfPlayers = -1;

	setup();

	applyflags(argc, argv);

	displaymenu();

	/* game loop */
	while(!gameover)
	{

	    /* check if game clock updated */
	    if(checkClockUpdated())
		clockChangedFlag = 1;
	    else
		clockChangedFlag = 0;

	    drawbackground();

	    /* move elements if clock changed */
	    if(clockChangedFlag)
	    {
	      int pauseState = getPause();

	      if(!pauseState)
	      {
		movehorde();

		movelasers();

		movecapsules();

		movemissile();

		updateShield();

		updateThreeShot();

		updateGuided();

		updateOneWay();

		updateImpact();

		updateInvisible();
	      }
	      else if(pauseState > 1) /* if an in-game pause */
	      {
	        updateBlinking();
	      }
	    }

            drawcapsules();

	    drawmissile();

	    drawplayer();

	    drawhorde();

	    drawlasers();
	
            drawshield();

	    drawimpact();

	    drawHud();

            drawscreen();

	    /*
	    if(keypressed())
		    getinput();
	    */
	    getinput();

	    rest(20);
		
	}

	cleanup();

	return 0;
} /* main() */
END_OF_MAIN()
