/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

/* joystick.c */

#include "joystick.h"
#include <stdio.h>
#include "nvaderz.h"
#include "allegro.h"

int updateJoystickInfo(void) {
	/* Check that joystick support is wanted. This is a variable set
		in gamefunction.c::setdefaults().
	*/
	int returnValue = 1;

	if(joysticksAllowed) {
		poll_joystick();

		if(num_joysticks > 0) {
			if(joy[0].num_buttons >= 10) {
				if(joy[0].button[0].b) joyUp_p1 = 1;
				else joyUp_p1 = 0;
				if(joy[0].button[1].b) joyRight_p1 = 1;
				else joyRight_p1 = 0;
				if(joy[0].button[2].b) joyDown_p1 = 1;
				else joyDown_p1 = 0;
				if(joy[0].button[3].b) joyLeft_p1 = 1;
				else joyLeft_p1 = 0;
				if(joy[0].button[6].b) joyFire_p1 = 1;
				else joyFire_p1 = 0;
				if(joy[0].button[9].b) joyReset_p1 = 1;
				else joyReset_p1 = 0;

				returnValue = 0;
			}
			if(num_joysticks > 1 && joy[1].num_buttons >= 10) {
				if(joy[1].button[0].b) joyUp_p2 = 1;
				else joyUp_p2 = 0;
				if(joy[1].button[1].b) joyRight_p2 = 1;
				else joyRight_p2 = 0;
				if(joy[1].button[2].b) joyDown_p2 = 1;
				else joyDown_p2 = 0;
				if(joy[1].button[3].b) joyLeft_p2 = 1;
				else joyLeft_p2 = 0;
				if(joy[1].button[6].b) joyFire_p2 = 1;
				else joyFire_p2 = 0;
				if(joy[1].button[9].b) joyReset_p2 = 1;
				else joyReset_p2 = 0;
				
				returnValue = 0;
			}
		}
	}
	return returnValue;
}
