/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include "nvaderz.h"
#include <ctype.h>
#include "highscores.h"

char scores_file[256];
char high_scores[15][3][25];

void numberToString(long score, char *string, int digits);

int getScoresFromFile(void)
{
	FILE *fp;
	char linestr[256];
	char tempstr[256], substr1[256], substr2[256], substr3[256];
	int i, j, tempLength;

	strcpy(scores_file, resourceDirectory);
	strcat(scores_file, "scores.file");

	if( (fp = fopen(scores_file, "r")) == NULL)
	{
		printf("Error opening for reading file: %s\n",
			scores_file);
		printf("scores_file will be created at %s\\%s\n",
			resourceDirectory, "scores.file");
		return 1;
	}

	/* initialize high scores defaults */
	for(i = 0; i < 15; i++)
	{
		strcpy(high_scores[i][0], "000000000");
		strcpy(high_scores[i][1], "[]");
		strcpy(high_scores[i][2], "000");
	}

	/* get scores data from file */
	for(i = 0; (i < 15) && !feof(fp); i++)
	{
		if(fgets(linestr, 256, fp) == NULL)
		{
			if(!feof(fp))
			{
				printf("Error reading from %s\n",
					scores_file);
				return 1;
			}
			else
				break;
		}

		if(strlen(linestr) < 1)
			return 1;

		strcpy(tempstr, linestr);

		/* to be safe, change last character to '\0' */
		tempstr[strlen(tempstr)] = '\0';

		/** loop through string, changing spaces and
		 ** line endings to null terminators.
		 */
		tempLength = strlen(tempstr);
		for(j = 0; j < tempLength; j++)
		{
			
			if(tempstr[j] == '^' || tempstr[j] == '\n')
			/*
				tempstr[j] = '\0';
			if(!isalnum(tempstr[j]) || tempstr[j]==' ')
			*/
			{
				tempstr[j] = '\0';
			}
		}

		strcpy(substr1, tempstr);

		if(strlen(substr1) < strlen(linestr))
		{
			strcpy(substr2, &tempstr[strlen(substr1) + 1]);

			if(strlen(substr1) + strlen(substr2) < 
				strlen(linestr))
			{
				strcpy(substr3,
					&tempstr[strlen(substr2) + 1
						+strlen(substr1) + 1]);
			}
			else
			{
				strcpy(substr3, "TBD");
			}
		}
		else
		{
			strcpy(substr2, "[]");
			strcpy(substr3, "tbd");
		}

		strncpy(high_scores[i][0], substr1, 9);
		strncpy(high_scores[i][1], substr2, 24);
		strncpy(high_scores[i][2], substr3, 3);
	}

	fclose(fp);

	return 0; /* everything went OK */
}

int writeScoresToFile(void)
{
	FILE *fp;
	int i;
	char scoreString[256];
	strcpy(scores_file, resourceDirectory);
	strcat(scores_file, "scores.file");

	if((fp = fopen(scores_file, "w")) == NULL)
	{
		puts("Error opening scores.file for writing.");
		return 1;
	}

	for(i = 0; i < 15; i++)
	{
		/* compile the high score information */
		strcpy(scoreString, high_scores[i][0]);
		strcat(scoreString, "^");
		strcat(scoreString, high_scores[i][1]);
		strcat(scoreString, "^");
		strcat(scoreString, high_scores[i][2]);
		strcat(scoreString, "\n");

		if((fprintf(fp, scoreString)) < 0)
		{
			puts("Error writing to scores.file");
			return 1;
		}
	}

	fclose(fp);

	return 0;

}

int updateHighScores(int playerNumber, long newScore)
{
	int changedFlag, i, j, num;
	char name[25];

	num = playerNumber;

	changedFlag = 0;
	strcpy(name, "PLAYER 1");

	/** Check if newScore is higher than
	  * any existing score.
	  */
	for(i = 0; i < 15; i++)
	{
		if(newScore > strtod(high_scores[i][0], NULL))
		{
			changedFlag = 1;
			/* call the player name dialog */
			getPlayerName(name, num);
			
			/** loop from the end of the high scores
			  * and push each one back a notch, which
			  * also removes the last one.
			  */
			for(j = 14; j > i; j--)
			{
				strcpy(high_scores[j][0],
					high_scores[j-1][0]);
				strcpy(high_scores[j][1],
					high_scores[j-1][1]);
				strcpy(high_scores[j][2],
					high_scores[j-1][2]);
			}

			/* add newScore to the current position */
			numberToString(newScore,
				high_scores[i][0], 9);
			strncpy(high_scores[i][1], name, 24);
			numberToString(level,
				high_scores[i][2], 3);
	
			break;
		}
	}

	return changedFlag;
}

void numberToString(long score, char *string, int digits)
{
	char tempString[9];
	int temp, i;
	long power;

	/** calculate power to divide by, based on the
	 ** number of digits
	 **/
	power = 1;
	for(i = 0; i < digits - 1; i++)
		power *= 10;

	/* change each digit into a char */
	for(i = 0; i < digits; i++)
	{
		temp = score / power;
		tempString[i] = temp + 48;
		score -= temp * power;
		power = power / 10;
	}

	/* add the null terminator to the string */
	tempString[digits] = '\0';

	strcpy(string, tempString);
}

