/*  This file is part of the program:

    nV@derz! (nvaderz)
    Copyright (C) 2006-2013  Eric Pellegrin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

    Eric Pellegrin can be reached by email at pellea72(at)yahoo(dot)com
    (Note: email address modified to evade unsolicited email search bots.
        Change (at) to @ and (dot) to . to read name@company.com )
*/

#include "getfilesettings.h"
#include "ctype.h"

int validate(char *numberStr);

int getfilesettings(void)
{
    int i, validationCode, strLength;
    char token1[256], token2[256], str[256];
    FILE *fp;
    char filename[256];

    /* open the settings file */
    strcpy(filename, resourceDirectory);
    strcat(filename, "settings.file");
    if((fp = fopen(filename, "r")) == NULL)
    {
	printf("\nError opening for reading file: %s\n",
		filename);
	return 1;
    }

    /* loop through the file reading each line */
    while(!feof(fp))
    {
	if((fgets(str, 256, fp)) == NULL)
	{
	    if(!feof(fp))
	    {
		printf("\nError reading from file: %s\n", filename);
		exit(1);
	    }
	    else
		break;
	}

	/* loop through the line, changing ' ' and '\n' to '\0' */
	strLength = strlen(str);
	for(i = 0; i < strLength; i++)
	{
	    if(str[i] == ' ' || str[i] == '\n')
		str[i] = '\0';
	}

	/* just in case, change the last character in str to '\0' */
	str[strlen(str)] = '\0';

	strcpy(token1, str);
	strcpy(token2, &str[strlen(token1) + 1]);

	/* printf("%s\t%s\n", token1, token2); */

	if(!strcmp(token1, "end"))
	    break;

	/* skip lines beginning with a '#' or '\n'*/
	if( token1 && (token1[0] == '#' || token1[0] == '\n'))
	    continue;

	/* pass the tokens to applysettings() */
		/** make sure token2 only contains numerals
		  * and, at most, one decimal point
		  */
		if((validationCode=validate(token2)) )
		{
			printf("%d:%s %s %s %s\n",
				validationCode,
				token1,
				token2,
				"from settings.file",
				"not a valid setting. Using defaults."
			);
		}
		else
			applysettings(token1, token2);

    }

    fclose(fp);

    return 0;
}

int validate(char *numberStr)
{
	unsigned numDecimals, numNegatives, retVal, i;
	char currentChar;

	numDecimals = 0;
	numNegatives = 0;
	retVal = 0;

	for(i = 0; i < strlen(numberStr); i++)
	{
		currentChar = numberStr[i];
		
		if(!isdigit(currentChar))
		{
			if(currentChar == '.')
			{
				if(++numDecimals > 1)
				{
					retVal = 1;
					break;
				}
			}
			else if(currentChar == '-')
			{
				if(++numNegatives > 1)
				{
					retVal = 2;
					break;
				}
			}
			else if(currentChar == '\0')
				continue;
			else if(currentChar == '\n')
				continue;
			else
			{
				retVal = 3;
				break;
			}
		}
	}

	return retVal;
}
