/*

  3 SQUARES - PROTOTYPE -

   This software is just a Tic-Tac-Toe Video-Game

   This Video-Game is programmed in native C++, 
   exclusively by Miguel Toledo Gonzalez and using the Allegro graphics library

   -----------------------------------------------------------------------------------------
   -----------------------------------------------------------------------------------------

   LICENSE **********************************************************
   -----------

    Copyright (C)  2013 Miguel Toledo Gonzalez

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	********************************************************************

	-> Continue... Please, you can see the entire License in file here included:

														<h_License.h>

    *********************************************************************

	 For questions or suggestions and technical help, please, send me an email:

	 <migueltoledo74@yahoo.de>

	 My personal home page is <http://www.mtoledo.zxq.net>


*/

 // INTERFACE

// Atencin: En caso de que el input del usuario
// sea la longitud en pxeles del lado de un cuadrado bsico,
// el objeto <q_grid> lo optimiza basandose en el algoritmo de Euclides
// respecto de las dimensiones horizontal y vertical del tablero.

// Si damos como input el n de filas o el n de columnas de 
// los cuadrados del tablero, el objeto <q_grid> calcula los restantes
// parmetros optimizados tambin por el algoritmo de Euclides
// para cubrir todo el tablero con cuadrados.

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <allegro.h>
// ......................................................
#include "a_algoritmoEuclides.h"
#include "a_rgb.h"
#include "b_allegro.h"
#include "b_globals.h"
#include "c_definiciones.h"
#include "d_ij_botones_help.h"
#include "e_grids.h"
#include "f_raton.h"
#include "f_thePlayers.h"
#include "g_infos.h"
#include "h_License.h"

/* ----------------------------------------------------- */

using namespace std;
bool ayuda_visible=false;
bool llamada=false;
// En el caso de que el jugador juega contra la computadora
/*

En ese caso, el parmetro UnPlayer es true.
La computadora, en su turno, elige dnde mover las fichas.




*/


bool UnPlayer=true; 

// -----------------------------------------------------------


int main(){
	
	// SET SCREEN -----------------------------------------
		set_allegro(); setcolor();
		clear_to_color( tapiz, color_tapiz ); 
		clear_to_color( tablero, color_tablero );
		clear_to_color( panel1, color_panel1 ); 
		clear_to_color( panel2, color_panel2 );

		// Presentacin

		_presenta();

	// ----------------------------------------------------------
	// Tablero inputs: longitud del lado del cuadrado bsico, nfilas  n de columnas.
	// Transformar de coordenadas respecto screen a coordenadas regionales por cada bitmap
	// Screen -> { region(panel1), region(tapiz), region(tablero), region(panel2) }
		
		//maus.pon();
		ptr_maus->pon();
		// GRID ----------------------------------------------------------------------
		q_grid eltablero=q_grid(0,tablero,0,C.ROSA_HOTPINK,0,3); 
		q_grid* ptr_tablero = &eltablero; // Direccin de memoria del tablero
		ptr_tablero->reservamemoria();
		ptr_tablero->limpiacuadros(); // Ya hace la reserva de memoria. No hacer 2 veces reserva de memoria!
		//eltablero.limpiacuadros();
		// JUGADORES
		player player1; 
		player* ptr_player1=&player1;
		player player2;
		player* ptr_player2=&player2;
		//--------------
		ganador _ganador; 
		ganador* ptr_ganador=&_ganador;
		ptr_ganador->theplayer1=false; ptr_ganador->theplayer2=false;
		// BOTON EXIT -----------------------------------------------------------------
		boton b_exit=boton(panel2, punto((panel2->w-tablero->w)/2 , _at(1) ), punto(0,0), quad(punto(0,0),punto(0,0), 0,0,0,0),
			" EXIT ",0,0,0,0,C.black, C.AZUL_MEDIUMBLUE, C.AMARILLO_GOLD);
		
		boton* ptr_b_exit = &b_exit; 	b_exit.calcula(); b_exit.pon();	
	
		// --------------------------------------------------------------------------------
		// BOTN REPLAY 
		boton b_limpia=boton(panel2, punto(ptr_b_exit->p2.x+c_texto(2) , _at(1) ), 
			punto(0,0), quad(punto(0,0),punto(0,0), 0,0,0,0),
			" REPLAY ",0,0,0,0,C.black, C.AZUL_MEDIUMBLUE, C.AMARILLO_GOLD);
		
		boton* ptr_b_limpia = &b_limpia; b_limpia.calcula(); b_limpia.pon();

		// --------------------------
			// BOTON AYUDA -----------------------------------------------------------------
		boton b_ayuda=boton(panel2, punto(  ptr_b_limpia->p2.x+c_texto(2) , _at(1) ), 
			punto(0,0), quad(punto(0,0),punto(0,0), 0,0,0,0),
			" HELP ",0,0,0,0,C.black, C.AZUL_MEDIUMBLUE, C.AMARILLO_GOLD);
		
		boton* ptr_b_ayuda = &b_ayuda; b_ayuda.calcula(); b_ayuda.pon();

		// BOTON ABOUT  -----------------------------------------------------------------
		boton b_about=boton(panel2, punto(  ptr_b_ayuda->p2.x+c_texto(2) , _at(1) ), 
			punto(0,0), quad(punto(0,0),punto(0,0), 0,0,0,0),
			" ABOUT ",0,0,0,0,C.black, C.AZUL_MEDIUMBLUE, C.AMARILLO_GOLD);
		
		boton* ptr_b_about = &b_about; b_about.calcula(); b_about.pon();

		
		// BOTON 1PLAYER  -----------------------------------------------------------------
		boton b_1player=boton(panel2, punto(  ptr_b_about->p2.x+c_texto(2) , _at(1) ), 
			punto(0,0), quad(punto(0,0),punto(0,0), 0,0,0,0),
			" 1PLAYER GAME ",0,0,0,0,C.black, C.AZUL_MEDIUMBLUE, C.AMARILLO_GOLD);
		
		boton* ptr_b_1player = &b_1player; b_1player.calcula(); b_1player.pon();

	   // BOTON 2PLAYER  -----------------------------------------------------------------
		boton b_2player=boton(panel2, punto(  ptr_b_1player->p2.x+c_texto(2) , _at(1) ), 
			punto(0,0), quad(punto(0,0),punto(0,0), 0,0,0,0),
			" 2PLAYER GAME ",0,0,0,0,C.black, C.AZUL_MEDIUMBLUE, C.AMARILLO_GOLD);
		
		boton* ptr_b_2player = &b_2player; b_2player.calcula(); b_2player.pon();



		// Empieza por el turno del player1
		ptr_player1->turno=true; ptr_player2->turno=false;
		// Al principio, cada jugador tiene 0 fichas en juego.
		ptr_player1->fichas=0; ptr_player2->fichas=0;
		
		rest(199); // Es importante para dar tiempo a la actualizacin interna de la memoria!
		while(!key[KEY_ESC]){
		
			rest(1);

			//ptr_maus->boton_iz=false;

		// Ya hemos reservado previamente la memoria dinmica
		
			ptr_tablero->dogrid();
			ptr_maus->update( ptr_tablero );
			
			//maus.update( ptr_tablero );

			 if(!gameover){
				 
				 ptr_maus->asigna( ptr_tablero, ptr_player1, ptr_player2, UnPlayer );		
		  	
				 //ptr_maus->update( ptr_tablero );

			 }
		 
			 // Comprueba si hay algn ganador -----------------------------------------------------------------
		  if( (ptr_ganador->theplayer1==false) && (ptr_ganador->theplayer2==false) )
			  { _ganador=gana( ptr_tablero );	 gameover=false; }	
		  else {
			  gameover=true;
			  pon_gameover( 0,-1, ptr_ganador);
			// **************** CIERRA VENTANA DEL GAME OVER ***************************************************
		if ( maus.en_x2() ){ pon_gameover( C.ROJO_RED, C.WHITE,ptr_ganador );} // Ilumina 
		if (  (maus.en_x2() && maus.boton_iz) || key[KEY_R] ) { 
			// Reinicio
					ptr_ganador->theplayer1=false;
					ptr_ganador->theplayer2=false;
					ptr_player1->fichas=0; ptr_player2->fichas=0;
					gameover=false;
					ptr_tablero->limpiacuadros();
					clear_to_color(tapiz, color_tapiz);
			        }	// if de ventana
			  }	 // if general de comprobacin
					   
		 // infos( ptr_tablero, ptr_maus, ptr_player1, ptr_player2, ptr_ganador); // Toma la direccin de memoria del tablero como argumento
		  // ---------------------------------------------------------------------------------

		  etiq_players( ptr_player1, ptr_player2, UnPlayer );



		// Gestin de eventos ******BOTON EXIT ********************************************
		if ( maus.enboton( ptr_b_exit ) ) {	ptr_b_exit->enfocado=true; ptr_b_exit->colorfondo=C.WHITE; }	
		else { ptr_b_exit->enfocado=false; ptr_b_exit->colorfondo=C.AMARILLO_GOLD; }

		b_exit.pon(); if(maus.clic( ptr_b_exit )) { break; }
	   
		// Gestin de eventos **********BOTON AYUDA ****************************************
		if ( maus.enboton( ptr_b_ayuda ) ) { ptr_b_ayuda->enfocado=true; ptr_b_ayuda->colorfondo=C.WHITE; 	}	
		else { ptr_b_ayuda->enfocado=false; ptr_b_ayuda->colorfondo=C.AMARILLO_GOLD; }

		b_ayuda.pon(); if(maus.clic( ptr_b_ayuda )) {  ayuda_visible=true;  }

		// **************** CIERRA VENTANA ***************************************************
		if ( (ayuda_visible && maus.en_x() && maus.boton_iz) || (key[KEY_X]) ) { ayuda_visible=false; clear_to_color(tapiz, color_tapiz);}
		// ***********************************************************************************
		
		// Gestin de eventos **********BOTON ABOUT ****************************************
		if ( maus.enboton( ptr_b_about ) ) { ptr_b_about->enfocado=true; ptr_b_about->colorfondo=C.WHITE;
		}	
		else { ptr_b_about->enfocado=false; ptr_b_about->colorfondo=C.AMARILLO_GOLD; }


		 // ***********************************************************************************
		
		// Gestin de eventos **********BOTON 1Player ****************************************
		
		if ( maus.enboton( ptr_b_1player ) ) { ptr_b_1player->enfocado=true; ptr_b_1player->colorfondo=C.WHITE; 
			
		ptr_b_1player->pon();}	
		else { ptr_b_1player->enfocado=false; ptr_b_1player->colorfondo=C.AMARILLO_GOLD;
			
		ptr_b_1player->pon();}

		if( maus.clic( ptr_b_1player)  ) {
			
			UnPlayer=true; 
			ptr_tablero->limpiacuadros(); 
			ptr_player1->fichas=0; ptr_player2->fichas=0;gameover=false;

			}



		  // Gestin de eventos **********BOTON 2Player ****************************************
		
		if ( maus.enboton( ptr_b_2player ) ) { ptr_b_2player->enfocado=true; ptr_b_2player->colorfondo=C.WHITE; 
			
			ptr_b_2player->pon(); }	
		else { ptr_b_2player->enfocado=false; ptr_b_2player->colorfondo=C.AMARILLO_GOLD;
			
			ptr_b_2player->pon(); }

		if( maus.clic( ptr_b_2player)  ) {
			
			UnPlayer=false; 
			ptr_tablero->limpiacuadros(); 
			ptr_player1->fichas=0; ptr_player2->fichas=0;gameover=false;

			}

		// ************************************************************************************







		//bool llamada=false;

		b_about.pon(); if(maus.clic( ptr_b_about )) {  llamada=true; pon_about(0,-1);   } else { ; }


		if( llamada ) {
			
			if (maus.en_x2()){  pon_about( C.ROJO_RED, C.WHITE); }else{ pon_about(0,-1); }

			if ( (llamada && maus.en_x2() && maus.boton_iz) || (key[KEY_X]) ) { 
				
				llamada=false; clear_to_color(tapiz, color_tapiz);}
			  			 			
			}

		
		

		// ************************************************************************************

		


		// Gestin de eventos **********BOTON CLEAR ****************************************
		if ( maus.enboton( ptr_b_limpia ) ) { ptr_b_limpia->enfocado=true; ptr_b_limpia->colorfondo=C.WHITE; 	}	
		else { ptr_b_limpia->enfocado=false; ptr_b_limpia->colorfondo=C.AMARILLO_GOLD; }

		b_limpia.pon(); if(maus.clic( ptr_b_limpia ) ) { 
			
		ptr_tablero->limpiacuadros(); ptr_player1->fichas=0; ptr_player2->fichas=0;gameover=false; 
			
			}

		// ***********************************************************************************

		// FUNCIONES DE VOLCADO DE PANTALLA Y LIBERACIN DE MEMORIA *************************************

		// Copia de bfferes de pantalla:

		// tablero -> tapiz -> screen ; panel1 -> screen ; panel2 -> screen

		vsync();	// De tablero a tapiz
		blit( tablero, tapiz, 0,0,(tapiz->w - tablero->w )/2,( tapiz->h - tablero->h )/2, tablero->w, tablero->h );
		//clear_to_color( tablero, color_tablero); // Actualiza el tablero de juego
		//ayuda-------------------------------------------
		//blit( bmp_help,tapiz,0,0,0,0,bmp_help->w, bmp_help->h);
		if(ayuda_visible) {	pon_ayuda(0,-1);   

			if ( maus.en_x() ) pon_ayuda( C.ROJO_RED, C.WHITE );
			
			}
		//------------------------------------------------
		vsync(); // De panel1 a buffermouse
		blit( panel1,buffermouse,0,0,0,0,panel1->w, panel1->h );
		vsync(); // De tapiz a buffermouse
		blit( tapiz,buffermouse,0,0,0,panel1->h,tapiz->w,tapiz->h );
		vsync(); // De panel2 a buffermouse
		blit( panel2,buffermouse,0,0,0,SCREEN_H-panel2->h, panel2->w, panel2->h );
		
	    // Copia buffermouse en la pantalla
		maus.esconde();
		blit( buffermouse, screen, 0,0,0,0, buffermouse->w, buffermouse->h ); 
		maus.reaparece();
		vsync();
		clear_to_color(panel1, color_panel1);
		// ---------------------------------------------------------------------------------------------------------
		}
		//readkey();
		
		// LIBERA MEMORIA ------------------------------------------------------

		ptr_maus=NULL;
		ptr_b_exit=NULL;
		ptr_b_about=NULL;
		ptr_b_limpia=NULL;
		ptr_b_ayuda=NULL;
		ptr_b_1player=NULL;
		ptr_b_2player=NULL;
		destroy_bitmap( bmp_help );
		destroy_bitmap(bmp_gameover);
		destroy_bitmap( bmp_about );
		destroy_bitmap( bmp_presenta );
		eltablero.liberamemoria();
		ptr_player1=NULL; ptr_player2=NULL;
		ptr_tablero=NULL;
		destroy_bitmap(tablero);
		destroy_bitmap(tapiz);	
		destroy_bitmap(panel1); 	
		destroy_bitmap(panel2);
		destroy_bitmap(buffermouse);

	return EXIT_SUCCESS;

} END_OF_MAIN()







