// Funciones de allegro
// Organizacin de la interface:
/*
	- Dividimos la pantalla en 3 zonas:
		Superior -> Panel 1
		Central -> Tapiz
		Inferior -> Panel 2

		A su vez el Tapiz incluye al Tablero en donde se desarrolla el juego.

		Dimensiones -> Algoritmo de Euclides + text_height
		
*/

PALETTE pal;

BITMAP * panel1;

BITMAP * tapiz;

BITMAP * bmp_help;

BITMAP * bmp_gameover;

BITMAP * bmp_about;

BITMAP * bmp_presenta; // amor

BITMAP * tablero;

BITMAP * panel2;

BITMAP * buffermouse;

int _hr, _vr; // resolucin de pantalla (_hr, _vr)

// Altura de los paneles basadas en la altura bsica del texto
#define altura_lin_texto (text_height(font))
#define c_texto(x)  (x*text_length( font, "A" )) 
#define at (3+altura_lin_texto)
#define num_lineas_texto_panel1 (10)
#define num_lineas_texto_panel2 (10)
#define altura_panel1 ( (altura_lin_texto)*(num_lineas_texto_panel1) )
#define altura_panel2 ( (altura_lin_texto)*(num_lineas_texto_panel2) )
#define _at(x)  ( (x*at) )
// El punto centro del tapiz:
#define CX  ( ( tapiz->w )/2 )
#define CY  ( ( tapiz->h )/2 ) 

#define leuclides(x,y) mcd(x, y) // Algoritmo de Euclides

#define margen_v (5*at)

#define tablero_h (tapiz->h - 2*margen_v)

#define tablero_w tablero_h

#define NQ 3

#define lado_q    ( (int) (tablero_w/NQ) )

void set_allegro(){

	allegro_init();	install_timer(); install_mouse();

	install_keyboard(); clear_keybuf(); 	set_color_depth(16);

	if(  get_desktop_resolution(&_hr, &_vr) == 0 ) { 
	
		set_gfx_mode ( GFX_AUTODETECT , _hr , _vr , 0 , 0 );

	}

	clear_bitmap(screen);
	
	tapiz=create_bitmap(SCREEN_W, SCREEN_H-altura_panel1-altura_panel2);
	
	panel1=create_bitmap(SCREEN_W, altura_panel1);

	panel2=create_bitmap(SCREEN_W, altura_panel2);

	tablero = create_bitmap(tablero_w , tablero_h);

	bmp_help=create_bitmap(   (tapiz->w-tablero->w)/2, tapiz->h );

	bmp_gameover=create_bitmap(   (tapiz->w-tablero->w)/2, tapiz->h );	
	
	bmp_about=create_bitmap(   (tapiz->w-tablero->w)/2, tapiz->h );	

	bmp_presenta=create_bitmap( SCREEN_W, SCREEN_H );
	
	buffermouse = create_bitmap( screen->w, screen->h );

	clear_bitmap( buffermouse );

	clear_bitmap( bmp_help );

	clear_bitmap( bmp_about );

}

// Dedicado a Britta. Yuhu!



