/*******************************************************************************
*******************************  NIBBLES 2002  *********************************
****************************   BY JESSE CORRINGTON  ****************************
*******************************************************************************/


#include <allegro.h>
#include <fstream.h>
#include <string.h>
#include <time.h>

const int scrx = 800;
const int scry = 600;

int food_x, food_y, food_status;

// all of the variables used for the snake
int snake_x[200], snake_y[200];
int snake_dir, snake_size;

int high_score[10];
char high_score_name[10][30];
char player_name[30];

clock_t time1,time2;

//functions
void add_snake_piece();
void collision_detection();
void determine_food_location();
void game_loop();
void game_over();
void initialize();
void keyboard_input();
void load_high_scores();
void main_menu();
void update_screen();
void sort_high_scores();
void print_high_scores();
void move_snake();

BITMAP *buffer;
BITMAP *nibbles_title;
BITMAP *snake;
BITMAP *new_game;
BITMAP *high_scores;
BITMAP *quit;
BITMAP *game_overbmp;
BITMAP *high_scores_title;

//**************************************************************************
//								INITIALIZE 
//**************************************************************************
//**************************************************************************

void initialize(void)
{
	food_x=0;
	food_y=0;
	food_status = 0;

	snake_x[0]=60;
	snake_y[0]=200;
	snake_dir=4;
	snake_size=0;

	return;
}

//**************************************************************************
//						UPDATE SCREEN
//**************************************************************************
//**************************************************************************

void update_screen(void)    
{
	int i;

	//draw background
	floodfill(buffer,1,1,makecol(100,100,100));

	//****draw boarder
	line(buffer, 29, 29, 29, SCREEN_H-29, makecol24(0,0,255));
	line(buffer, 29, 29, SCREEN_W-29, 29, makecol24(0,0,255));
	line(buffer, SCREEN_W-29, SCREEN_H-29, 29, SCREEN_H-29, makecol24(0,0,255));
	line(buffer, SCREEN_W-29, SCREEN_H-29, SCREEN_W-29, 29, makecol24(0,0,255));
	floodfill(buffer, 1, 1, makecol(0,0,100));

	//****print title and score
	textout_centre(buffer, font, "NIBBLES", SCREEN_W/2, 15, makecol(255,255,255));
	textprintf_centre(buffer,font,SCREEN_W/2,SCREEN_H-20,makecol24(255,255,255),"SCORE %d",snake_size+1);

	//****draw food
	circlefill(buffer,food_x,food_y,5,makecol24(210, 210, 0));
     
	//draw snake head
	rectfill(buffer, snake_x[0]-9, snake_y[0]-9, snake_x[0]+9, snake_y[0]+9, makecol24(180,20,20));

	//******draw snake body
	for(i=1;i<=snake_size;i++) 
	{  
		rectfill(buffer, snake_x[i]-9, snake_y[i]-9, snake_x[i]+9, snake_y[i]+9, makecol24(20,180,20));
	}

	vsync();
	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

	return;
}

//**************************************************************************
//					ADD THE NEW SNAKE PIECE TO THE END
//**************************************************************************
//**************************************************************************

void add_snake_piece(void)
{
	if (snake_dir==1)
	{
		snake_x[snake_size]=snake_x[snake_size-1]+20;
		snake_y[snake_size]=snake_y[snake_size-1];
	}


	if (snake_dir==2)
	{
		snake_x[snake_size]=snake_x[snake_size-1];
		snake_y[snake_size]=snake_y[snake_size-1]+20;
	}


	if (snake_dir==3)
	{
		snake_x[snake_size]=snake_x[snake_size-1]-20;
		snake_y[snake_size]=snake_y[snake_size-1];
	}


	if (snake_dir==4)
	{
		snake_x[snake_size]=snake_x[snake_size-1];
		snake_y[snake_size]=snake_y[snake_size-1]-20;
	}

	return;
}

//**************************************************************************
//							 CHECK FOR COLLISONS
//**************************************************************************
//**************************************************************************

void collision_detection(void)
{
	int i;

	//out of bounds detection
	if (snake_x[0]<40)			game_over();
	if (snake_x[0]>SCREEN_W-40)	game_over();
	if (snake_y[0]<40)			game_over();
	if (snake_y[0]>SCREEN_H-40)	game_over();

	//do snake to snake collison detection
	for (i=1;i<=snake_size;i++) {
		if (snake_x[0]==snake_x[i] && snake_y[0]==snake_y[i])
		{
			game_over();
		}
	}

	//food eaten collision
	if (snake_x[0]==food_x  && snake_y[0]==food_y) 
	{
		food_status=0;
		snake_size++;
		add_snake_piece();
	}
	return;
}

//**************************************************************************
//                         KEYBOARD INPUT
//**************************************************************************
//**************************************************************************

void keyboard_input(void)
{	
	if(key[KEY_UP])		snake_dir=2;
	if(key[KEY_DOWN])	snake_dir=4;
	if(key[KEY_LEFT])	snake_dir=1;
	if(key[KEY_RIGHT])	snake_dir=3;

	if(key[KEY_ESC])	main_menu();


	clear_keybuf();

return;
}

//***************************************************************************
//								MOVE SNAKE
//**************************************************************************
//**************************************************************************

void move_snake(void)
{

	int i;

		//update the snakes position
	for(i=snake_size;i>=1;i--)   
	{                   
		snake_x[i]=snake_x[i-1];
		snake_y[i]=snake_y[i-1];
	}
		switch(snake_dir)
	{
		case 1:  snake_x[0]-=20; break;
		case 2:  snake_y[0]-=20; break;
		case 3:  snake_x[0]+=20; break;
		case 4:  snake_y[0]+=20; break;	
	}


	return;
}

//***************************************************************************
//								GAME OVER
//**************************************************************************
//**************************************************************************

void game_over(void)
{
	clear_keybuf();
	clear(screen);

	blit(game_overbmp, screen, 0, 0, (SCREEN_W/2)-(.5*game_overbmp->w), 40,game_overbmp->w,game_overbmp->h);
	textprintf_centre(screen,font,SCREEN_W/2,200,makecol24(255,255,255),"YOU SCORED %d",snake_size+1);
	textprintf_centre(screen,font,SCREEN_W/2, 400, makecol24(255,255,255), "PRESS ANY KEY TO CONTINUE");
	
	clear_keybuf();
	while(!keypressed());
	sort_high_scores();
	print_high_scores();

	return;
}

//***************************************************************************
//                  DETERMINE THE LOCATION OF THE FOOD
//**************************************************************************
//**************************************************************************

void determine_food_location(void)
{
	int i;
	int f=1;

	while (f==1) 
	{
		food_x=20*((rand() % (SCREEN_W - 80)/20) + 2);
		food_y=20*((rand() % (SCREEN_H - 80)/20) + 2);

		for (i=0;i<=snake_size;i++) 
		{
			if (food_x == snake_x[i] && food_y == snake_y[i]) f=1;
				else  f=0;
		}
	}
	food_status=1;

	return;
}

//**************************************************************************
//								MAIN GAME LOOP
//**************************************************************************
//**************************************************************************

void game_loop(void)
{
	time1 = clock();
	while (1) 
	{
		clear(buffer);
		keyboard_input();
		if (food_status==0) determine_food_location();
		update_screen();
		collision_detection();

		time2 = clock();
		if (time2-time1>100)
		{
			move_snake();
			time1 = clock();
		}	  
	}
	return;
}

//**************************************************************************
//									LOAD HIGH SCORES
//**************************************************************************
//**************************************************************************

void load_high_scores(void)
{
	int i;

	ifstream in("scores.txt");

	for (i=0; i<10; i++)
	{
		in >> high_score[i];
		//in >> high_score_name[i];
	}

	in.close();

	return;
}

//**************************************************************************
//									SAVE HIGH SCORES
//**************************************************************************
//**************************************************************************

void save_high_scores(void)
{
	int i;

	ofstream out("scores.txt");

	for (i=0; i<10; i++)
	{
		out << high_score[i] << " ";
		//out << high_score_name[i];
		out << endl;
	}

	out.close();

	return;
}

//**************************************************************************
//									PRINT HIGH SCORES
//**************************************************************************
//**************************************************************************

void print_high_scores(void)
{
	int i;
	
	clear(screen);
	blit(high_scores_title, screen, 0, 0, (SCREEN_W/2)-(.5*high_scores_title->w), 40,high_scores_title->w,high_scores_title->h);

	for (i=0; i<10; i++)
	{
		textprintf(screen,font,SCREEN_W/2-40,i*20+160,makecol24(255,255,255),"%d        %d",i+1,high_score[i]);
	}
	textprintf_centre(screen,font,SCREEN_W/2, 400, makecol24(255,255,255), "PRESS ANY KEY TO CONTINUE");

	clear_keybuf();
	while(!keypressed());
	main_menu();
	return;
}


//**************************************************************************
//									SORT HIGH SCORES
//**************************************************************************
//**************************************************************************

void sort_high_scores(void)
{
	int i;
	int score = snake_size + 1;
	int score_rank = -1;


	for (i=0;i<=9;i++)
	{
		if (score >= high_score[i])
		{
			score_rank = i;
			break;
		}
	}
	if (score_rank >= 0) 
	{
		for (i=9;i>score_rank;i--)
		{
			high_score[i] = high_score[i-1];
			strncpy(high_score_name[i], high_score_name[i-1], 30);
		} 
	high_score[score_rank] = score;
//	strncpy(high_score_name[score_rank], player_name, 30);


	}
	return;
}


//**************************************************************************
//									SHUTDOWN
//**************************************************************************
//**************************************************************************

void shut_down(void)
{
	save_high_scores();
	destroy_bitmap(buffer);
	exit(0);
	return;
}

//**************************************************************************
//									MAIN MENU
//**************************************************************************
//**************************************************************************

void main_menu(void)
{
	int i;
	int choice=1;
	int keyhit;
	int selector_pos=205;
	for (i=0;i<10000000;i++);
	
	time1 = clock();
	while(key[KEY_ENTER]==0)
	{
		clear_keybuf();
		clear(buffer);

		blit(nibbles_title, buffer, 0, 0 , (SCREEN_W/2)-(.5*nibbles_title->w), 20,nibbles_title->w, nibbles_title->h);
		blit(new_game, buffer, 0, 0, SCREEN_W/2-80, 200,new_game->w,new_game->h);
		blit(high_scores, buffer, 0, 0, SCREEN_W/2-80, 240,high_scores->w,high_scores->h);
		blit(quit, buffer, 0, 0, SCREEN_W/2-80, 280,quit->w,quit->h);
		blit(snake, buffer, 0, 0, (SCREEN_W/2)-170, selector_pos,snake->w,snake->h);

		if (key[KEY_UP])	keyhit = 2;
		if (key[KEY_DOWN])	keyhit = 1;

		if (key[KEY_ESC])
		{
			choice = 3; 
			break;
		}

		vsync(); 
		blit(buffer, screen, 0, 0, 0, 0,SCREEN_W, SCREEN_H);
		
		time2 = clock();

		if (time2-time1 > 250)
		{
			if (keyhit == 1 && choice < 3)
			{
				choice++;
				selector_pos+=40;	
			}
			if (keyhit == 2 && choice > 1)
			{
				choice--;
				selector_pos-=40;
			}
			time1 = clock();
			keyhit = 0;
		}

	}


	switch (choice)
	{
		case 1: initialize(), game_loop(); break;
		case 2: print_high_scores(); break;
		case 3: shut_down(); break;
	}
	
	return;
}

//**************************************************************************
//								MAIN
//**************************************************************************
//**************************************************************************

int main()
{

	allegro_init();
	install_timer();
	install_keyboard();
	text_mode(-1);

	srand ((unsigned)time (NULL)); 

	set_color_depth(24);
	set_gfx_mode(GFX_AUTODETECT, scrx, scry, 0, 0); 

	buffer = create_bitmap(SCREEN_W, SCREEN_H);
	clear(buffer);

	nibbles_title	=	load_bmp("nibblestitle.bmp", 0);
	snake			=	load_bmp("snake.bmp",0);
	new_game		=	load_bmp("newgame.bmp",0);
	high_scores		=	load_bmp("highscores.bmp",0);
	quit			=	load_bmp("quit.bmp",0);
	game_overbmp	=	load_bmp("gameover.bmp",0);
	high_scores_title = load_bmp("highscores2.bmp",0);

	load_high_scores();
	main_menu();

	return 0;
}
END_OF_MAIN()
