#include <allegro.h>
#include <fstream.h>
#include <time.h>
#include "data.h"
#include "breakout.h"
#include "map.h"
#include "ball.h"
#include "Menus.h"

//function prototypes
int BBCD(class_bounding_box b1, class_bounding_box b2);
void paddle_bounce();
void block_collision_detection();
void initialize();
void game_loop();
int main_menu();
void load_level();
void update_objects();

bool block_hit = false;
bool bounced[4];
int current_level;
int score;
int lives;

time_t time1, time2;
int fps;
int elapsed_frames;
int elapsed_time;

int logic_counter;

void update_logic_counter()
{
	logic_counter++;
}

int main()
{
	int i;

	int selection = 0;

	initialize();
	
	selection = main_menu();
	while (selection != SEL_EXIT)
	{
		if (selection == SEL_HIGH_SCORES);
		else game_loop();
		selection = main_menu();
	}

	return 0;
}
END_OF_MAIN();


void game_loop()
{
	LOCK_VARIABLE(logic_counter);
	LOCK_FUNCTION(update_logic_counter);
	install_int_ex(update_logic_counter, BPS_TO_TIMER(140));

	int i;
	bool playing_game = true;
	
	current_level = 0;
	lives = 3;

	load_level();	//load the level variables and the map

	for (i = 0;i < 10000000; i++);

	time1 = clock();
	//start the main game loop
	while (playing_game)
	{
		//check for win or loss conditions
		if (map.blocks == 0)	
		{
			beat_level_menu(current_level);
			current_level++;
			load_level();
		}

		if (ball.y >= SCRY)	
		{
			lives--;
			lost_life_menu();
			ball.create(paddle.x + paddle.width/2, paddle.y - ball.height/2, xball, 4, 4);
			ball.bounding_box.set(ball.y-ball.height/2, ball.y+ball.height/2, ball.x-ball.width/2, ball.x+ball.width/2);
			ball.x_speed = sqrt(0);
			ball.y_speed = sqrt(0);
			ball.speed = 0;
			ball.moving = false;
			for (i = 0;i < 10000000; i++); 
		}

		if (lives < 1)		
		{
			game_over_menu();
			playing_game = false;
		}
		
		//input section
		if ((mouse_b & 1) && ball.speed == 0)
		{
				ball.x_speed = 0;
				ball.y_speed = -3;
				ball.speed = 3;
				ball.moving = true;	
		}


		if (key[KEY_ESC]) playing_game = false;	

		//update the paddle location by using the mouse_x
		paddle.x = mouse_x;
		if (paddle.x > SCRX - paddle.width) paddle.x = SCRX-paddle.width;
		paddle.bounding_box.set(paddle.y, paddle.y, paddle.x, paddle.x + paddle.width);

		if (!ball.moving) ball.x = paddle.x + paddle.width/2;

		block_hit = false;
		bounced[TOP] = false;
		bounced[BOTTOM] = false;
		bounced[LEFT] = false;
		bounced[RIGHT] = false;

		while (logic_counter) 
		{
			update_objects();
			logic_counter--;
		}
		 
		//draw graphics
		clear(buffer);
		map.draw();
		paddle.draw();
		ball.draw();

		textprintf(buffer, font, 2, 0, makecol(255,255,255), "Score %d", score);
		textprintf(buffer, font, 80, 0, makecol(255,255,255), "level %d", current_level + 1);
		textprintf(buffer, font, 180, 0, makecol(255,255,255), "lives %d", lives);
		textprintf(buffer, font, 280, 0, makecol(255,255,255), "blocks remaining %d", map.blocks);
		
		textprintf(buffer, font, 100, 20, makecol(255,255,255), "FPS %d", fps);
		textprintf(buffer, font, 300, 20, makecol(255,255,255), "elapsed game time %d", elapsed_time);


		//copy the buffer to the screen
		//vsync();
		blit(buffer, screen, 0,0,0,0,SCRX,SCRY);

		time2 = clock();
		elapsed_frames++;
		if (time2-time1 >= 1000)
		{
			fps = elapsed_frames;
			elapsed_frames = 0;
			time1 = clock();
			elapsed_time++;
		}
	}

	return;
}


void paddle_bounce()
{
	//first find the new x speed
	float amnt_to_add = .24;
	int dist_from_mid;
	int paddle_center = paddle.x + paddle.width/2;
	dist_from_mid = paddle_center - ball.x;
	dist_from_mid *= -1;
	ball.x_speed = amnt_to_add*dist_from_mid;
	ball.y_speed *= -1;

	//next reduce the x and y speeds so the ball doesn't speed up or slow down
	float distance;
	if (ball.x_speed != 0)
	{
		distance = sqrt(ball.y_speed*ball.y_speed + ball.x_speed*ball.x_speed);
		while (distance > ball.speed + .1 || distance < ball.speed - .1) 
		{
			if (distance > ball.speed + .1)
			{
				ball.x_speed /= 1.01;
				ball.y_speed /= 1.01;
			}
			if (distance < ball.speed - .1)
			{
				ball.x_speed *= 1.01;
				ball.y_speed *= 1.01;
			}
			distance = sqrt(ball.y_speed*ball.y_speed + ball.x_speed*ball.x_speed);
		}
	}
	else ball.y_speed = -ball.speed;
	play_sample ((SAMPLE*)datafile[boing].dat, 255, 128, 1000, 0);
	return;
}

void block_collision_detection()
{
	int x,y;
	for (x=0; x<SCRX/BLOCK_W; x++)
	{
		for (y=0; y<SCRY/BLOCK_H-2; y++)
		{
			if (!block_hit) 
			{
				if (map.block[x][y].active && BBCD(ball.bounding_box, map.block[x][y].bounding_box))
				{
					//first check to see which side(s) the ball collided with
					if (ball.bounding_box.right == map.block[x][y].bounding_box.left) bounced[LEFT] = true;
					if (ball.bounding_box.left == map.block[x][y].bounding_box.right) bounced[RIGHT] = true;
					if (ball.bounding_box.bottom == map.block[x][y].bounding_box.top) bounced[TOP] = true;
					if (ball.bounding_box.top == map.block[x][y].bounding_box.bottom) bounced[BOTTOM] = true;

					//test to see if it hit a corner
					if ((bounced[TOP] && bounced[LEFT]) || (bounced[TOP] && bounced[RIGHT]) || (bounced[BOTTOM] && bounced[LEFT]) || (bounced[BOTTOM] && bounced[RIGHT]))
					{
						ball.bounce(CORNER, xblip);
						block_hit = true;
					}
			
					//if the ball didn't hit a corner just make it bounce normaly
					if (!block_hit)
					{
						if (bounced[LEFT])		ball.bounce(LEFT, xblip);
						if (bounced[RIGHT])		ball.bounce(RIGHT, xblip);
						if (bounced[TOP])		ball.bounce(TOP, xblip);
						if (bounced[BOTTOM])	ball.bounce(BOTTOM, xblip);
					}

					map.block[x][y].del();
					block_hit = true;
					score += 10;
					map.blocks--;
				}
			}
		}
	}
	return;
}

void load_level()
{
	//initialize some objects
	paddle.create(0, 570, PADDLE, 100, 15);
	ball.create(0+paddle.width/2, paddle.y - ball.height/2, xball, 4, 4);
	ball.bounding_box.set(ball.y-ball.height/2, ball.y+ball.height/2, ball.x-ball.width/2, ball.x+ball.width/2);
	ball.x_speed = sqrt(0);
	ball.y_speed = sqrt(0);
	ball.speed = 0;
	ball.moving = false;

	//load the map
	map.load(LEVEL[current_level]);

	return;
}

void update_objects()
{
	int i;
	for (i =0; i < ball.speed; i++)
	{
		//block collision detection
		if (!block_hit) block_collision_detection();
				
		//paddle collision detection
		if (ball.bounding_box.bottom == paddle.bounding_box.top && BBCD(ball.bounding_box, paddle.bounding_box))	paddle_bounce();

		//wall collision detection
		if (ball.x >= SCRX - ball.width/2)	ball.bounce(LEFT, xbassdrum);
		if (ball.x <= 0 + ball.width/2)		ball.bounce(RIGHT, xbassdrum);
		if (ball.y <= 0 + ball.width/2)		ball.bounce(BOTTOM, xbassdrum);

		//incriment the x and y values of the ball and change the bounding box
		ball.x += ball.x_speed/ball.speed;
		ball.y += ball.y_speed/ball.speed;
		ball.bounding_box.set(ball.y-ball.height/2, ball.y+ball.height/2, ball.x-ball.width/2, ball.x+ball.width/2);
	}
	return;
}