#ifndef BREAKOUT_H
#define BREAKOUT_H

#include "base.h"

#define SCRX	800
#define SCRY	600
#define BLOCK_W 40
#define BLOCK_H 20
#define TOP		0
#define BOTTOM	1
#define LEFT	2
#define RIGHT	3
#define CORNER	4

BITMAP *buffer;
DATAFILE *datafile;

class class_bounding_box
{
public:
	int top,bottom,left,right;

	void set(int t, int b, int l, int r)
	{
		top = t;
		bottom = b;
		left = l;
		right = r;
		return;
	}		
};

class class_object
{
public:
	float x, y;
	int height, width;
	int image;
	bool active;
	class_bounding_box bounding_box;

	void create(int c_x, int c_y, int c_image, int c_width, int c_height)
	{
		x = c_x;
		y = c_y;
		image = c_image;
		width = c_width;
		height = c_height;
		active = true;
		return;
	}

	void del()
	{
		x = 0; y = 0;
		image = 0;
		active = false;
		return;
	}

	virtual void draw()
	{
		if (active) masked_blit((BITMAP*)datafile[image].dat, buffer, 0, 0, x - width/2, y - height/2,width, height); 
		return;
	}
};

class class_block : public class_object
{
public:
	bool solid;
	int energy;
	void draw()
	{
		if (active) masked_blit((BITMAP*)datafile[image].dat, buffer, 0, 0, x, y, width, height); 
		return;
	}
	void create(int c_x, int c_y, int c_image, int c_width, int c_height, int c_energy, bool c_solid)
	{
		x = c_x;
		y = c_y;
		image = c_image;
		width = c_width;
		height = c_height;
		active = true;
		energy = c_energy;
		solid = c_solid;
		return;
	}
};


class class_paddle :public class_object
{
public:
	void draw()
	{
		masked_blit((BITMAP*)datafile[image].dat, buffer, 0,0, x, y, width, height);
	}
} paddle;


void initialize()
{
	//set up allegro
	allegro_init();
	install_keyboard();
	install_mouse();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);

	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT, SCRX, SCRY, 0, 0);
	text_mode(-1); 
	
	// create the buffer
	buffer = create_bitmap(SCRX, SCRY);

	//load the data file
	datafile = load_datafile("data.dat");
	if (!datafile) exit(-1);

	//randomize the timer for random numbers
	srand ((unsigned)time (NULL));

	return;
}

int BBCD(class_bounding_box b1, class_bounding_box b2) 
{ 
	if(b1.left > b2.right) return 0; 
	if(b1.right < b2.left) return 0; 
	if(b1.top > b2.bottom) return 0; 
	if(b1.bottom < b2.top) return 0; 
	return 1; 
}

#endif