#ifndef _GAME_H
#define _GAME_H

#include <stdio.h>
#include <allegro.h>
#include "main.h"
#include "piece.h"
#include "board.h"
#include "type4_pieces.h"
#include "type5_pieces.h"


class game
	{
	public:
	game();
	~game();
	void display();
	void display_menu(int select);
	void game_step();
	void reset();
	void change_pause_state();
	int get_level();
	bool try_move(int dx, int dy);
	void rotate_current_piece();
	void show_keys();
	void load_high();
	void save_high();
	void update_high();
	void display_info();
	void set_type(int t);
	void load_pieces();

	private:
	bool is_overlap(piece *p);
	board b;
	piece *current_piece, *next_piece;
	int score, lines, pieces, level, high_score, high_lines, high_pieces, gtype;
	bool paused, game_over;
	type4_pieces cpt4;
	type5_pieces cpt5;
	//text ascii_table;
	};

#endif
