#include "board.h"

board::board()
	{
	reset();
	}

board::~board()
	{
	this->clear();
	}

void board::clear()
	{
	for(int i=0; i<width; i++)
		{
		grid[i].clear();
		}
	grid.clear();
	width=height=0;
	}

void board::reset()
	{
	width=14;
	height=30;
	grid.resize(width);
	for(int i=0; i<width; i++)
		{
		grid[i].resize(height);
		for(int j=0; j<height; j++)
			{
			if( i == 0 || i == 1 || i == width-1 || i == width-2 || j == height-1 || j == height-2 ) grid[i][j]=2;
			else grid[i][j]=0;
			}
		}
	}

void board::display_board()
	{
	//SDL_Rect dest;
	//FILE *fp;
	int v;
	//fp=fopen("output.txt","w");
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			v=grid[i][j];
			//fprintf(fp,"%d\n",v);
			if( v ) 
				{
				/*dest.x=i*UNIT_BLOCK_WIDTH;
			    dest.y=j*UNIT_BLOCK_HEIGHT;
				dest.w=UNIT_BLOCK_WIDTH;
				dest.h=UNIT_BLOCK_HEIGHT;
				SDL_BlitSurface(unit_block[v+1],NULL,double_buffer,&dest);*/
                blit(unit_block[v+1],double_buffer,0,0,i*UNIT_BLOCK_WIDTH,j*UNIT_BLOCK_HEIGHT,UNIT_BLOCK_HEIGHT,UNIT_BLOCK_HEIGHT);
				}
			}
		}
	//fclose(fp);
	}

int board::remove_lines()
	{
	int line_number=height-3, counter=0;
	while( line_number > 0 )
		{
		if( check_line(line_number) ) 
			{
			counter++;
			remove_line(line_number);
			}
		else line_number--;
		}
	return counter;
	}

void board::remove_line(int num)
	{
	for(int i=1; i<width-1; i++)
		grid[i][num]=0;
	for(int j=num-1; j>0; j--)
		{
		for(int k=1; k<width-1; k++)
			grid[k][j+1]=grid[k][j];
		}
	}

bool board::check_line(int num)
	{
	bool result=true;
	for(int i=1; i<width-1; i++)
		if( grid[i][num] == 0 ) result=false;
	return result;
	}

int board::get_board_spot(int x, int y)
	{
	return grid[x][y];
	}

int board::get_width()
	{
	return width;
	}

int board::get_height()
	{
	return height;
	}

void board::drop_piece(piece p)
	{
	for(int i=0; i<p.get_width(); i++)
		{
		for(int j=0; j<p.get_height(); j++)
			{
			if( p.get_grid_spot(i,j) != 0 ) grid[p.get_x()+i][p.get_y()+j]=p.get_value();
			}
		}
	}

bool board::is_game_over()
	{
	bool result=false;
	for(int i=2; i<width-2; i++)
		{
		if( grid[i][1] != 0 ) result=true;
		}
	return result;
	}
