#include "piece.h"

piece::piece()
	{
	width=PIECE_GRID_SIZE;
	height=PIECE_GRID_SIZE;
	reset();
	}

piece::~piece()
	{
	board_x=board_y=width=height=0;
	}

void piece::display_on_board()
	{
	//SDL_Rect dest;
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			if( grid[i][j] ) 
				{
				/*dest.x=(board_x+i)*UNIT_BLOCK_WIDTH;
			    dest.y=(board_y+j)*UNIT_BLOCK_HEIGHT;
				dest.w=UNIT_BLOCK_WIDTH;
				dest.h=UNIT_BLOCK_HEIGHT;
				if( value <= 37 && value >= 2 ) SDL_BlitSurface(unit_block[value],NULL,double_buffer,&dest);*/
                if( value <= 37 && value >= 2 ) blit(unit_block[value],double_buffer,0,0,(board_x+i)*UNIT_BLOCK_WIDTH,(board_y+j)*UNIT_BLOCK_HEIGHT,UNIT_BLOCK_WIDTH,UNIT_BLOCK_HEIGHT);
				}
			}
		}
	}

void piece::display(int x, int y)
	{
	//SDL_Rect dest;
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			if( grid[i][j] ) 
				{
				/*dest.x=x+(i*UNIT_BLOCK_WIDTH);
			    dest.y=y+(j*UNIT_BLOCK_HEIGHT);
				dest.w=UNIT_BLOCK_WIDTH;
				dest.h=UNIT_BLOCK_HEIGHT;
				if( value <= 37 && value >= 2 ) SDL_BlitSurface(unit_block[value],NULL,double_buffer,&dest);*/
                if( value <= 37 && value >= 2 ) blit(unit_block[value],double_buffer,0,0,x+(i*UNIT_BLOCK_WIDTH),y+(j*UNIT_BLOCK_HEIGHT),UNIT_BLOCK_WIDTH,UNIT_BLOCK_HEIGHT);
                }
			}
		}
	}

void piece::set_color(int color)
	{
	value=color;
	}

void piece::reverse_rotate()
	{
	int temp[PIECE_GRID_SIZE][PIECE_GRID_SIZE];
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			temp[width-1-i][j]=grid[j][i];
			}
		}
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			grid[i][j]=temp[i][j];
			}
		}
	}

void piece::rotate()
	{
	int temp[PIECE_GRID_SIZE][PIECE_GRID_SIZE];
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			temp[i][width-1-j]=grid[j][i];
			}
		}
	for(int i=0; i<width; i++)
		{
		for(int j=0; j<height; j++)
			{
			grid[i][j]=temp[i][j];
			}
		}
	}

void piece::move(int dx, int dy)
	{
	board_x+=dx;
	board_y+=dy;
	}

int piece::get_grid_spot(int x, int y)
	{
	if( x >= 0 && x < width && y >= 0 && y < height ) return grid[x][y];
	else return FAILURE;
	}

void piece::set_grid_spot(int x, int y, int value)
	{
	if( x >= 0 && x < width && y >= 0 && y < height ) grid[x][y]=value;
	}

int piece::get_width()
	{
	return width;
	}

int piece::get_height()
	{
	return height;
	}

int piece::get_x()
	{
	return board_x;
	}

int piece::get_y()
	{
	return board_y;
	}

int piece::get_value()
	{
	return value;
	}

void piece::reset()
	{
	board_x=5;
	board_y=0;
	}
