#include "main.h"
#include "piece.h"
#include "board.h"
#include "game.h"

BITMAP *double_buffer;
BITMAP *unit_block[NUM_OF_BLOCKS];
BITMAP *klogo;
game g;
//FILE *fp;

void free_all()
	{
	for(int i=0; i<NUM_OF_BLOCKS; i++)
		{
		if( unit_block[i] ) destroy_bitmap(unit_block[i]);
		}
	if( klogo ) destroy_bitmap(klogo);
	}

int load_sprites()
	{
	int result=SUCCESS;
	PALETTE pal;
	//unsigned int value;

	/*characters=SDL_LoadBMP("ascii8.bmp");
	if( !characters ) result=FAILURE;
	else
		{
		value=SDL_MapRGB(characters->format,0,0,0);
		SDL_SetColorKey(characters,SDL_SRCCOLORKEY|SDL_RLEACCEL,value);
		}*/

	for(int i=0; i<NUM_OF_BLOCKS; i++)
		{
		unit_block[i]=load_bmp("form8.bmp",pal);
		if( !unit_block[i] ) result=FAILURE;
		else
			{
			/*SDL_Rect r;
			r.x=0;
			r.y=0;
			r.w=unit_block[i]->w;
			r.h=unit_block[i]->h;
			SDL_FillRect(unit_block[i],&r,i);*/
            rectfill(unit_block[i],0,0,UNIT_BLOCK_WIDTH,UNIT_BLOCK_HEIGHT,i);
			}
		}

	klogo=load_bmp("klogo8.bmp",pal);
	if( !klogo ) result=FAILURE;
	else
		{
		/*SDL_Rect r;
		r.x=0;
		r.y=0;
		r.w=klogo->w;
		r.h=klogo->h;
		value=SDL_MapRGB(klogo->format,0,0,0);
		SDL_SetColorKey(klogo,SDL_SRCCOLORKEY|SDL_RLEACCEL,value);
		
		pal=klogo->format->palette;
		SDL_SetColors(double_buffer,pal->colors,0,NCOLORS);
		value=SDL_MapRGB(double_buffer->format,0,0,0);
		SDL_SetColorKey(double_buffer,SDL_SRCCOLORKEY|SDL_RLEACCEL,value);*/
        set_palette(pal);
		} 

	return result;
	}

int init()
	{
    double_buffer = create_bitmap(640,480);
    if( double_buffer == NULL )
		{
        //fprintf(stderr,"Couldn't set %dx%dx%d video mode: %s\n",SCREEN_WIDTH,SCREEN_HEIGHT,BPP,SDL_GetError());
        return FAILURE;
		}
	//SDL_SetClipRect(double_buffer,NULL);
	/* disable the mouse */
	//SDL_ShowCursor(SDL_DISABLE);
	/* load all the sprites for the game */
    //while( !key[KEY_2] ){}
	if( load_sprites() == FAILURE ) 
		{
		//fprintf(stderr,"Error loading sprites.\n");
		return FAILURE;
		}
    text_mode(-1);
	/* set randome seed */
	srand((unsigned int)time(0));
	/* load pieces */
	g.load_pieces();
	/* load the high score */
	g.load_high();
	return SUCCESS;
	}

void run_kblocks(int n)
	{
	bool done=false;
	unsigned int last_game_step=retrace_count;
	unsigned int last_left,last_right,last_rotate,last_pause,last_down;
    PALETTE pal;
	last_left=last_right=last_rotate=last_down=last_pause=retrace_count;
	g.set_type(n);
	g.reset();

	while( done == false )
		{
		if( key[KEY_LEFT] && (retrace_count-last_left) > 8 )
			{
			g.try_move(-1,0); 
			last_left=retrace_count;
			}
		if( key[KEY_RIGHT] && (retrace_count-last_right) > 8 )
			{
			g.try_move(1,0); 
			last_right=retrace_count;
			}
		if( key[KEY_DOWN] && (retrace_count-last_down) > 2 )
			{
			g.try_move(0,1); 
			last_down=retrace_count;
			}
		if( key[KEY_UP] && (retrace_count-last_rotate) > 15 )
			{
			g.rotate_current_piece(); 
			last_rotate=retrace_count;
			}
		if( key[KEY_ESC] ) done=true;
		if( key[KEY_SPACE] && (retrace_count-last_pause) > 30 )
			{
			g.change_pause_state(); 
			last_pause=retrace_count;
			}
		if( key[KEY_P] )
			{
            get_palette(pal);
			save_bmp("sshot.bmp",double_buffer,pal);
			}
		/* most game functions */
		if( (retrace_count-last_game_step) > 26-g.get_level()*2  )
			{
			g.game_step();
			last_game_step=retrace_count;
			}

		g.display();
		} // end game loop
	}

void run_menu(void)
	{
	bool done=false;
	unsigned int last_up, last_down;
	int select=0, num_choices=4;
	last_down=last_up=retrace_count;

	while( !done )
		{
		if( key[KEY_UP] && (retrace_count-last_up) > 14 )
			{
			select--;
			if( select < 0 ) select+=num_choices;
			last_up=retrace_count;
			}
		if( key[KEY_DOWN] && (retrace_count-last_down) > 14 )
			{
			select=(select+1)%num_choices;
			last_down=retrace_count;
			}
		if( key[KEY_ENTER] )
			{
			switch(select)
				{
				case 0:	run_kblocks(4); break;
				case 1:	run_kblocks(5); break;
				case 2: show_keys(); break;
				case 3: done=true; break;
				}
			}
		g.display_menu(select);
		}
	}

void show_keys(void)
	{
    g.show_keys();
	while( !key[KEY_ESC] )
		{
		//SDL_PumpEvents();
		//keystate=SDL_GetKeyState(NULL);
		}
	}

/*void write_palette(void)
	{
	FILE *fp;
	fp=fopen("dbpal.txt","w");
	for(int i=0; i<NCOLORS; i++)
		{
		if( !(i%8) ) fprintf(fp,"\n%d: ",i);
		fprintf(fp," %.8X",*((double_buffer->format->palette)+i*sizeof(SDL_Color)));
		}
	fclose(fp);
	}*/

int main(int argc, char *argv[]) 
	{
    allegro_init();
    install_timer();
    install_keyboard();

    set_color_depth(8);
    set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
    if( init() == SUCCESS )
		{
        //while( !key[KEY_1] ){}
		run_menu();

		//write_palette();
		g.save_high();
		}

	free_all();
    remove_keyboard();
    remove_timer();
    allegro_exit();

	return 0;
	}
END_OF_MAIN();
