#include "game.h"

game::game()
	{
	}

game::~game()
	{
	//FILE *fp;
	//cpt4.clear();
	//cpt5.clear();
	//ascii_table.clear();
	//b.clear();
	//fp=fopen("test.txt","w");
	//fprintf(fp,"good so far");
	//fclose(fp);
	}

void game::display_info()
	{
	//SDL_Rect dest;
	char temp_string[80];

	/* display the game info */
	/*dest.x=SCREEN_WIDTH-50-(klogo->w);
	dest.y=SCREEN_HEIGHT-50-(klogo->h);
	dest.w=klogo->w;
	dest.h=klogo->h;
	SDL_BlitSurface(klogo,NULL,double_buffer,&dest);*/
    blit(klogo,double_buffer,0,0,SCREEN_WIDTH-50-(klogo->w),SCREEN_HEIGHT-50-(klogo->h),klogo->w,klogo->h);

	sprintf(temp_string,"All Time High");
	//ascii_table.display_text(temp_string,20*16,SCREEN_HEIGHT-64);
    textout(double_buffer,font,temp_string,20*16,SCREEN_HEIGHT-64,2);
	sprintf(temp_string,"Score: %d  Lines: %d  Pieces: %d",high_score,high_lines,high_pieces);
	//ascii_table.display_text(temp_string,20*16,SCREEN_HEIGHT-48);
    textout(double_buffer,font,temp_string,20*16,SCREEN_HEIGHT-48,2);
	sprintf(temp_string,"Copyright Krockertainment 2005");
	//ascii_table.display_text(temp_string,20*16,SCREEN_HEIGHT-32);
    textout(double_buffer,font,temp_string,20*16,SCREEN_HEIGHT-32,2);
	sprintf(temp_string,"Kblocks Version 4.0.0");
	//ascii_table.display_text(temp_string,20*16,SCREEN_HEIGHT-16);
    textout(double_buffer,font,temp_string,20*16,SCREEN_HEIGHT-16,2);
	}

void game::display()
	{
	char temp_string[80];

    acquire_screen();
    rectfill(double_buffer,0,0,639,479,0);
	if( paused == false )
		{
		b.display_board();
		current_piece->display_on_board();
		sprintf(temp_string,"NEXT");
        textout(double_buffer,font,temp_string,16*16,SCREEN_HEIGHT-(16*7),2);
		//ascii_table.display_text(temp_string,16*16,SCREEN_HEIGHT-(16*7));
		next_piece->display(14*16,SCREEN_HEIGHT-(16*6));
		}
	else 
		{
		sprintf(temp_string,"PAUSED");
		//ascii_table.display_text(temp_string,(10*16)/2,SCREEN_HEIGHT/2);
        textout(double_buffer,font,temp_string,(10*16)/2,SCREEN_HEIGHT/2,2);
		}

		
	/* display the game score, etc. */
	sprintf(temp_string,"Score:%d  Lines:%d  Level:%d  Pieces:%d",score,lines,level,pieces);
	//ascii_table.display_text(temp_string,15*16,0);
    textout(double_buffer,font,temp_string,15*16,12,2);

	display_info();

    //while( retrace_count < 2 ){}
    blit(double_buffer,screen,0,0,0,0,640,480);
    //rectfill(double_buffer,0,0,639,479,0);
    release_screen();
    //retrace_count=0;
	}

void game::display_menu(int select)
	{
	char temp_string[80];
    int w=17*8, h=9, x, y;

    acquire_screen();
    rectfill(double_buffer,0,0,639,479,0);

	if( select == 0 )
		{
		x=4*16-8;
		y=SCREEN_HEIGHT/2-20-1;
        rectfill(double_buffer,x,y,x+w,y+h,17);
		}
	sprintf(temp_string,"Start Game(4)");
	//ascii_table.display_text(temp_string,4*16,SCREEN_HEIGHT/2-32);
    textout(double_buffer,font,temp_string,4*16,SCREEN_HEIGHT/2-20,2);
	if( select == 1 ) 
		{
		x=4*16-8;
		y=SCREEN_HEIGHT/2-10-1;
        rectfill(double_buffer,x,y,x+w,y+h,17);
		}
	sprintf(temp_string,"Start Game(5)");
	//ascii_table.display_text(temp_string,4*16,SCREEN_HEIGHT/2-16);
    textout(double_buffer,font,temp_string,4*16,SCREEN_HEIGHT/2-10,2);
	if( select == 2 ) 
		{
		x=4*16-8;
		y=SCREEN_HEIGHT/2-1;
        rectfill(double_buffer,x,y,x+w,y+h,17);
		}
	sprintf(temp_string,"Help: Show Keys");
	//ascii_table.display_text(temp_string,4*16,SCREEN_HEIGHT/2);
    textout(double_buffer,font,temp_string,4*16,SCREEN_HEIGHT/2,2);
	if( select == 3 ) 
		{
		x=4*16-8;
		y=SCREEN_HEIGHT/2+10-1;
        rectfill(double_buffer,x,y,x+w,y+h,17);
		}
	sprintf(temp_string,"Exit KBlocks");
	//ascii_table.display_text(temp_string,4*16,SCREEN_HEIGHT/2+16);
    textout(double_buffer,font,temp_string,4*16,SCREEN_HEIGHT/2+10,2);

	/* display the game score, etc. */
	display_info();

	//ascii_table.display(0,0);
	/* swap double buffer */
	//SDL_Flip(double_buffer);
    //while( retrace_count < 2 ){}
    blit(double_buffer,screen,0,0,0,0,640,480);
    rectfill(double_buffer,0,0,639,479,0);
    release_screen();
    //retrace_count=0;
	}

void game::show_keys()
	{
	//SDL_Rect dest;
	char temp_string[80];

    acquire_screen();

    rectfill(double_buffer,0,0,639,479,0);

	/* display keys */
	sprintf(temp_string,"Escape: exit game/go back");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2-48);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2-48,2);
	sprintf(temp_string,"Up:     rotate piece");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2-32);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2-32,2);
	sprintf(temp_string,"Down:   slide the piece down");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2-16);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2-16,2);
	sprintf(temp_string,"Left:   move the piece left");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2,2);
	sprintf(temp_string,"Right:  move the piece right");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2+16);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2+16,2);
	sprintf(temp_string,"P:      save screenshot");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2+32);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2+32,2);
	sprintf(temp_string,"Space:  pause the game");
	//ascii_table.display_text(temp_string,16,SCREEN_HEIGHT/2+48);
    textout(double_buffer,font,temp_string,16,SCREEN_HEIGHT/2+48,2);


	/* display the game score, etc. */
	display_info();

	/* swap double buffer */
	//SDL_Flip(double_buffer);
    //while( retrace_count < 2 ){}
    blit(double_buffer,screen,0,0,0,0,640,480);
    rectfill(double_buffer,0,0,639,479,0);
    release_screen();
    //retrace_count=0;

	}

void game::game_step()
	{
	bool result;
	int lines_this_time;

	if( b.is_game_over() == true )
		{
		game_over=true;
		}
	if( game_over == false && paused == false )
		{
		/* move the piece down one */
		result=try_move(0,1);
		if( result == false )
			{
			/* add the piece to the board */
			b.drop_piece(*current_piece);
			lines_this_time=b.remove_lines();

			/* update score, etc. */
			score+=lines_this_time*lines_this_time*POINT_UNIT;
			lines+=lines_this_time;
			if( lines >= (level+1)*10 ) level++;
			if( level > 10 ) level=10;
			pieces++;

			/* go on to next piece */
			current_piece=next_piece;
			if( gtype == 5 ) next_piece=cpt5.return_random();
			else next_piece=cpt4.return_random();
			next_piece->reset();
			current_piece->reset();
			}
		update_high();
		}
	}

void game::reset()
	{
	score=0;
	lines=0;
	pieces=0;
	level=0;
	paused=false;
	game_over=false;
	b.reset();
	cpt4.reset();
	cpt5.reset();

	if( gtype == 5 )
		{
		current_piece = cpt5.return_random();
		next_piece = cpt5.return_random();
		}
	else
		{
		current_piece = cpt4.return_random();
		next_piece = cpt4.return_random();
		}
	}

void game::change_pause_state()
	{
	if( paused == true ) paused=false;
	else paused=true;
	}

bool game::is_overlap(piece *p)
	{
	bool result=false;
	for(int i=0; i<p->get_width(); i++)
		{
		for(int j=0; j<p->get_height(); j++)
			{
			if( p->get_grid_spot(i,j) != 0 && b.get_board_spot(p->get_x()+i,p->get_y()+j) != 0 ) result=true;
			}
		}
	return result;
	}

bool game::try_move(int dx, int dy)
	{
	bool result;
	/* make move */
	current_piece->move(dx,dy);
	/* confirm that move is legal */
	result=is_overlap(current_piece);
	/* if illegal, restore move */
	if( result == true ) 
		{
		current_piece->move(-1*dx,-1*dy);
		return false;
		}
	else return true;
	}

int game::get_level()
	{
	return level;
	}

void game::rotate_current_piece()
	{
	current_piece->rotate();
	if( is_overlap(current_piece) ) current_piece->reverse_rotate();
	}

void game::load_high()
	{
	FILE *fp;
	fp=fopen("hs.txt","r");
	if( fp )
		{
		fscanf(fp,"%d %d %d",&high_score,&high_lines,&high_pieces);
		fclose(fp);
		}
	}

void game::save_high()
	{
	FILE *fp;
	fp=fopen("hs.txt","w");
	fprintf(fp,"%d %d %d\n",high_score,high_lines,high_pieces);
	fclose(fp);
	}

void game::update_high()
	{
	if( score > high_score ) high_score=score;
	if( lines > high_lines ) high_lines=lines;
	if( pieces > high_pieces ) high_pieces=pieces;
	}

void game::set_type(int t)
	{
	gtype=t;
	}

void game::load_pieces()
	{
	piece *temp;

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); //  #
	temp->set_grid_spot(3,2,1); // ##
	temp->set_grid_spot(3,1,1); // #
	temp->set_grid_spot(2,3,1); //
	temp->set_color(4);
	//temp->set_color(c[4]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(2,1,1); // #
	temp->set_grid_spot(3,1,1); // #
	temp->set_grid_spot(2,3,1); //  
	temp->set_color(6);
	//temp->set_color(c[6]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // #
	temp->set_grid_spot(2,1,1); // #
	temp->set_grid_spot(2,4,1); // #
	temp->set_grid_spot(2,3,1); // #
	temp->set_color(8);
	//temp->set_color(c[8]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // #
	temp->set_grid_spot(2,1,1); // ##
	temp->set_grid_spot(3,2,1); //  #
	temp->set_grid_spot(3,3,1); // 
	temp->set_color(10);
	//temp->set_color(c[10]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(2,3,1); // ##
	temp->set_grid_spot(3,2,1); //  
	temp->set_grid_spot(3,3,1); // 
	temp->set_color(12);
	//temp->set_color(c[12]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(1,1,1); //  #
	temp->set_grid_spot(2,3,1); // 
	temp->set_color(14);
	//temp->set_color(c[14]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // #
	temp->set_grid_spot(3,2,1); // ##
	temp->set_grid_spot(2,1,1); // #
	temp->set_grid_spot(2,3,1); // 
	temp->set_color(16);
	//temp->set_color(c[16]);
	cpt4.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); //  #
	temp->set_grid_spot(3,2,1); // ##
	temp->set_grid_spot(3,1,1); // ##
	temp->set_grid_spot(2,3,1); //
	temp->set_grid_spot(3,3,1);
	temp->set_color(4);
	//temp->set_color(c[4]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // #
	temp->set_grid_spot(2,1,1); // ##
	temp->set_grid_spot(3,2,1); // ##
	temp->set_grid_spot(2,3,1); //  
	temp->set_grid_spot(3,3,1);
	temp->set_color(6);
	//temp->set_color(c[6]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // #
	temp->set_grid_spot(2,1,1); // #
	temp->set_grid_spot(2,4,1); // #
	temp->set_grid_spot(2,3,1); // #
	temp->set_grid_spot(2,0,1); // #
	temp->set_color(2);
	//temp->set_color(c[8]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // #
	temp->set_grid_spot(2,1,1); // ##
	temp->set_grid_spot(3,2,1); //  ##
	temp->set_grid_spot(3,3,1); // 
	temp->set_grid_spot(1,1,1); // 
	temp->set_color(10);
	//temp->set_color(c[10]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(1,1,1); // ###
	temp->set_grid_spot(2,1,1); // #
	temp->set_grid_spot(3,1,1); // #
	temp->set_grid_spot(1,2,1); // 
	temp->set_grid_spot(1,3,1); // 
	temp->set_color(12);
	//temp->set_color(c[12]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(1,1,1); //  #
	temp->set_grid_spot(2,3,1); //  #
	temp->set_grid_spot(2,4,1); // 
	temp->set_color(14);
	//temp->set_color(c[14]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(2,1,1); // #
	temp->set_grid_spot(3,1,1); // #
	temp->set_grid_spot(2,3,1); // #
	temp->set_grid_spot(2,4,1); // 
	temp->set_color(16);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(1,1,1); // ##
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(2,2,1); //  ##
	temp->set_grid_spot(2,3,1); // 
	temp->set_grid_spot(3,3,1); // 
	temp->set_color(18);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(3,1,1); //  ##
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(2,3,1); // 
	temp->set_grid_spot(1,3,1); // 
	temp->set_color(20);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(2,2,1); // ##
	temp->set_grid_spot(1,2,1); // #
	temp->set_grid_spot(1,3,1); // #
	temp->set_grid_spot(1,4,1); // 
	temp->set_color(22);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(2,2,1); //  #
	temp->set_grid_spot(2,3,1); // ##
	temp->set_grid_spot(1,3,1); // #
	temp->set_grid_spot(1,4,1); // 
	temp->set_color(24);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); //  
	temp->set_grid_spot(1,2,1); //  #
	temp->set_grid_spot(3,2,1); // ###
	temp->set_grid_spot(2,3,1); //  #
	temp->set_grid_spot(2,1,1); // 
	temp->set_color(26);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); //  
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(1,2,1); // ###
	temp->set_grid_spot(1,3,1); // #
	temp->set_grid_spot(3,2,1); // 
	temp->set_color(28);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,2,1); //  
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(1,2,1); // ###
	temp->set_grid_spot(3,3,1); //   #
	temp->set_grid_spot(3,2,1); // 
	temp->set_color(30);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,1,1); //  #
	temp->set_grid_spot(2,2,1); //  #
	temp->set_grid_spot(2,3,1); // ##
	temp->set_grid_spot(1,3,1); //  #
	temp->set_grid_spot(2,4,1); // 
	temp->set_color(32);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(1,1,1); // #
	temp->set_grid_spot(1,2,1); // #
	temp->set_grid_spot(2,3,1); // ##
	temp->set_grid_spot(1,3,1); // #
	temp->set_grid_spot(1,4,1); // 
	temp->set_color(34);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);

	temp = new piece;
	for(int i=0; i<temp->get_width(); i++) 
		{
		for(int j=0; j<temp->get_height(); j++)
			{
			temp->set_grid_spot(i,j,0);
			}
		}
	temp->set_grid_spot(2,1,1); //  
	temp->set_grid_spot(2,2,1); //  #
	temp->set_grid_spot(2,3,1); //  #
	temp->set_grid_spot(1,3,1); // ###
	temp->set_grid_spot(3,3,1); // 
	temp->set_color(36);
	//temp->set_color(c[16]);
	cpt5.add_piece(temp);
	}
