#ifndef SPRITE_H
#define SPRITE_H

#include <allegro.h>
#include "defines.h"

// define the sprite structure
typedef struct SPRITE
{
    int direction;
    int alive;
    int x, y;
    int width, height;
    int xspeed, yspeed;
    int xdelay, ydelay;
    int xcount, ycount;
    int curframe, maxframe, animdir;
    int framecount, framedelay;
} SPRITE;

typedef struct POINT
{
    int is_empty;
    int x, y;	
} POINT;

extern int yoffset;

int inside(int x, int y, int left, int top, int right, int bottom);
void updateSprite(SPRITE *spr);
BITMAP *grabFrame(BITMAP *source, int width, int height, int startx, int starty, int columns, int frame);
void bounceX_warpY(SPRITE *spr);

#endif