/*
    Game: AirForce
    Author: Leandro A. Dos Anjos    
    Date: 2012-10-25 (start)
    Language: C
    Library: Allegro 4.4.2 (MSVC9)
*/

#ifndef MAIN_H
#define MAIN_H

#include <allegro.h>
#include "mappyal.h"
#include "defines.h"
#include "sprite.h"
#include "player.h"
#include "enemy.h"
#include "bullet.h"
#include "menu.h"

/* Game States */
enum GAME_STATE
{
    GS_MAIN_MENU	,
    GS_NEW_GAME     ,
	GS_CREDITS      ,
	GS_PAUSED_GAME	,
    GS_END_GAME     ,
    GS_GAME_OVER    ,
    GS_EXIT
};

/* Bonus Items */
enum BONUS_ITEM
{
    BI_NONE,
    BI_SHOT,
    BI_SPEED,
    BI_SHOT_POWER,
    BI_SHOT_DOUBLE,
    BI_SHOT_TRIPLE
};

/* aux functions */
void fatalError(const char *message);

/* game functions */
int setupGame(void);
void runGame(void);
void renderGame(BITMAP *bmp);
void shutdownGame(void);
void exitGame(void);

/* game state functions */
void updateMainMenu(void);
void drawMainMenu(BITMAP *bmp);

void updateNewGame(void);
void drawNewGame(BITMAP *bmp);

void updateCredits(void);
void drawCredits(BITMAP *bmp);

void updateEndGame(void);
void drawEndGame(BITMAP *bmp);

void updatePausedGame(void);
void drawPausedGame(BITMAP *bmp);

/* general functions */
void mainMenu();
void newGame(int reset_data);
void pausedGame();
void gameOver();
void endGame();

void initPlayer(void);
void initBullets(void);
void initEnemies(void);
void initExplosion(void);
void initBonuses(void);
void initPositions(void);

void startExplosion(int x, int y);
void bounceX_warpY(SPRITE *spr);

/* miscelaneas  functions */
void createBonus(int bonus_item, int x, int y);
void drawRectangleDefault(BITMAP *bmp, int x1, int y1, int x2, int y2, int border);

/* updates functions */
void updateExplosions(void);
void updateBonuses(void);
void updatePlayerBullet(SPRITE *spr);
void updateEnemyBullet(BULLET bullet);
void updateBullets(void);
void updateScroller(void);
void updatePlayer(void);

void updateMovementsIA(ENEMY enemy);

/* drawers functions */
void drawScroller(BITMAP *bmp);
void drawPlayer(BITMAP *bmp);
void drawBullets(BITMAP *bmp);
void drawExplosions(BITMAP *bmp);
void drawBonuses(BITMAP *bmp);
void drawPlayerInfo(BITMAP *bmp, int life);
void drawDebugInfo(BITMAP *bmp);
void updateEnemies(void);
void drawEnemies(BITMAP *bmp);

/* maps functions */
int getMapWidth(void);
int getMapHeight(void);
int getMapSprite(int xo, int yo);
void setTile(int xo, int yo, int tile);
int switchLayer(int newlayer);

#endif