#ifndef DEFINES_H
#define DEFINES_H

#define G_WIDTH         640
#define G_HEIGHT        480
#define G_COL_DEPTH     32
#define G_MODE          GFX_AUTODETECT_WINDOWED
#define G_GAME_TITLE    "AirForce 1.0.0.0"

#define WHITE       makecol(255, 255, 255)
#define BLACK       makecol(0, 0, 0)
#define BLUE        makecol(0, 0, 255)
#define RED         makecol(255, 0, 0)
#define YELLOW      makecol(255, 255, 0)
#define ORANGE      makecol(255, 165, 0)
#define GRAY        makecol(190, 190, 190)
#define CYAN        makecol(0, 255, 255)
#define DARKGREEN   makecol(0, 100, 0)
#define GOLDENROD   makecol(218, 165, 32)
#define COLDGREY    makecol(128, 138, 135)

/* general constants */
#define DEBUG FALSE

#define MAP_SIZE 48000
#define MAX_PLAYER_BULLETS 20
#define MAX_ENEMIES_BULLETS 30
#define MAX_EXPLOSIONS 15
#define BOTTOM MAP_SIZE - G_HEIGHT

/* Constants */
#define UPDATES_PER_SECOND 60
#define ENABLE_MOUSE_SUPPORT FALSE


/* Player */
#define MAX_SPEED_PLAYER 5
#define MAX_SHOT_POWER_PLAYER 8

/* Enemies */
#define NUM_ENEMIES_TYPE 9
#define SPR_ENEMY_1 1
#define SPR_ENEMY_2 2
#define SPR_ENEMY_3 3
#define SPR_ENEMY_4 4
#define SPR_ENEMY_BOSS_1 5
#define SPR_ENEMY_BOSS_2 6
#define SPR_ENEMY_BOSS_3 7
#define SPR_ENEMY_SUBMARINE_LEFT 8
#define SPR_ENEMY_SUBMARINE_RIGHT 9

/* Bullets */
#define NUM_BULLETS_TYPE 6
#define SPR_BULLET_PLAYER_SINGLE 0
#define SPR_BULLET_PLAYER_DOUBLE 1
#define SPR_BULLET_PLAYER_TRIPLE 2
#define SPR_BULLET_ENEMY_SIMPLE 3
#define SPR_BULLET_BOSS_SIMPLE 4
#define SPR_BULLET_BOSS_3_SIMPLE 5

/* Sounds */
#define SND_MAX_MIDIS 3 // sempre aumentar ao criar um novo mid 
#define SND_MID_TITLE 0
#define SND_MID_LEGENDARY_WINGS 1
#define SND_MID_GAME_OVER 2

/* Positions */
#define PST_MAX_POSITIONS 4

#define SND_MAX_WAVES 5 // sempre aumentar ao criar um novo wav
#define SND_WAV_EXPLOSION_1 0
#define SND_WAV_EXPLOSION_2 1
#define SND_WAV_CURSOR_SELECTION 2
#define SND_WAV_ITEM_COLLECTED 3
#define SND_WAV_MENU_SELECT 4

#endif