#include "../include/sprite.h"

int inside(int x, int y, int left, int top, int right, int bottom)
{
	if (x > left && x < right && y > top && y < bottom)
		return 1;
	else
		return 0;
}

void updateSprite(SPRITE *spr)
{
	// update x position
	if (++spr->xcount > spr->xdelay)
	{
		spr->xcount = 0;
		spr->x += spr->xspeed;
	}

	// update y position
	if (++spr->ycount > spr->ydelay)
	{
		spr->ycount = 0;
		spr->y += spr->yspeed;
	}

	// update frame based on animdir
	if (++spr->framecount > spr->framedelay)
	{
		spr->framecount = 0;
		if (spr->animdir == -1)
		{
			if (--spr->curframe < 0)
				spr->curframe = spr->maxframe;
		}
		else if (spr->animdir == 1)
		{
			if (++spr->curframe > spr->maxframe)
				spr->curframe = 0;
		}
	}
}

BITMAP *grabFrame(BITMAP *source, 
				  int width, int height, 
				  int startx, int starty, 
				  int columns, int frame)
{
	BITMAP *bmp = create_bitmap(width, height);

	int x = startx + (frame % columns) * width;
	int y = starty + (frame / columns) * height;

	blit(source, bmp, x, y, 0, 0, width, height);

	return bmp;
}

void bounceX_warpY(SPRITE *spr)
{
	// bounces x off bounds
	if (spr->x < 0 - spr->width)
	{
		spr->x = 0 - spr->width + 1;
		spr->xspeed *= -1;
	}
	else if (spr->x > SCREEN_W)
	{
		spr->x = SCREEN_W - spr->xspeed;
		spr->xspeed *= -1;
	}

	// warps y if plane has passed the player
	if (spr->y > yoffset + 2000)
	{
		//respawn enemy plane
		spr->y = yoffset - 1000 - rand() % 1000;
		spr->alive = TRUE;
		spr->x = rand() % G_WIDTH;
	}

	// warps y from bottom to top of level
	if (spr->y < 0)
	{
		spr->y = 0;
	}
	else if (spr->y > MAP_SIZE)
	{
		spr->y = 0;
	}
}