#include "../include/input.h"

void moveUp(void)
{
	player.sprite->y -= player.move_speed;
	if (player.sprite->y < 50)
		player.sprite->y = 50;
}

void moveDown(void)
{
	player.sprite->y += player.move_speed;
	if (player.sprite->y > G_HEIGHT-65)
		player.sprite->y = G_HEIGHT-65;
}

void moveLeft(void)
{
	player.sprite->x -= player.move_speed;
	if (player.sprite->x < 0)
		player.sprite->x = 0;
}

void moveRight(void)
{
	player.sprite->x += player.move_speed;
	if (player.sprite->x > G_WIDTH-65)
		player.sprite->x = G_WIDTH-65;
}

void getJoystick(void)
{
	int b, n;

	if (num_joysticks)
	{
		// read the joystick
		poll_joystick();

		/* utiliza um for caso acha uma expanso para dois jogadores */
		for (n = 0; n < 1; n++)
		{
			// left stick
			if (joy[n].stick[0].axis[0].d1)
				moveLeft();

			// right stick
			if (joy[n].stick[0].axis[0].d2)
				moveRight();

			// up stick
			if (joy[n].stick[0].axis[1].d1)
				moveUp();

			// down stick
			if (joy[n].stick[0].axis[1].d2)
				moveDown();

			// any button will do
			for (b = 0; b < joy[n].num_buttons; b++)
			{
			    if (joy[n].button[b].b)
			    {
				    fireWeapon();
				    break;
			    }
			}
		}
	}        
}

void getInput(void)
{
	// check for keyboard input
	if (key[KEY_UP])
	{
		moveUp();
	}
	if (key[KEY_DOWN])
	{
		moveDown();
	}
	if (key[KEY_LEFT])
	{
		moveLeft();
	}
	if (key[KEY_RIGHT])
	{
		moveRight();
	}

	if (key[KEY_SPACE])
	{
		fireWeapon();
	}
}