#include "../include/map.h"

int getMapWidth(void)
{
    return mapwidth;
}

int getMapHeight(void)
{
    return mapheight;
}

int getMapSprite(int xo, int yo)
{
    return (MapGetBlock(xo, yo)->user1);
}

void setTile(int xo, int yo, int tile)
{
    MapSetBlock(xo, yo, tile);
}

int switchLayer(int newlayer)
{   
    return MapChangeLayer(newlayer);
}

/* Graphics functions */
void drawBGLayer(BITMAP *bmp, int x, int y)
{
    MapDrawBGT(bmp, x, y, 0, 0, bmp->w, bmp->h);
}

void drawFGLayer(BITMAP *bmp, int x, int y, int layer)
{
    MapDrawFG(bmp, x, y, 0, 0, bmp->w, bmp->h, layer);
}

void drawMySprite(BITMAP *spr_sheet, BITMAP *bmp, int type, int x, int y)
{
    masked_blit(spr_sheet, bmp, (type-1)*32, 0, x, y, 32, 32);
}

int checkMapCollision (int xo, int yo)
{
    BLKSTR * myblk;

    myblk = MapGetBlock (xo, yo);
    if (myblk->user5) return ((int) (myblk->user5));
    /*if (myblk->tr) return BL_STOPALL;
    if (myblk->tl) return BL_STOPSPRITE;*/
    return 0;
}


