#ifndef _PONG_H
#define _PONG_H

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include <allegro.h>

#include "constants.h"
#include "player.h"
#include "ball.h"

/* constants */
#define UPDATES_PER_SECOND 60
#define ENABLE_MOUSE_SUPPORT FALSE

/* global vars */
BITMAP *backbuffer = NULL;
DATAFILE *datFont = NULL;
DATAFILE *datSound = NULL;

typedef void (*funcptr)();

static const char *menuItems[] =
{
    "NORMAL GAME",
    "VERSUS GAME",
    "OPTIONS",
    "EXIT"
};

static const char *optionItems[] =
{
    "MAX BALL SPEED",
    "MAX POINT GAME",
    "BLIND SCREEN MODE",
    "GAME LEVEL",
};

static const char *optionItemsDescription[] = {
    "[ 1 ] = 10      [ 2 ] = 15      [ 3 ] = 18",
    "[ 1 ] = 15      [ 2 ] = 20      [ 3 ] = 30",
    "[ 0 ] = OFF     [ 1 ] = ON",
    "[ 1 ] = HUMAN   [ 2 ] = SPARTAN    [ 3 ] = GOD"
};

typedef enum {
    MAINMENUGAME, NORMALGAME, VERSUSGAME, OPTIONSGAME, WINNERGAME
} GAMESESSION;

GAMESESSION gameSession;

typedef struct MAINMENU
{   
    int menuSelection;
    int backgroundColor;
    int menuItemCount;
} MAINMENU;

MAINMENU mainmenu;

typedef struct OPTIONMENU
{   
    int optionSelection;
    int backgroundColor;
    int optionItemCount;
} OPTIONMENU;

OPTIONMENU optionmenu;

PLAYER P1, P2, CPU;
BALL bola;

int p1Score = 0;
int p2Score = 0;
int cpuScore = 0;

int game_level = 3;
int count_hit = 0;
int max_count_hit = 15;
int max_point_game = 12;
int winner_player = -1;
int enabled_blind_screen_mode = FALSE;

int fps = 0;
volatile int ticks = 0;
volatile int game_time = 0;
static volatile int done = FALSE;
int debug_mode = FALSE;

/* functions aux */
void errorExit(const char *message);

/* game functions */
int setupGame(void);
void renderGame(void);
void runGame(void);
void shutdownGame(void);
void exitGame(void);

#endif