/*
    Title: PONG by Laamaker
    Author: Leandro A. Dos Anjos
    Date: 2012-09-23
    Language: C
    Email: laamaker@gmail.com / laamaker@hotmail.com
*/

#include "constants.h"
#include "player.h"

void initPlayer(PLAYER *p)
{
    p->height = 100;
    p->width = 20;    
    p->y = SCREEN_H / 2 - p->height / 2;
    p->speed = 3;
    p->color = WHITE;
    
    switch (p->id)
    {
        case 0: // CPU
            p->x = 10;
            p->color = BLUE;
            break;
        case 1: // PLAYER 1
            p->x = 10;
            break;
        case 2: // PLAYER 2
            p->x = SCREEN_W - (10 + p->width);
            break;
    }
}

void movePlayer(PLAYER *p)
{
    clear_keybuf();

    if (p->id == 1)
    {
        if (key[KEY_W])
            p->y -= p->speed;
        if (key[KEY_S])
            p->y += p->speed;
    }
    else if (p->id == 2)
    {
        if (key[KEY_UP])
            p->y -= p->speed;
        if (key[KEY_DOWN])
            p->y += p->speed;
    }
    
    if (p->y < 0) p->y = 0;
    
    if (p->y + p->height >= SCREEN_H)
        p->y = SCREEN_H - p->height;
}

void drawPlayer(BITMAP *bmp, PLAYER *p)
{    
    rectfill(bmp, p->x, p->y, p->x + p->width, p->y + p->height, p->color);
}