/*
    Title: PONG by Laamaker
    Author: Leandro A. Dos Anjos
    Date: 2012-09-23
    Language: C
    Email: laamaker@gmail.com / laamaker@hotmail.com
*/

#include "constants.h"
#include "ball.h"

void initBall(BALL *b)
{   
    b->x = SCREEN_W / 2;
    b->y = SCREEN_H / 2;
    b->speed_x = b->speed_y = 3;
    b->radius = 8;
    b->color = WHITE;
    
    b->speed_x *= rand() % 2 < 1 ? -1 : 1;
    b->speed_y *= rand() % 2 < 1 ? -1 : 1;
}

void moveBall(BALL *b)
{
    b->x += b->speed_x;
    b->y += b->speed_y;

    /* limitando a bola nos limites da screen */
    if ((b->y - b->radius) < 0)
        b->speed_y *= (-1);
    if ((b->y + b->radius) > SCREEN_H)
        b->speed_y *= (-1);    
}

void drawBall(BITMAP *bmp, BALL *b)
{
    circlefill(bmp, b->x, b->y, b->radius, b->color);
}
