#include "stdafx.h"
#include "IRender.h"
#include "IInput.h"
#include "ISystem.h"
#include "ISound.h"
#include "ILogger.h"
#include "Game.h"
#include "Common.h"

int main()
{
	/*al_init();
	al_install_audio();
	al_init_acodec_addon();
	
	ALLEGRO_AUDIO_STREAM *pS = al_load_audio_stream( "Data/Music/Game music 1.it", 10, 1024 );
	const int freq = al_get_audio_stream_frequency( pS );
	ALLEGRO_AUDIO_DEPTH depth = al_get_audio_stream_depth( pS );
	ALLEGRO_VOICE *pV = al_create_voice( freq, depth, ALLEGRO_CHANNEL_CONF_2 );
	ALLEGRO_MIXER *pM = al_create_mixer( freq, depth, ALLEGRO_CHANNEL_CONF_2 );
	al_attach_mixer_to_voice( pM, pV );
	al_set_mixer_gain( pM, 0.2f );
	al_attach_audio_stream_to_mixer( pS, pM );
	
	{
		al_set_audio_stream_playing( pS, true );
	}
	al_destroy_audio_stream( pS );
	al_destroy_voice( pV );
	
	return 0;*/
	srand( time( 0 ) );
	GetLog().StartLogger( "game.log" );

	ISystem & sys = GetSystem();
	if ( !sys.Init() )
		return -1;

	sys.SetConfigName( "dd.cfg" );
	sys.LoadConfig();
	++g_options_version;

	ISound & sound = GetSound();
	sound.Init();

	const int masterVolume = sys.HasConfigValue( "DD_Sound", "Master" ) ? sys.GetConfigValue_Int( "DD_Sound", "Master" ) : 100;
	const int soundVolume = sys.HasConfigValue( "DD_Sound", "Sound" ) ? sys.GetConfigValue_Int( "DD_Sound", "Sound" ) : 100;
	const int musicVolume = sys.HasConfigValue( "DD_Sound", "Music" ) ? sys.GetConfigValue_Int( "DD_Sound", "Music" ) : 100;


	sound.SetMasterVolume( masterVolume / 100.0f );
	sound.SetVolumeByType( ISample::TYPE_SOUND, soundVolume / 100.0f );
	sound.SetVolumeByType( ISample::TYPE_MUSIC, musicVolume / 100.0f );

	int cfgW	= sys.GetConfigValue_Int( "DD_Graphics", "Width" );
	int cfgH	= sys.GetConfigValue_Int( "DD_Graphics", "Height" );
	int cfgB	= sys.GetConfigValue_Int( "DD_Graphics", "Depth" );
	//int cfgR	= sys.GetConfigValue_Int( "DD_Graphics", "Refresh" );
	int scaling	= sys.GetConfigValue_Int( "DD_Graphics", "Scaling" );
	if ( scaling == 0 )
		scaling = SCALING_KEEP_ASPECT;
	bool fullscreen = sys.GetConfigValue_Int( "DD_Graphics", "Fullscreen" );
	bool vsync = sys.HasConfigValue( "DD_Graphics", "VSync" ) ? sys.GetConfigValue_Int( "DD_Graphics", "VSync" ) : true;

	if ( cfgW <= 0 ) cfgW = 1024;
	if ( cfgH <= 0 ) cfgH = 768;
	if ( cfgB <= 0 ) cfgB = 32;

	IRender & render = GetRender();

	int renderType = sys.GetConfigValue_Int( "DD_Graphics", "RenderMode" );
	ERenderType realType = renderType == 0 ? RENDERTYPE_DIRECT3D : RENDERTYPE_OPENGL;
	if ( !render.Init( realType, cfgW, cfgH, cfgB, fullscreen, vsync, "Data/Fonts/CRYSRG__.TTF" ) )
		return -1;
	render.SetGlobalScaling( (EScalingMode)scaling, 1024, 768 );

	IInput & input = GetInput();
	if ( !input.Init( true, false, false ) )
		return -1;

	sys.SetWindowTitle( "DrDestructo2 v0.9" );

	Game game;
	game.Run();

	render.Clear();	
	
	//PROFILER_UPDATE(); // update all profiles
	/*std::string tmp = PROFILER_OUTPUT_FLAT_STRING(); // print to cout
	FILE *f=fopen("profiler.log","w");
	if (f)
	{
		fprintf( f, "%s", tmp.c_str() );
		fclose(f);
	}*/

//	PROFILER_DESTROY();

	return 0;
}
