#pragma once
#include "IRender.h"

/*
	Class for printing text in limited are with
	automatic word breaks. IGNORES line breaks!
*/
class TextPrinter
{
	const wchar_t *m_pText;
	int m_textLen;
	int m_wordEnd;
	int m_absIndex;
	int m_wordIndex;
	int m_cx;
	int m_cy;
	int m_x;
	int m_y;
	int m_w;
	int m_h;
	int m_textHeight;
	int m_textWidth;
public:
	TextPrinter()
		: m_pText( 0 )
		, m_textLen( 0 )
		, m_textHeight( 19 )
		, m_textWidth( 10 )
	{}

	void SetRegion( int x, int y, int w, int h );
	void SetTextParams( int width, int height );
	void SetText( const wchar_t *pText );
	bool Update( ImageHandle image, IRender & render );
	bool HasText() { return m_pText != 0; }
};
