#pragma once
#include "ResourceManager.h"
#include "ResourceHandle.h"

class Text
{
	const wchar_t *ptr;
public:
	Text()
		: ptr( L"" )
	{}

	Text( const wchar_t *p )
		: ptr( p )
	{}

	~Text()
	{
		delete [] ptr;
	}

	const wchar_t *text() const { return ptr; }
};

typedef Handle<Text> TextHandle;

struct Empty{};

class TextManager : public ResourceManager< Text*, Empty, 0, TextHandle >
{
public:
	Text *Create( const Empty & params ){ return 0; }
	Text *Load( const std::string & path );
	void Delete( Text *res );
	//void ReloadAllResources();
};


TextManager & GetTextManager();
