#include "stdafx.h"
#include "TextManager.h"

Text *TextManager::Load( const std::string & path )
{
	FILE *f = fopen( path.c_str(), "r" );
	if ( !f )
		return 0;

	fseek( f, 0, SEEK_END );
	const int fileSize = ftell( f );
	fseek( f, 0, SEEK_SET );
	if ( fileSize <= 0 )
	{
		fclose(f);
		return 0;
	}

	const size_t bufSize = fileSize / sizeof(unsigned short) + 1;

	wchar_t *ptr = new wchar_t[ bufSize ];
	
	int index = 0;
	while( !feof( f ) )
	{
	    unsigned short c = 0;
	    fread( &c, sizeof( unsigned short ), 1, f );
	    ptr[ index ] = c;
	    ++index;
	}
	//fread( (void*)&ptr[0], sizeof(wchar_t), fileSize/sizeof(wchar_t), f );
	ptr[ bufSize - 1 ] = L'\0';
	
	fclose(f);

	return new Text(ptr);
}

void TextManager::Delete( Text *res )
{
	delete res;
}

TextManager & GetTextManager()
{
	static TextManager m;
	return m;
}